/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.packet;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.api.minecraft.BlockChangeRecord;
import com.viaversion.viaversion.api.minecraft.BlockChangeRecord1_16_2;
import com.viaversion.viaversion.api.minecraft.BlockPosition;
import com.viaversion.viaversion.api.minecraft.ChunkPosition;
import com.viaversion.viaversion.api.minecraft.blockentity.BlockEntity;
import com.viaversion.viaversion.api.minecraft.chunks.PaletteType;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.libs.fastutil.ints.IntObjectPair;
import com.viaversion.viaversion.protocols.v1_21_5to1_21_6.packet.ClientboundPackets1_21_6;
import com.viaversion.viaversion.util.MathUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.chunk.BedrockBlockEntity;
import net.raphimc.viabedrock.api.chunk.BedrockChunk;
import net.raphimc.viabedrock.api.chunk.BlockEntityWithBlockState;
import net.raphimc.viabedrock.api.chunk.datapalette.BedrockBiomeArray;
import net.raphimc.viabedrock.api.chunk.datapalette.BedrockDataPalette;
import net.raphimc.viabedrock.api.chunk.section.BedrockChunkSection;
import net.raphimc.viabedrock.api.chunk.section.BedrockChunkSectionImpl;
import net.raphimc.viabedrock.api.model.entity.ClientPlayerEntity;
import net.raphimc.viabedrock.api.util.PacketFactory;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ClientboundBedrockPackets;
import net.raphimc.viabedrock.protocol.data.enums.Dimension;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.ServerboundLoadingScreenPacketType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.SpawnPositionType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.SubChunkPacket_HeightMapDataType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.SubChunkPacket_SubChunkRequestResult;
import net.raphimc.viabedrock.protocol.data.enums.java.Relative;
import net.raphimc.viabedrock.protocol.model.BlockChangeEntry;
import net.raphimc.viabedrock.protocol.model.Position3f;
import net.raphimc.viabedrock.protocol.rewriter.BlockEntityRewriter;
import net.raphimc.viabedrock.protocol.storage.BlobCache;
import net.raphimc.viabedrock.protocol.storage.ChunkTracker;
import net.raphimc.viabedrock.protocol.storage.EntityTracker;
import net.raphimc.viabedrock.protocol.storage.GameRulesStorage;
import net.raphimc.viabedrock.protocol.storage.GameSessionStorage;
import net.raphimc.viabedrock.protocol.storage.InventoryTracker;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;
import net.raphimc.viabedrock.protocol.types.array.ByteArrayType;

public class WorldPackets {
    private static final PacketHandler UPDATE_BLOCK_HANDLER = wrapper -> {
        ChunkTracker chunkTracker = (ChunkTracker)wrapper.user().get(ChunkTracker.class);
        BlockPosition position = (BlockPosition)wrapper.get(Types.BLOCK_POSITION1_14, 0);
        int blockState = (Integer)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_INT);
        wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_INT);
        int layer = (Integer)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_INT);
        if (layer < 0 || layer > 1) {
            wrapper.cancel();
            return;
        }
        IntObjectPair<BlockEntity> remappedBlock = chunkTracker.handleBlockChange(position, layer, blockState);
        if (remappedBlock == null) {
            wrapper.cancel();
            return;
        }
        wrapper.write((Type)Types.VAR_INT, (Object)remappedBlock.keyInt());
        if (remappedBlock.value() != null) {
            wrapper.send(BedrockProtocol.class);
            wrapper.cancel();
            PacketFactory.sendJavaBlockEntityData(wrapper.user(), position, (BlockEntity)remappedBlock.value());
        }
    };

    public static void register(BedrockProtocol protocol) {
        protocol.registerClientbound(ClientboundBedrockPackets.SET_SPAWN_POSITION, (ClientboundPacketType)ClientboundPackets1_21_6.SET_DEFAULT_SPAWN_POSITION, wrapper -> {
            ChunkTracker chunkTracker = (ChunkTracker)wrapper.user().get(ChunkTracker.class);
            int rawType = (Integer)wrapper.read((Type)BedrockTypes.VAR_INT);
            SpawnPositionType type = SpawnPositionType.getByValue(rawType);
            if (type == null) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unknown SpawnPositionType: " + rawType);
                wrapper.cancel();
                return;
            }
            BlockPosition compassPosition = (BlockPosition)wrapper.read(BedrockTypes.BLOCK_POSITION);
            Dimension dimension = Dimension.getByValue((Integer)wrapper.read((Type)BedrockTypes.VAR_INT));
            wrapper.read(BedrockTypes.BLOCK_POSITION);
            if (chunkTracker.getDimension() != dimension) {
                wrapper.cancel();
                return;
            }
            switch (type) {
                case WorldSpawn: {
                    wrapper.write(Types.BLOCK_POSITION1_14, (Object)compassPosition);
                    wrapper.write((Type)Types.FLOAT, (Object)Float.valueOf(0.0f));
                    break;
                }
                case PlayerRespawn: {
                    wrapper.cancel();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled SpawnPositionType: " + type);
                }
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.CHANGE_DIMENSION, (ClientboundPacketType)ClientboundPackets1_21_6.RESPAWN, wrapper -> {
            GameSessionStorage gameSession = (GameSessionStorage)wrapper.user().get(GameSessionStorage.class);
            InventoryTracker inventoryTracker = (InventoryTracker)wrapper.user().get(InventoryTracker.class);
            Dimension dimension = Dimension.values()[(Integer)wrapper.read((Type)BedrockTypes.VAR_INT)];
            Position3f position = (Position3f)wrapper.read(BedrockTypes.POSITION_3F);
            wrapper.read((Type)Types.BOOLEAN);
            Long loadingScreenId = (Boolean)wrapper.read((Type)Types.BOOLEAN) != false ? (Long)wrapper.read((Type)BedrockTypes.UNSIGNED_INT_LE) : null;
            if (dimension == ((ChunkTracker)wrapper.user().get(ChunkTracker.class)).getDimension()) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received CHANGE_DIMENSION packet for the same dimension");
            }
            wrapper.user().put((StorableObject)new ChunkTracker(wrapper.user(), dimension));
            EntityTracker oldEntityTracker = (EntityTracker)wrapper.user().get(EntityTracker.class);
            ClientPlayerEntity clientPlayer = oldEntityTracker.getClientPlayer();
            oldEntityTracker.prepareForRespawn();
            EntityTracker newEntityTracker = new EntityTracker(wrapper.user());
            newEntityTracker.addEntity(clientPlayer);
            wrapper.user().put((StorableObject)newEntityTracker);
            PacketFactory.sendBedrockLoadingScreen(wrapper.user(), ServerboundLoadingScreenPacketType.StartLoadingScreen, loadingScreenId);
            clientPlayer.setPosition(new Position3f(position.x(), position.y() + clientPlayer.eyeOffset(), position.z()));
            clientPlayer.setDimensionChangeInfo(new ClientPlayerEntity.DimensionChangeInfo(loadingScreenId));
            inventoryTracker.closeAllContainers();
            wrapper.write((Type)Types.VAR_INT, (Object)dimension.ordinal());
            wrapper.write(Types.STRING, (Object)dimension.getKey());
            wrapper.write((Type)Types.LONG, (Object)0L);
            wrapper.write((Type)Types.BYTE, (Object)((byte)clientPlayer.javaGameMode().ordinal()));
            wrapper.write((Type)Types.BYTE, (Object)-1);
            wrapper.write((Type)Types.BOOLEAN, (Object)false);
            wrapper.write((Type)Types.BOOLEAN, (Object)gameSession.isFlatGenerator());
            wrapper.write(Types.OPTIONAL_GLOBAL_POSITION, null);
            wrapper.write((Type)Types.VAR_INT, (Object)0);
            wrapper.write((Type)Types.VAR_INT, (Object)64);
            wrapper.write((Type)Types.BYTE, (Object)3);
            wrapper.send(BedrockProtocol.class);
            wrapper.cancel();
            clientPlayer.sendPlayerPositionPacketToClient(Relative.NONE);
            clientPlayer.sendAttribute("minecraft:health");
            clientPlayer.sendEffects();
            clientPlayer.setAbilities(clientPlayer.abilities());
            PacketFactory.sendJavaContainerSetContent(wrapper.user(), inventoryTracker.getInventoryContainer());
            inventoryTracker.getInventoryContainer().sendSelectedHotbarSlotToClient();
        });
        protocol.registerClientbound(ClientboundBedrockPackets.LEVEL_CHUNK, null, wrapper -> {
            BedrockChunk chunk;
            wrapper.cancel();
            ChunkTracker chunkTracker = (ChunkTracker)wrapper.user().get(ChunkTracker.class);
            GameSessionStorage gameSession = (GameSessionStorage)wrapper.user().get(GameSessionStorage.class);
            int chunkX = (Integer)wrapper.read((Type)BedrockTypes.VAR_INT);
            int chunkZ = (Integer)wrapper.read((Type)BedrockTypes.VAR_INT);
            Dimension dimension = Dimension.getByValue((Integer)wrapper.read((Type)BedrockTypes.VAR_INT));
            if (dimension != chunkTracker.getDimension()) {
                return;
            }
            int sectionCount = (Integer)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_INT);
            if (sectionCount < -2) {
                return;
            }
            int startY = chunkTracker.getMinY() >> 4;
            int endY = chunkTracker.getMaxY() >> 4;
            int requestSectionCount = 0;
            if (sectionCount == -2) {
                requestSectionCount = (Integer)wrapper.read((Type)BedrockTypes.UNSIGNED_SHORT_LE) + 1;
            } else if (sectionCount == -1) {
                requestSectionCount = endY - startY;
            }
            BedrockChunk previousChunk = chunkTracker.getChunk(chunkX, chunkZ);
            if (previousChunk != null) {
                chunkTracker.unloadChunk(new ChunkPosition(chunkX, chunkZ));
                if (previousChunk.isRequestSubChunks()) {
                    requestSectionCount = endY - startY;
                }
            }
            if ((chunk = chunkTracker.createChunk(chunkX, chunkZ, sectionCount < 0 ? requestSectionCount : sectionCount)) == null) {
                return;
            }
            chunk.setRequestSubChunks(sectionCount < 0);
            int fRequestSectionCount = requestSectionCount;
            Consumer<byte[]> dataConsumer = combinedData -> {
                try {
                    if (fRequestSectionCount > 0) {
                        chunkTracker.requestSubChunks(chunkX, chunkZ, startY, MathUtil.clamp((int)(startY + fRequestSectionCount), (int)(startY + 1), (int)endY));
                    }
                    ByteBuf dataBuf = Unpooled.wrappedBuffer((byte[])combinedData);
                    BedrockChunkSection[] sections = chunk.getSections();
                    List blockEntities = chunk.blockEntities();
                    try {
                        int i;
                        for (i = 0; i < sectionCount; ++i) {
                            sections[i].mergeWith(chunkTracker.handleBlockPalette((BedrockChunkSection)BedrockTypes.CHUNK_SECTION.read(dataBuf)));
                            sections[i].applyPendingBlockUpdates(chunkTracker.airId());
                        }
                        if (gameSession.getBedrockVanillaVersion().isLowerThan("1.18.0")) {
                            byte[] biomeData = new byte[256];
                            dataBuf.readBytes(biomeData);
                            for (BedrockChunkSection section : sections) {
                                section.addPalette(PaletteType.BIOMES, new BedrockBiomeArray(biomeData));
                            }
                        } else {
                            for (i = 0; i < sections.length; ++i) {
                                BedrockDataPalette biomePalette = (BedrockDataPalette)BedrockTypes.RUNTIME_DATA_PALETTE.read(dataBuf);
                                if (biomePalette == null) {
                                    if (i == 0) {
                                        throw new RuntimeException("First biome palette can not point to previous biome palette");
                                    }
                                    biomePalette = ((BedrockDataPalette)sections[i - 1].palette(PaletteType.BIOMES)).clone();
                                }
                                sections[i].addPalette(PaletteType.BIOMES, biomePalette);
                            }
                        }
                        dataBuf.skipBytes(1);
                        while (dataBuf.isReadable()) {
                            Tag tag = (Tag)BedrockTypes.NETWORK_TAG.read(dataBuf);
                            if (!(tag instanceof CompoundTag)) continue;
                            blockEntities.add(new BedrockBlockEntity((CompoundTag)tag));
                        }
                    }
                    catch (IndexOutOfBoundsException tag) {
                    }
                    catch (Throwable e) {
                        ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Error reading chunk data", e);
                    }
                    if (!chunk.isRequestSubChunks()) {
                        chunkTracker.sendChunk(chunkX, chunkZ);
                    }
                }
                catch (Throwable e) {
                    throw new RuntimeException("Error handling chunk data", e);
                }
            };
            if (((Boolean)wrapper.read((Type)Types.BOOLEAN)).booleanValue()) {
                int expectedLength;
                Long[] blobs = (Long[])wrapper.read(BedrockTypes.LONG_ARRAY);
                int n = expectedLength = sectionCount < 0 ? 1 : sectionCount + 1;
                if (blobs.length != expectedLength) {
                    throw new IllegalStateException("Invalid blob count: " + blobs.length + " (expected " + expectedLength + ")");
                }
                byte[] data = (byte[])wrapper.read(BedrockTypes.BYTE_ARRAY);
                ((BlobCache)wrapper.user().get(BlobCache.class)).getBlob(blobs).thenAccept(blob -> {
                    byte[] combinedData = new byte[data.length + ((byte[])blob).length];
                    System.arraycopy(blob, 0, combinedData, 0, ((byte[])blob).length);
                    System.arraycopy(data, 0, combinedData, ((byte[])blob).length, data.length);
                    dataConsumer.accept(combinedData);
                });
            } else {
                dataConsumer.accept((byte[])wrapper.read(BedrockTypes.BYTE_ARRAY));
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.SUB_CHUNK, null, wrapper -> {
            wrapper.cancel();
            ChunkTracker chunkTracker = (ChunkTracker)wrapper.user().get(ChunkTracker.class);
            boolean cachingEnabled = (Boolean)wrapper.read((Type)Types.BOOLEAN);
            Dimension dimension = Dimension.getByValue((Integer)wrapper.read((Type)BedrockTypes.VAR_INT));
            if (dimension != chunkTracker.getDimension()) {
                return;
            }
            BlockPosition center = (BlockPosition)wrapper.read(BedrockTypes.POSITION_3I);
            long count = (Long)wrapper.read((Type)BedrockTypes.UNSIGNED_INT_LE);
            for (long i = 0L; i < count; ++i) {
                SubChunkPacket_HeightMapDataType renderHeightmapResult;
                BlockPosition offset = (BlockPosition)wrapper.read(BedrockTypes.SUB_CHUNK_OFFSET);
                SubChunkPacket_SubChunkRequestResult result = SubChunkPacket_SubChunkRequestResult.getByValue(((Byte)wrapper.read((Type)Types.BYTE)).byteValue(), SubChunkPacket_SubChunkRequestResult.Undefined);
                byte[] data = result != SubChunkPacket_SubChunkRequestResult.SuccessAllAir || !cachingEnabled ? (byte[])wrapper.read(BedrockTypes.BYTE_ARRAY) : new byte[]{};
                SubChunkPacket_HeightMapDataType heightmapResult = SubChunkPacket_HeightMapDataType.getByValue(((Byte)wrapper.read((Type)Types.BYTE)).byteValue(), SubChunkPacket_HeightMapDataType.NoData);
                if (heightmapResult == SubChunkPacket_HeightMapDataType.HasData) {
                    wrapper.read((Type)new ByteArrayType(256));
                }
                if ((renderHeightmapResult = SubChunkPacket_HeightMapDataType.getByValue(((Byte)wrapper.read((Type)Types.BYTE)).byteValue(), SubChunkPacket_HeightMapDataType.NoData)) == SubChunkPacket_HeightMapDataType.HasData) {
                    wrapper.read((Type)new ByteArrayType(256));
                }
                BlockPosition absolute = new BlockPosition(center.x() + offset.x(), center.y() + offset.y(), center.z() + offset.z());
                Consumer<byte[]> dataConsumer = combinedData -> {
                    block10: {
                        try {
                            if (result == SubChunkPacket_SubChunkRequestResult.SuccessAllAir) {
                                if (chunkTracker.mergeSubChunk(absolute.x(), absolute.y(), absolute.z(), new BedrockChunkSectionImpl(), new ArrayList<BedrockBlockEntity>())) {
                                    chunkTracker.sendChunkInNextTick(absolute.x(), absolute.z());
                                }
                                break block10;
                            }
                            if (result == SubChunkPacket_SubChunkRequestResult.Success) {
                                ByteBuf dataBuf = Unpooled.wrappedBuffer((byte[])combinedData);
                                BedrockChunkSection section = new BedrockChunkSectionImpl();
                                ArrayList<BedrockBlockEntity> blockEntities = new ArrayList<BedrockBlockEntity>();
                                try {
                                    section = (BedrockChunkSection)BedrockTypes.CHUNK_SECTION.read(dataBuf);
                                    while (dataBuf.isReadable()) {
                                        Tag tag = (Tag)BedrockTypes.NETWORK_TAG.read(dataBuf);
                                        if (!(tag instanceof CompoundTag)) continue;
                                        blockEntities.add(new BedrockBlockEntity((CompoundTag)tag));
                                    }
                                }
                                catch (IndexOutOfBoundsException tag) {
                                }
                                catch (Throwable e) {
                                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Error reading sub chunk data", e);
                                }
                                if (chunkTracker.mergeSubChunk(absolute.x(), absolute.y(), absolute.z(), section, blockEntities)) {
                                    chunkTracker.sendChunkInNextTick(absolute.x(), absolute.z());
                                }
                                break block10;
                            }
                            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received sub chunk with result " + result);
                            chunkTracker.requestSubChunk(absolute.x(), absolute.y(), absolute.z());
                        }
                        catch (Throwable e) {
                            throw new RuntimeException("Error handling sub chunk data", e);
                        }
                    }
                };
                if (cachingEnabled) {
                    long hash = (Long)wrapper.read((Type)BedrockTypes.LONG_LE);
                    ((BlobCache)wrapper.user().get(BlobCache.class)).getBlob(hash).thenAccept(blob -> {
                        if (data.length == 0) {
                            dataConsumer.accept((byte[])blob);
                        } else if (((byte[])blob).length == 0) {
                            dataConsumer.accept(data);
                        } else {
                            byte[] combinedData = new byte[data.length + ((byte[])blob).length];
                            System.arraycopy(blob, 0, combinedData, 0, ((byte[])blob).length);
                            System.arraycopy(data, 0, combinedData, ((byte[])blob).length, data.length);
                            dataConsumer.accept(combinedData);
                        }
                    });
                    continue;
                }
                dataConsumer.accept(data);
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.UPDATE_BLOCK, (ClientboundPacketType)ClientboundPackets1_21_6.BLOCK_UPDATE, (PacketHandler)new PacketHandlers(){

            protected void register() {
                this.map(BedrockTypes.BLOCK_POSITION, Types.BLOCK_POSITION1_14);
                this.handler(UPDATE_BLOCK_HANDLER);
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.UPDATE_BLOCK_SYNCED, (ClientboundPacketType)ClientboundPackets1_21_6.BLOCK_UPDATE, (PacketHandler)new PacketHandlers(){

            protected void register() {
                this.map(BedrockTypes.BLOCK_POSITION, Types.BLOCK_POSITION1_14);
                this.handler(UPDATE_BLOCK_HANDLER);
                this.read(BedrockTypes.UNSIGNED_VAR_LONG);
                this.read(BedrockTypes.UNSIGNED_VAR_LONG);
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.UPDATE_SUB_CHUNK_BLOCKS, null, wrapper -> {
            wrapper.cancel();
            ChunkTracker chunkTracker = (ChunkTracker)wrapper.user().get(ChunkTracker.class);
            wrapper.read(BedrockTypes.BLOCK_POSITION);
            BlockChangeEntry[][] blockUpdatesArray = new BlockChangeEntry[][]{(BlockChangeEntry[])wrapper.read(BedrockTypes.BLOCK_CHANGE_ENTRY_ARRAY), (BlockChangeEntry[])wrapper.read(BedrockTypes.BLOCK_CHANGE_ENTRY_ARRAY)};
            HashMap<BlockPosition, List> blockChanges = new HashMap<BlockPosition, List>();
            HashMap<BlockPosition, BlockEntity> blockEntities = new HashMap<BlockPosition, BlockEntity>();
            for (int layer = 0; layer < blockUpdatesArray.length; ++layer) {
                for (BlockChangeEntry entry : blockUpdatesArray[layer]) {
                    IntObjectPair<BlockEntity> remappedBlock = chunkTracker.handleBlockChange(entry.position(), layer, entry.blockState());
                    if (remappedBlock == null) continue;
                    if (remappedBlock.value() != null) {
                        blockEntities.put(entry.position(), (BlockEntity)remappedBlock.value());
                    }
                    BlockPosition chunkPosition = new BlockPosition(entry.position().x() >> 4, entry.position().y() >> 4, entry.position().z() >> 4);
                    BlockPosition relative = new BlockPosition(entry.position().x() & 0xF, entry.position().y() & 0xF, entry.position().z() & 0xF);
                    blockChanges.computeIfAbsent(chunkPosition, k -> new ArrayList()).add(new BlockChangeRecord1_16_2(relative.x(), relative.y(), relative.z(), remappedBlock.keyInt()));
                }
            }
            for (Map.Entry entry : blockChanges.entrySet()) {
                BlockPosition chunkPosition = (BlockPosition)entry.getKey();
                List changes = (List)entry.getValue();
                long chunkKey = ((long)chunkPosition.x() & 0x3FFFFFL) << 42 | ((long)chunkPosition.z() & 0x3FFFFFL) << 20 | (long)chunkPosition.y() & 0xFFFL;
                PacketWrapper multiBlockChange = wrapper.create((PacketType)ClientboundPackets1_21_6.SECTION_BLOCKS_UPDATE);
                multiBlockChange.write((Type)Types.LONG, (Object)chunkKey);
                multiBlockChange.write(Types.VAR_LONG_BLOCK_CHANGE_ARRAY, (Object)changes.toArray(new BlockChangeRecord[0]));
                multiBlockChange.send(BedrockProtocol.class);
            }
            for (Map.Entry entry : blockEntities.entrySet()) {
                PacketFactory.sendJavaBlockEntityData(wrapper.user(), (BlockPosition)entry.getKey(), (BlockEntity)entry.getValue());
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.BLOCK_ENTITY_DATA, (ClientboundPacketType)ClientboundPackets1_21_6.BLOCK_ENTITY_DATA, (PacketHandler)new PacketHandlers(){

            protected void register() {
                this.map(BedrockTypes.BLOCK_POSITION, Types.BLOCK_POSITION1_14);
                this.handler(wrapper -> {
                    Tag tag = (Tag)wrapper.read(BedrockTypes.NETWORK_TAG);
                    if (!(tag instanceof CompoundTag)) {
                        wrapper.cancel();
                        return;
                    }
                    ChunkTracker chunkTracker = (ChunkTracker)wrapper.user().get(ChunkTracker.class);
                    BedrockBlockEntity bedrockBlockEntity = new BedrockBlockEntity((BlockPosition)wrapper.get(Types.BLOCK_POSITION1_14, 0), (CompoundTag)tag);
                    chunkTracker.addBlockEntity(bedrockBlockEntity);
                    BlockEntity javaBlockEntity = BlockEntityRewriter.toJava(wrapper.user(), chunkTracker.getBlockState(bedrockBlockEntity.position()), bedrockBlockEntity);
                    if (javaBlockEntity instanceof BlockEntityWithBlockState) {
                        BlockEntityWithBlockState blockEntityWithBlockState = (BlockEntityWithBlockState)javaBlockEntity;
                        PacketFactory.sendJavaBlockUpdate(wrapper.user(), bedrockBlockEntity.position(), blockEntityWithBlockState.blockState());
                    }
                    if (javaBlockEntity != null && javaBlockEntity.tag() != null) {
                        wrapper.write((Type)Types.VAR_INT, (Object)javaBlockEntity.typeId());
                        wrapper.write(Types.COMPOUND_TAG, (Object)javaBlockEntity.tag());
                    } else {
                        wrapper.cancel();
                    }
                });
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.NETWORK_CHUNK_PUBLISHER_UPDATE, (ClientboundPacketType)ClientboundPackets1_21_6.SET_CHUNK_CACHE_RADIUS, wrapper -> {
            BlockPosition position = (BlockPosition)wrapper.read(BedrockTypes.POSITION_3I);
            int radius = (Integer)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_INT) >> 4;
            wrapper.write((Type)Types.VAR_INT, (Object)radius);
            ChunkTracker chunkTracker = (ChunkTracker)wrapper.user().get(ChunkTracker.class);
            chunkTracker.setRadius(radius);
            chunkTracker.setCenter(position.x() >> 4, position.z() >> 4);
            PacketWrapper updateViewPosition = wrapper.create((PacketType)ClientboundPackets1_21_6.SET_CHUNK_CACHE_CENTER);
            updateViewPosition.write((Type)Types.VAR_INT, (Object)(position.x() >> 4));
            updateViewPosition.write((Type)Types.VAR_INT, (Object)(position.z() >> 4));
            updateViewPosition.send(BedrockProtocol.class);
            int count = (Integer)wrapper.read((Type)BedrockTypes.INT_LE);
            for (int i = 0; i < count; ++i) {
                wrapper.read((Type)BedrockTypes.VAR_INT);
                wrapper.read((Type)BedrockTypes.VAR_INT);
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.CHUNK_RADIUS_UPDATED, (ClientboundPacketType)ClientboundPackets1_21_6.SET_CHUNK_CACHE_RADIUS, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(BedrockTypes.VAR_INT, (Type)Types.VAR_INT);
                this.handler(wrapper -> ((ChunkTracker)wrapper.user().get(ChunkTracker.class)).setRadius((Integer)wrapper.get((Type)Types.VAR_INT, 0)));
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.SET_TIME, (ClientboundPacketType)ClientboundPackets1_21_6.SET_TIME, wrapper -> {
            wrapper.write((Type)Types.LONG, (Object)((GameSessionStorage)wrapper.user().get(GameSessionStorage.class)).getLevelTime());
            long bedrockTime = ((Integer)wrapper.read((Type)BedrockTypes.VAR_INT)).intValue();
            wrapper.write((Type)Types.LONG, (Object)(bedrockTime >= 0L ? bedrockTime % 24000L : 24000L + bedrockTime % 24000L));
            wrapper.write((Type)Types.BOOLEAN, (Object)((Boolean)((GameRulesStorage)wrapper.user().get(GameRulesStorage.class)).getGameRule("doDayLightCycle")));
        });
    }
}

