/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.provider.impl;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.raphimc.viabedrock.api.model.resourcepack.ResourcePack;
import net.raphimc.viabedrock.protocol.provider.ResourcePackProvider;

public class InMemoryResourcePackProvider
extends ResourcePackProvider {
    private final Map<String, byte[]> packs = new ConcurrentHashMap<String, byte[]>();

    @Override
    public boolean hasPack(ResourcePack pack) {
        return this.packs.containsKey(this.getPackKey(pack));
    }

    @Override
    public void loadPack(ResourcePack pack) throws Exception {
        if (!this.hasPack(pack)) {
            throw new IOException("Pack not found");
        }
        byte[] data = this.packs.get(this.getPackKey(pack));
        pack.setContentKey(new byte[0]);
        pack.setCompressedDataLength(data.length, data.length);
        pack.processDataChunk(0, data);
    }

    @Override
    public void addPack(ResourcePack pack) throws IOException {
        this.packs.put(this.getPackKey(pack), pack.content().toZip());
    }

    private String getPackKey(ResourcePack pack) {
        return pack.packId() + "_" + pack.version();
    }
}

