/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.rewriter.resourcepack;

import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.raphimc.viabedrock.api.model.resourcepack.ResourcePack;
import net.raphimc.viabedrock.api.model.resourcepack.TextureDefinitions;
import net.raphimc.viabedrock.protocol.rewriter.resourcepack.ItemModelResourceRewriter;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;

public class CustomItemTextureResourceRewriter
extends ItemModelResourceRewriter {
    public CustomItemTextureResourceRewriter() {
        super("item_texture", "item");
    }

    @Override
    protected void apply(ResourcePacksStorage resourcePacksStorage, ResourcePack.Content javaContent, Set<String> modelsList) {
        for (Map.Entry<String, List<TextureDefinitions.ItemTextureDefinition>> entry : resourcePacksStorage.getTextures().itemTextures().entrySet()) {
            block1: for (int i = 0; i < entry.getValue().size(); ++i) {
                TextureDefinitions.ItemTextureDefinition itemTextureDefinition = entry.getValue().get(i);
                for (ResourcePack pack : resourcePacksStorage.getPackStackTopToBottom()) {
                    ResourcePack.Content bedrockContent = pack.content();
                    ResourcePack.Content.LazyImage texture = bedrockContent.getShortnameImage(itemTextureDefinition.texturePath());
                    if (texture == null) continue;
                    javaContent.putPngImage("assets/viabedrock/textures/" + this.getJavaTexturePath(itemTextureDefinition.texturePath()) + ".png", texture);
                    JsonObject itemModel = new JsonObject();
                    itemModel.addProperty("parent", "minecraft:item/generated");
                    JsonObject layer0 = new JsonObject();
                    layer0.addProperty("layer0", "viabedrock:" + this.getJavaTexturePath(itemTextureDefinition.texturePath()));
                    itemModel.add("textures", (JsonElement)layer0);
                    javaContent.putJson("assets/viabedrock/models/" + this.getJavaModelName(entry.getKey() + "_" + i) + ".json", itemModel);
                    modelsList.add(entry.getKey() + "_" + i);
                    continue block1;
                }
            }
        }
    }
}

