/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.storage;

import com.viaversion.viaversion.api.connection.StoredObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.BlockPosition;
import com.viaversion.viaversion.api.minecraft.ChunkPosition;
import com.viaversion.viaversion.api.minecraft.entities.EntityType;
import com.viaversion.viaversion.api.minecraft.entities.EntityTypes1_21_6;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.protocols.v1_21_5to1_21_6.packet.ClientboundPackets1_21_6;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.BlockState;
import net.raphimc.viabedrock.api.model.entity.AbstractHorseEntity;
import net.raphimc.viabedrock.api.model.entity.ClientPlayerEntity;
import net.raphimc.viabedrock.api.model.entity.Entity;
import net.raphimc.viabedrock.api.model.entity.LivingEntity;
import net.raphimc.viabedrock.api.model.entity.MobEntity;
import net.raphimc.viabedrock.api.model.entity.PlayerEntity;
import net.raphimc.viabedrock.protocol.BedrockProtocol;

public class EntityTracker
extends StoredObject {
    private final AtomicInteger ID_COUNTER = new AtomicInteger(1);
    private ClientPlayerEntity clientPlayerEntity = null;
    private final Map<Long, Entity> entities = new HashMap<Long, Entity>();
    private final Map<Long, Long> runtimeIdToUniqueId = new HashMap<Long, Long>();
    private final Map<Integer, Long> javaIdToUniqueId = new HashMap<Integer, Long>();
    private final Map<BlockPosition, Integer> itemFrames = new HashMap<BlockPosition, Integer>();

    public EntityTracker(UserConnection user) {
        super(user);
    }

    public Entity addEntity(long uniqueId, long runtimeId, String type, EntityTypes1_21_6 javaType) {
        UUID javaUuid = UUID.randomUUID();
        if (javaType.isOrHasParent((EntityType)EntityTypes1_21_6.ABSTRACT_HORSE)) {
            return this.addEntity(new AbstractHorseEntity(this.user(), uniqueId, runtimeId, type, this.getNextJavaEntityId(), javaUuid, javaType));
        }
        if (javaType.isOrHasParent((EntityType)EntityTypes1_21_6.MOB)) {
            return this.addEntity(new MobEntity(this.user(), uniqueId, runtimeId, type, this.getNextJavaEntityId(), javaUuid, javaType));
        }
        if (javaType.isOrHasParent((EntityType)EntityTypes1_21_6.LIVING_ENTITY)) {
            return this.addEntity(new LivingEntity(this.user(), uniqueId, runtimeId, type, this.getNextJavaEntityId(), javaUuid, javaType));
        }
        return this.addEntity(new Entity(this.user(), uniqueId, runtimeId, type, this.getNextJavaEntityId(), javaUuid, javaType));
    }

    public <T extends Entity> T addEntity(T entity) {
        return this.addEntity(entity, true);
    }

    public <T extends Entity> T addEntity(T entity, boolean updateTeam) {
        Entity prevEntity;
        if (entity instanceof ClientPlayerEntity) {
            this.clientPlayerEntity = (ClientPlayerEntity)entity;
        }
        if ((prevEntity = this.entities.put(entity.uniqueId(), entity)) != null) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Duplicate unique entity ID: " + entity.uniqueId());
            this.removeEntity(prevEntity);
            PacketWrapper removeEntities = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.REMOVE_ENTITIES, (UserConnection)this.user());
            removeEntities.write(Types.VAR_INT_ARRAY_PRIMITIVE, (Object)new int[]{prevEntity.javaId()});
            removeEntities.send(BedrockProtocol.class);
        }
        if (this.javaIdToUniqueId.put(entity.javaId(), entity.uniqueId()) != null) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Duplicate Java entity ID: " + entity.javaId());
        }
        if (this.runtimeIdToUniqueId.putIfAbsent(entity.runtimeId(), entity.uniqueId()) != null) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Duplicate runtime entity ID: " + entity.runtimeId());
        }
        if (updateTeam && entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            player.createTeam();
        }
        return entity;
    }

    public void removeEntity(Entity entity) {
        if (entity instanceof ClientPlayerEntity) {
            throw new IllegalArgumentException("Cannot remove client player entity");
        }
        this.entities.remove(entity.uniqueId());
        this.runtimeIdToUniqueId.remove(entity.runtimeId());
        this.javaIdToUniqueId.remove(entity.javaId());
        entity.remove();
    }

    public void spawnItemFrame(BlockPosition position, BlockState blockState) {
        this.removeItemFrame(position);
        if (!blockState.identifier().equals("frame") && !blockState.identifier().equals("glow_frame")) {
            throw new IllegalArgumentException("Block state must be a frame or glow_frame");
        }
        int javaId = this.getNextJavaEntityId();
        this.itemFrames.put(position, javaId);
        PacketWrapper spawnEntity = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.ADD_ENTITY, (UserConnection)this.user());
        spawnEntity.write((Type)Types.VAR_INT, (Object)javaId);
        spawnEntity.write(Types.UUID, (Object)UUID.randomUUID());
        spawnEntity.write((Type)Types.VAR_INT, (Object)(blockState.identifier().equals("frame") ? EntityTypes1_21_6.ITEM_FRAME.getId() : EntityTypes1_21_6.GLOW_ITEM_FRAME.getId()));
        spawnEntity.write((Type)Types.DOUBLE, (Object)position.x());
        spawnEntity.write((Type)Types.DOUBLE, (Object)position.y());
        spawnEntity.write((Type)Types.DOUBLE, (Object)position.z());
        spawnEntity.write((Type)Types.BYTE, (Object)0);
        spawnEntity.write((Type)Types.BYTE, (Object)0);
        spawnEntity.write((Type)Types.BYTE, (Object)0);
        spawnEntity.write((Type)Types.VAR_INT, (Object)Integer.valueOf(blockState.properties().get("facing_direction")));
        spawnEntity.write((Type)Types.SHORT, (Object)0);
        spawnEntity.write((Type)Types.SHORT, (Object)0);
        spawnEntity.write((Type)Types.SHORT, (Object)0);
        spawnEntity.send(BedrockProtocol.class);
    }

    public int getItemFrameId(BlockPosition position) {
        return this.itemFrames.getOrDefault(position, -1);
    }

    public void removeItemFrame(BlockPosition position) {
        Integer javaId = this.itemFrames.remove(position);
        if (javaId == null) {
            return;
        }
        PacketWrapper removeEntities = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.REMOVE_ENTITIES, (UserConnection)this.user());
        removeEntities.write(Types.VAR_INT_ARRAY_PRIMITIVE, (Object)new int[]{javaId});
        removeEntities.send(BedrockProtocol.class);
    }

    public void removeItemFrame(ChunkPosition chunkPos) {
        ArrayList<BlockPosition> toRemove = new ArrayList<BlockPosition>();
        for (Map.Entry<BlockPosition, Integer> entry : this.itemFrames.entrySet()) {
            BlockPosition position = entry.getKey();
            if (position.x() >> 4 != chunkPos.chunkX() || position.z() >> 4 != chunkPos.chunkZ()) continue;
            toRemove.add(position);
        }
        for (BlockPosition position : toRemove) {
            this.removeItemFrame(position);
        }
    }

    public void tick() {
        for (Entity entity : this.entities.values()) {
            if (entity == this.clientPlayerEntity) continue;
            entity.tick();
        }
    }

    public void prepareForRespawn() {
        for (Entity entity : this.entities.values()) {
            entity.remove();
        }
    }

    public Entity getEntityByRid(long runtimeId) {
        return this.entities.get(this.runtimeIdToUniqueId.get(runtimeId));
    }

    public Entity getEntityByUid(long uniqueId) {
        return this.entities.get(uniqueId);
    }

    public Entity getEntityByJid(int javaId) {
        return this.entities.get(this.javaIdToUniqueId.get(javaId));
    }

    public ClientPlayerEntity getClientPlayer() {
        return this.clientPlayerEntity;
    }

    public boolean isEmpty() {
        return this.entities.isEmpty() || this.entities.size() == 1 && this.entities.containsKey(this.clientPlayerEntity.uniqueId());
    }

    public int getNextJavaEntityId() {
        return this.ID_COUNTER.getAndIncrement();
    }
}

