/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.storage;

import com.vdurmont.semver4j.Semver;
import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.viaversion.api.connection.StoredObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.libs.fastutil.ints.IntIntImmutablePair;
import com.viaversion.viaversion.libs.fastutil.ints.IntIntPair;
import com.viaversion.viaversion.libs.mcstructs.text.TextComponent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.raphimc.viabedrock.api.io.compression.ProtocolCompression;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.data.JavaRegistries;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.ChatRestrictionLevel;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.GameType;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;

public class GameSessionStorage
extends StoredObject {
    private ProtocolCompression protocolCompression;
    private CompoundTag javaRegistries;
    private CompoundTag bedrockBiomeDefinitions = BedrockProtocol.MAPPINGS.getBedrockBiomeDefinitions();
    private final Map<String, IntIntPair> bedrockDimensionDefinitions = new HashMap<String, IntIntPair>();
    private final Set<String> availableEntityIdentifiers = new HashSet<String>(BedrockProtocol.MAPPINGS.getBedrockEntities().keySet());
    private Semver bedrockVanillaVersion;
    private boolean flatGenerator;
    private int movementRewindHistorySize;
    private GameType levelGameType;
    private long levelTime;
    private boolean hardcoreMode;
    private ChatRestrictionLevel chatRestrictionLevel;
    private boolean commandsEnabled;
    private boolean inventoryServerAuthoritative;
    private boolean blockBreakingServerAuthoritative;
    private boolean immutableWorld;
    private TextComponent deathMessage;

    public GameSessionStorage(UserConnection user) {
        super(user);
        this.bedrockDimensionDefinitions.put("minecraft:the_nether", (IntIntPair)new IntIntImmutablePair(0, 128));
    }

    public ProtocolCompression getProtocolCompression() {
        return this.protocolCompression;
    }

    public void setProtocolCompression(ProtocolCompression protocolCompression) {
        this.protocolCompression = protocolCompression;
    }

    public CompoundTag getJavaRegistries() {
        if (this.javaRegistries == null) {
            this.javaRegistries = JavaRegistries.createJavaRegistries(this, (ResourcePacksStorage)this.user().get(ResourcePacksStorage.class));
        }
        return this.javaRegistries;
    }

    public CompoundTag getBedrockBiomeDefinitions() {
        return this.bedrockBiomeDefinitions;
    }

    public void setBedrockBiomeDefinitions(CompoundTag bedrockBiomeDefinitions) {
        this.bedrockBiomeDefinitions = bedrockBiomeDefinitions;
        this.javaRegistries = null;
    }

    public Map<String, IntIntPair> getBedrockDimensionDefinitions() {
        return this.bedrockDimensionDefinitions;
    }

    public void putBedrockDimensionDefinition(String dimensionIdentifier, IntIntPair dimensionDefinition) {
        this.bedrockDimensionDefinitions.put(dimensionIdentifier, dimensionDefinition);
        this.javaRegistries = null;
    }

    public Set<String> getAvailableEntityIdentifiers() {
        return this.availableEntityIdentifiers;
    }

    public void addEntityIdentifier(String entityIdentifier) {
        this.availableEntityIdentifiers.add(entityIdentifier);
    }

    public Semver getBedrockVanillaVersion() {
        return this.bedrockVanillaVersion;
    }

    public void setBedrockVanillaVersion(Semver bedrockVanillaVersion) {
        this.bedrockVanillaVersion = bedrockVanillaVersion;
    }

    public boolean isFlatGenerator() {
        return this.flatGenerator;
    }

    public void setFlatGenerator(boolean flatGenerator) {
        this.flatGenerator = flatGenerator;
    }

    public int getMovementRewindHistorySize() {
        return this.movementRewindHistorySize;
    }

    public void setMovementRewindHistorySize(int movementRewindHistorySize) {
        this.movementRewindHistorySize = movementRewindHistorySize;
    }

    public GameType getLevelGameType() {
        return this.levelGameType;
    }

    public void setLevelGameType(GameType levelGameType) {
        this.levelGameType = levelGameType;
    }

    public long getLevelTime() {
        return this.levelTime;
    }

    public void setLevelTime(long levelTime) {
        this.levelTime = levelTime;
    }

    public boolean isHardcoreMode() {
        return this.hardcoreMode;
    }

    public void setHardcoreMode(boolean hardcoreMode) {
        this.hardcoreMode = hardcoreMode;
    }

    public ChatRestrictionLevel getChatRestrictionLevel() {
        return this.chatRestrictionLevel;
    }

    public void setChatRestrictionLevel(ChatRestrictionLevel chatRestrictionLevel) {
        this.chatRestrictionLevel = chatRestrictionLevel;
    }

    public boolean areCommandsEnabled() {
        return this.commandsEnabled;
    }

    public void setCommandsEnabled(boolean commandsEnabled) {
        this.commandsEnabled = commandsEnabled;
    }

    public boolean isInventoryServerAuthoritative() {
        return this.inventoryServerAuthoritative;
    }

    public void setInventoryServerAuthoritative(boolean inventoryServerAuthoritative) {
        this.inventoryServerAuthoritative = inventoryServerAuthoritative;
    }

    public boolean isBlockBreakingServerAuthoritative() {
        return this.blockBreakingServerAuthoritative;
    }

    public void setBlockBreakingServerAuthoritative(boolean blockBreakingServerAuthoritative) {
        this.blockBreakingServerAuthoritative = blockBreakingServerAuthoritative;
    }

    public boolean isImmutableWorld() {
        return this.immutableWorld;
    }

    public void setImmutableWorld(boolean immutableWorld) {
        this.immutableWorld = immutableWorld;
    }

    public TextComponent getDeathMessage() {
        return this.deathMessage;
    }

    public void setDeathMessage(TextComponent deathMessage) {
        this.deathMessage = deathMessage;
    }
}

