/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.storage;

import com.viaversion.viaversion.api.connection.StoredObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.libs.fastutil.ints.IntObjectPair;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.lenni0451.mcstructs_bedrock.forms.Form;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.container.Container;
import net.raphimc.viabedrock.api.model.container.dynamic.BundleContainer;
import net.raphimc.viabedrock.api.model.container.player.ArmorContainer;
import net.raphimc.viabedrock.api.model.container.player.HudContainer;
import net.raphimc.viabedrock.api.model.container.player.InventoryContainer;
import net.raphimc.viabedrock.api.model.container.player.OffhandContainer;
import net.raphimc.viabedrock.api.util.PacketFactory;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.ContainerEnumName;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.ContainerID;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.ContainerType;
import net.raphimc.viabedrock.protocol.model.BedrockItem;
import net.raphimc.viabedrock.protocol.model.FullContainerName;
import net.raphimc.viabedrock.protocol.model.Position3f;
import net.raphimc.viabedrock.protocol.rewriter.BlockStateRewriter;
import net.raphimc.viabedrock.protocol.rewriter.ItemRewriter;
import net.raphimc.viabedrock.protocol.storage.ChunkTracker;
import net.raphimc.viabedrock.protocol.storage.EntityTracker;

public class InventoryTracker
extends StoredObject {
    private final InventoryContainer inventoryContainer = new InventoryContainer(this.user());
    private final OffhandContainer offhandContainer = new OffhandContainer(this.user());
    private final ArmorContainer armorContainer = new ArmorContainer(this.user());
    private final HudContainer hudContainer = new HudContainer(this.user());
    private final Map<FullContainerName, BundleContainer> dynamicContainerRegistry = new HashMap<FullContainerName, BundleContainer>();
    private Container currentContainer = null;
    private Container pendingCloseContainer = null;
    private IntObjectPair<Form> currentForm = null;

    public InventoryTracker(UserConnection user) {
        super(user);
    }

    public Container getContainerClientbound(byte containerId, FullContainerName containerName, BedrockItem storageItem) {
        if (containerId == this.inventoryContainer.containerId()) {
            return this.inventoryContainer;
        }
        if (containerId == this.offhandContainer.containerId()) {
            return this.offhandContainer;
        }
        if (containerId == this.armorContainer.containerId()) {
            return this.armorContainer;
        }
        if (containerId == this.hudContainer.containerId()) {
            return this.hudContainer;
        }
        if (containerId == ContainerID.CONTAINER_ID_REGISTRY.getValue() && containerName.name() == ContainerEnumName.DynamicContainer) {
            String itemTag = BedrockProtocol.MAPPINGS.getBedrockItemTags().getOrDefault(((ItemRewriter)this.user().get(ItemRewriter.class)).getItems().inverse().get((Object)storageItem.identifier()), "");
            if (!storageItem.isEmpty() && itemTag.equals("bundle")) {
                return this.dynamicContainerRegistry.computeIfAbsent(containerName, cn -> new BundleContainer(this.user(), (FullContainerName)cn));
            }
            return null;
        }
        if (this.currentContainer != null && containerId == this.currentContainer.containerId()) {
            return this.currentContainer;
        }
        return null;
    }

    public Container getContainerServerbound(byte containerId) {
        if (this.currentContainer != null && containerId == this.currentContainer.javaContainerId()) {
            return this.currentContainer;
        }
        return null;
    }

    public BundleContainer getDynamicContainer(FullContainerName containerName) {
        return this.dynamicContainerRegistry.get(containerName);
    }

    public void removeDynamicContainer(FullContainerName containerName) {
        this.dynamicContainerRegistry.remove(containerName);
    }

    public void markPendingClose(Container container) {
        if (this.pendingCloseContainer != null) {
            throw new IllegalStateException("There is already another container pending close");
        }
        if (this.currentContainer == container) {
            this.currentContainer = null;
        }
        this.pendingCloseContainer = container;
    }

    public void setCurrentContainerClosed(boolean serverInitiated) {
        if (serverInitiated) {
            PacketFactory.sendBedrockContainerClose(this.user(), this.currentContainer.containerId(), ContainerType.NONE);
        }
        this.currentContainer = null;
        this.pendingCloseContainer = null;
    }

    public void closeAllContainers() {
        if (this.currentContainer != null) {
            PacketFactory.sendBedrockContainerClose(this.user(), this.currentContainer.containerId(), ContainerType.NONE);
            this.currentContainer = null;
        }
        this.pendingCloseContainer = null;
    }

    public void tick() {
        if (this.currentContainer != null && this.currentContainer.position() != null) {
            int blockState;
            if (this.currentContainer.type() == ContainerType.INVENTORY) {
                return;
            }
            ChunkTracker chunkTracker = (ChunkTracker)this.user().get(ChunkTracker.class);
            BlockStateRewriter blockStateRewriter = (BlockStateRewriter)this.user().get(BlockStateRewriter.class);
            String tag = blockStateRewriter.tag(blockState = chunkTracker.getBlockState(this.currentContainer.position()));
            if (!this.currentContainer.isValidBlockTag(tag)) {
                ViaBedrock.getPlatform().getLogger().log(Level.INFO, "Closing " + this.currentContainer.type() + " because block state is not valid for container type: " + blockState);
                this.forceCloseContainer(this.currentContainer);
                return;
            }
            EntityTracker entityTracker = (EntityTracker)this.user().get(EntityTracker.class);
            Position3f containerPosition = new Position3f((float)this.currentContainer.position().x() + 0.5f, (float)this.currentContainer.position().y() + 0.5f, (float)this.currentContainer.position().z() + 0.5f);
            Position3f playerPosition = entityTracker.getClientPlayer().position();
            if (playerPosition.distanceTo(containerPosition) > 6.0f) {
                ViaBedrock.getPlatform().getLogger().log(Level.INFO, "Closing " + this.currentContainer.type() + " because player is too far away (" + playerPosition.distanceTo(containerPosition) + " > 6)");
                this.forceCloseContainer(this.currentContainer);
            }
        }
    }

    public boolean isContainerOpen() {
        return this.currentContainer != null || this.pendingCloseContainer != null;
    }

    public boolean isAnyScreenOpen() {
        return this.isContainerOpen() || this.currentForm != null;
    }

    public InventoryContainer getInventoryContainer() {
        return this.inventoryContainer;
    }

    public OffhandContainer getOffhandContainer() {
        return this.offhandContainer;
    }

    public ArmorContainer getArmorContainer() {
        return this.armorContainer;
    }

    public HudContainer getHudContainer() {
        return this.hudContainer;
    }

    public Container getCurrentContainer() {
        return this.currentContainer;
    }

    public void setCurrentContainer(Container container) {
        if (this.isContainerOpen()) {
            throw new IllegalStateException("There is already another container open");
        }
        this.currentContainer = container;
    }

    public Container getPendingCloseContainer() {
        return this.pendingCloseContainer;
    }

    public IntObjectPair<Form> getCurrentForm() {
        return this.currentForm;
    }

    public void setCurrentForm(IntObjectPair<Form> currentForm) {
        this.currentForm = currentForm;
    }

    private void forceCloseContainer(Container container) {
        this.markPendingClose(container);
        PacketFactory.sendJavaContainerClose(this.user(), this.pendingCloseContainer.javaContainerId());
        PacketFactory.sendBedrockContainerClose(this.user(), this.pendingCloseContainer.containerId(), ContainerType.NONE);
    }
}

