/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.storage;

import com.viaversion.viaversion.api.connection.StoredObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectOpenHashMap;
import com.viaversion.viaversion.protocols.v1_21_5to1_21_6.packet.ClientboundConfigurationPackets1_21_6;
import com.viaversion.viaversion.protocols.v1_21_5to1_21_6.packet.ClientboundPackets1_21_6;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.protocol.BedrockProtocol;

public class PacketSyncStorage
extends StoredObject {
    private final AtomicInteger ID_COUNTER = new AtomicInteger(0);
    private final Int2ObjectMap<Long> pendingNetworkStackLatencyResponses = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<Runnable> pendingActions = new Int2ObjectOpenHashMap();

    public PacketSyncStorage(UserConnection user) {
        super(user);
    }

    public int addNetworkStackLatencyResponse(long timestamp) {
        int id;
        if (this.ID_COUNTER.get() >= Short.MAX_VALUE) {
            this.ID_COUNTER.set(0);
        }
        if (this.pendingNetworkStackLatencyResponses.put(id = this.ID_COUNTER.getAndIncrement(), (Object)timestamp) != null) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Overwrote pending network stack latency response with id " + id);
        }
        return id;
    }

    public Long getNetworkStackLatencyResponse(int id) {
        return (Long)this.pendingNetworkStackLatencyResponses.remove(id);
    }

    public void syncWithClient(Runnable runnable) {
        State state;
        int id;
        if (this.ID_COUNTER.get() >= Short.MAX_VALUE) {
            this.ID_COUNTER.set(0);
        }
        if (this.pendingActions.put(id = this.ID_COUNTER.getAndIncrement(), (Object)runnable) != null) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Overwrote pending action with id " + id);
        }
        PacketWrapper pingPacket = PacketWrapper.create((PacketType)((state = this.user().getProtocolInfo().getServerState()) == State.PLAY ? ClientboundPackets1_21_6.PING : ClientboundConfigurationPackets1_21_6.PING), (UserConnection)this.user());
        pingPacket.write((Type)Types.INT, (Object)id);
        pingPacket.send(BedrockProtocol.class);
    }

    public boolean handleSyncTask(int id) {
        Runnable runnable = (Runnable)this.pendingActions.remove(id);
        if (runnable != null) {
            runnable.run();
            return true;
        }
        return false;
    }
}

