/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.types.model;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.util.Key;
import io.netty.buffer.ByteBuf;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.ItemDataVersion;
import net.raphimc.viabedrock.protocol.model.ItemEntry;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class ItemEntryType
extends Type<ItemEntry> {
    public ItemEntryType() {
        super(ItemEntry.class);
    }

    public ItemEntry read(ByteBuf buffer) {
        String identifier = Key.namespaced((String)((String)BedrockTypes.STRING.read(buffer)));
        short id = buffer.readShortLE();
        boolean componentBased = buffer.readBoolean();
        ItemDataVersion version = ItemDataVersion.getByValue(BedrockTypes.VAR_INT.read(buffer), ItemDataVersion.NONE);
        CompoundTag componentData = (CompoundTag)BedrockTypes.NETWORK_TAG.read(buffer);
        return new ItemEntry(identifier, id, componentBased, version, componentData);
    }

    public void write(ByteBuf buffer, ItemEntry value) {
        BedrockTypes.STRING.write(buffer, (Object)value.identifier());
        buffer.writeShortLE(value.id());
        buffer.writeBoolean(value.componentBased());
        BedrockTypes.VAR_INT.write(buffer, value.version().getValue());
        BedrockTypes.NETWORK_TAG.write(buffer, (Object)value.componentData());
    }
}

