/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.types.primitive;

import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.util.Triple;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class PackIdAndVersionAndNameType
extends Type<Triple<UUID, String, String>> {
    public PackIdAndVersionAndNameType() {
        super("PackID and Version and Name", Triple.class);
    }

    public Triple<UUID, String, String> read(ByteBuf buffer) {
        UUID packUUID;
        String packId = (String)BedrockTypes.STRING.read(buffer);
        String packVersion = (String)BedrockTypes.STRING.read(buffer);
        try {
            packUUID = UUID.fromString(packId);
        }
        catch (IllegalArgumentException e) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Invalid pack UUID: " + packId, e);
            packUUID = new UUID(0L, 0L);
        }
        String packName = (String)BedrockTypes.STRING.read(buffer);
        return new Triple((Object)packUUID, (Object)packVersion, (Object)packName);
    }

    public void write(ByteBuf buffer, Triple<UUID, String, String> value) {
        BedrockTypes.STRING.write(buffer, (Object)((UUID)value.first()).toString());
        BedrockTypes.STRING.write(buffer, (Object)((String)value.second()));
        BedrockTypes.STRING.write(buffer, (Object)((String)value.third()));
    }
}

