/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.chunk.bitarray;

import net.raphimc.viabedrock.api.chunk.bitarray.BitArray;
import net.raphimc.viabedrock.api.chunk.bitarray.PaddedBitArray;
import net.raphimc.viabedrock.api.chunk.bitarray.Pow2BitArray;
import net.raphimc.viabedrock.api.chunk.bitarray.SingletonBitArray;
import net.raphimc.viabedrock.api.util.MathUtil;

public enum BitArrayVersion {
    V16(16, 2, null),
    V8(8, 4, V16),
    V6(6, 5, V8),
    V5(5, 6, V6),
    V4(4, 8, V5),
    V3(3, 10, V4),
    V2(2, 16, V3),
    V1(1, 32, V2),
    V0(0, 0, V1);

    private final byte bits;
    private final byte entriesPerWord;
    private final int maxEntryValue;
    private final BitArrayVersion next;

    private BitArrayVersion(int bits, int entriesPerWord, BitArrayVersion next) {
        this.bits = (byte)bits;
        this.entriesPerWord = (byte)entriesPerWord;
        this.maxEntryValue = (1 << this.bits) - 1;
        this.next = next;
    }

    public static BitArrayVersion get(int version, boolean read) {
        for (BitArrayVersion ver : BitArrayVersion.values()) {
            if ((read || ver.entriesPerWord > version) && (!read || ver.bits != version)) continue;
            return ver;
        }
        throw new IllegalArgumentException("Invalid palette version: " + version);
    }

    public static BitArrayVersion forBitsCeil(int bits) {
        for (int i = BitArrayVersion.values().length - 1; i >= 0; --i) {
            BitArrayVersion version = BitArrayVersion.values()[i];
            if (version.bits < bits) continue;
            return version;
        }
        throw new IllegalArgumentException("Invalid palette bits: " + bits);
    }

    public BitArray createArray(int size) {
        return this.createArray(size, new int[this.getWordsForSize(size)]);
    }

    public BitArray createArray(int size, int[] words) {
        if (this == V3 || this == V5 || this == V6) {
            return new PaddedBitArray(this, size, words);
        }
        if (this == V0) {
            return SingletonBitArray.INSTANCE;
        }
        return new Pow2BitArray(this, size, words);
    }

    public int getWordsForSize(int size) {
        if (this.entriesPerWord == 0) {
            return 0;
        }
        return MathUtil.ceil((float)size / (float)this.entriesPerWord);
    }

    public byte getBits() {
        return this.bits;
    }

    public byte getEntriesPerWord() {
        return this.entriesPerWord;
    }

    public int getMaxEntryValue() {
        return this.maxEntryValue;
    }

    public BitArrayVersion getNext() {
        return this.next;
    }
}

