/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.model.resourcepack;

import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.util.Key;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.resourcepack.ResourcePack;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;

public class BlockDefinitions {
    private final Map<String, BlockDefinition> blocks = new HashMap<String, BlockDefinition>();

    public BlockDefinitions(ResourcePacksStorage resourcePacksStorage) {
        for (ResourcePack pack : resourcePacksStorage.getPackStackBottomToTop()) {
            if (!pack.content().contains("blocks.json")) continue;
            try {
                JsonObject blocks = pack.content().getJson("blocks.json");
                for (Map.Entry entry : blocks.entrySet()) {
                    if (((String)entry.getKey()).equals("format_version")) continue;
                    JsonObject block = ((JsonElement)entry.getValue()).getAsJsonObject();
                    String sound = block.has("sound") ? block.get("sound").getAsString() : null;
                    this.blocks.put(Key.namespaced((String)((String)entry.getKey())), new BlockDefinition(Key.namespaced((String)((String)entry.getKey())), sound));
                }
            }
            catch (Throwable e) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Failed to parse blocks.json in pack " + String.valueOf(pack.packId()), e);
            }
        }
    }

    public BlockDefinition get(String identifier) {
        return this.blocks.get(identifier);
    }

    public Map<String, BlockDefinition> blocks() {
        return Collections.unmodifiableMap(this.blocks);
    }

    public record BlockDefinition(String identifier, String sound) {
    }
}

