/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.model.resourcepack;

import com.viaversion.viaversion.util.Key;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.resourcepack.ResourcePack;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;
import org.cube.converter.data.bedrock.BedrockEntityData;
import org.cube.converter.parser.bedrock.data.impl.BedrockEntityParser;

public class EntityDefinitions {
    private final Map<String, EntityDefinition> entities = new HashMap<String, EntityDefinition>();

    public EntityDefinitions(ResourcePacksStorage resourcePacksStorage) {
        for (ResourcePack pack : resourcePacksStorage.getPackStackBottomToTop()) {
            for (String entityPath : pack.content().getFilesDeep("entity/", ".json")) {
                try {
                    BedrockEntityData entityData = BedrockEntityParser.parse((String)pack.content().getString(entityPath));
                    String identifier = Key.namespaced((String)entityData.getIdentifier());
                    this.entities.put(identifier, new EntityDefinition(identifier, entityData));
                }
                catch (Throwable e) {
                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Failed to parse entity definition " + entityPath + " in pack " + String.valueOf(pack.packId()), e);
                }
            }
        }
    }

    public EntityDefinition get(String identifier) {
        return this.entities.get(identifier);
    }

    public Map<String, EntityDefinition> entities() {
        return Collections.unmodifiableMap(this.entities);
    }

    public record EntityDefinition(String identifier, BedrockEntityData entityData) {
    }
}

