/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.util;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.ListTag;
import com.viaversion.nbt.tag.StringTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.mcstructs.text.Style;
import com.viaversion.viaversion.libs.mcstructs.text.TextComponent;
import com.viaversion.viaversion.libs.mcstructs.text.TextFormatting;
import com.viaversion.viaversion.libs.mcstructs.text.serializer.LegacyStringDeserializer;
import com.viaversion.viaversion.libs.mcstructs.text.utils.TextUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.lenni0451.mcstructs_bedrock.text.BedrockTextFormatting;
import net.raphimc.viabedrock.protocol.data.ProtocolConstants;

public class TextUtil {
    private static final Function<Character, TextFormatting> BEDROCK_FORMATTING_RESOLVER = c -> Optional.ofNullable(BedrockTextFormatting.getByCode((char)c.charValue())).map(f -> {
        if (f.isColor()) {
            return new TextFormatting(f.getRgbValue());
        }
        if (f.equals((Object)BedrockTextFormatting.OBFUSCATED)) {
            return TextFormatting.OBFUSCATED;
        }
        if (f.equals((Object)BedrockTextFormatting.BOLD)) {
            return TextFormatting.BOLD;
        }
        if (f.equals((Object)BedrockTextFormatting.ITALIC)) {
            return TextFormatting.ITALIC;
        }
        if (f.equals((Object)BedrockTextFormatting.RESET)) {
            return TextFormatting.RESET;
        }
        throw new IllegalArgumentException("Unhandled BedrockTextFormatting: " + String.valueOf(f));
    }).orElse(null);

    public static String stringToJson(String text) {
        return TextUtil.textComponentToJson(TextUtil.stringToTextComponent(text));
    }

    public static String textComponentToJson(TextComponent textComponent) {
        return ProtocolConstants.JAVA_TEXT_COMPONENT_SERIALIZER.serializeJsonString(textComponent);
    }

    public static JsonElement stringToGson(String text) {
        return TextUtil.textComponentToGson(TextUtil.stringToTextComponent(text));
    }

    public static JsonElement textComponentToGson(TextComponent textComponent) {
        return ProtocolConstants.JAVA_TEXT_COMPONENT_SERIALIZER.serializeJsonTree(textComponent);
    }

    public static Tag stringToNbt(String text) {
        return TextUtil.textComponentToNbt(TextUtil.stringToTextComponent(text));
    }

    public static Tag textComponentToNbt(TextComponent textComponent) {
        return ProtocolConstants.JAVA_TEXT_COMPONENT_SERIALIZER.serializeNbtTree(textComponent);
    }

    public static TextComponent stringToTextComponent(String text) {
        TextComponent textComponent = LegacyStringDeserializer.parse((String)TextUtil.appendFormattingCodesAfterColorCode(text), (char)'\u00a7', ResetTrackingStyle::new, BEDROCK_FORMATTING_RESOLVER);
        AtomicBoolean wasReset = new AtomicBoolean(false);
        TextUtils.iterateAll((TextComponent)textComponent, c -> {
            Style style = c.getStyle();
            if (style instanceof ResetTrackingStyle) {
                ResetTrackingStyle resetTrackingStyle = (ResetTrackingStyle)style;
                if (resetTrackingStyle.wasReset) {
                    wasReset.set(true);
                }
            }
            if (wasReset.get()) {
                if (!style.isBold()) {
                    style.setBold(Boolean.valueOf(false));
                }
                if (!style.isUnderlined()) {
                    style.setUnderlined(Boolean.valueOf(false));
                }
                if (!style.isItalic()) {
                    style.setItalic(Boolean.valueOf(false));
                }
            }
        });
        return textComponent;
    }

    public static CompoundTag ensureCompoundTag(Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            return compoundTag;
        }
        if (tag instanceof StringTag) {
            StringTag stringTag = (StringTag)tag;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putString("text", stringTag.getValue());
            return compoundTag;
        }
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putString("text", "");
        compoundTag.put("extra", (Tag)new ListTag(List.of(tag)));
        return compoundTag;
    }

    private static String appendFormattingCodesAfterColorCode(String s) {
        char[] chars = s.toCharArray();
        EnumSet<BedrockTextFormatting> styles = EnumSet.noneOf(BedrockTextFormatting.class);
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            out.append(c);
            if (c != '\u00a7' || i + 1 >= chars.length) continue;
            char code = chars[++i];
            out.append(code);
            BedrockTextFormatting formatting = BedrockTextFormatting.getByCode((char)code);
            if (formatting == null) continue;
            if (BedrockTextFormatting.RESET.equals((Object)formatting)) {
                styles.clear();
                continue;
            }
            if (formatting.isColor()) {
                for (BedrockTextFormatting style : styles) {
                    out.append(style.asString());
                }
                continue;
            }
            styles.add(formatting);
        }
        return out.toString();
    }

    private static final class ResetTrackingStyle
    extends Style {
        private boolean wasReset;

        private ResetTrackingStyle() {
        }

        public Style setFormatting(TextFormatting formatting) {
            if (formatting == TextFormatting.RESET) {
                this.wasReset = true;
            }
            return super.setFormatting(formatting);
        }

        public Style copy() {
            ResetTrackingStyle copy = new ResetTrackingStyle();
            copy.setParent(super.copy());
            copy.mergeParent();
            copy.wasReset = this.wasReset;
            return copy;
        }
    }
}

