/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.viaversion.nbt.io.NBTIO;
import com.viaversion.nbt.limiter.TagLimiter;
import com.viaversion.nbt.stringified.SNBT;
import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.IntArrayTag;
import com.viaversion.nbt.tag.ListTag;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.data.MappingDataBase;
import com.viaversion.viaversion.api.minecraft.Particle;
import com.viaversion.viaversion.api.minecraft.entities.EntityTypes1_21_9;
import com.viaversion.viaversion.api.minecraft.item.StructuredItem;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.version.VersionedTypes;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntOpenHashMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectOpenHashMap;
import com.viaversion.viaversion.libs.fastutil.ints.IntOpenHashSet;
import com.viaversion.viaversion.libs.fastutil.ints.IntSet;
import com.viaversion.viaversion.libs.gson.JsonArray;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.libs.gson.JsonPrimitive;
import com.viaversion.viaversion.util.GsonUtil;
import com.viaversion.viaversion.util.Key;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.BedrockProtocolVersion;
import net.raphimc.viabedrock.api.chunk.blockstate.BlockStateUpgrader;
import net.raphimc.viabedrock.api.item.ItemUpgrader;
import net.raphimc.viabedrock.api.model.BedrockBlockState;
import net.raphimc.viabedrock.api.model.BlockState;
import net.raphimc.viabedrock.api.model.resourcepack.ResourcePack;
import net.raphimc.viabedrock.api.model.resourcepack.SoundDefinitions;
import net.raphimc.viabedrock.api.util.EnumUtil;
import net.raphimc.viabedrock.api.util.FileSystemUtil;
import net.raphimc.viabedrock.api.util.JsonUtil;
import net.raphimc.viabedrock.protocol.data.ArgumentTypeRegistry;
import net.raphimc.viabedrock.protocol.data.ProtocolConstants;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ActorDamageCause;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ActorDataIDs;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ActorFlags;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ContainerType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.DataItemType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.NoteBlockInstrument;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.PackType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ParticleType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.SharedTypes_Legacy_LevelSoundEvent;
import net.raphimc.viabedrock.protocol.data.enums.java.LevelEvent;
import net.raphimc.viabedrock.protocol.data.enums.java.SoundSource;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class BedrockMappingData
extends MappingDataBase {
    private Map<String, ResourcePack> bedrockVanillaResourcePacks;
    private Map<String, Object> bedrockGameRules;
    private CompoundTag javaRegistries;
    private CompoundTag javaTags;
    private BiMap<String, Integer> javaCommandArgumentTypes;
    private BlockStateUpgrader bedrockBlockStateUpgrader;
    private BiMap<BlockState, Integer> javaBlockStates;
    private Set<BedrockBlockState> bedrockBlockStates;
    private Map<BlockState, BlockState> bedrockToJavaBlockStates;
    private Map<String, String> bedrockBlockTags;
    private Map<String, Map<String, Set<String>>> bedrockBlockTraits;
    private BiMap<String, Integer> bedrockLegacyBlocks;
    private Int2ObjectMap<BedrockBlockState> bedrockLegacyBlockStates;
    private IntSet javaPreWaterloggedBlockStates;
    private Int2IntMap javaPottedBlockStates;
    private Map<String, IntSet> javaHeightMapBlockStates;
    private CompoundTag bedrockBiomeDefinitions;
    private BiMap<String, Integer> bedrockBiomes;
    private BiMap<String, Integer> javaBiomes;
    private Map<String, Map<String, Object>> bedrockToJavaBiomeExtraData;
    private ItemUpgrader bedrockItemUpgrader;
    private BiMap<String, Integer> javaItems;
    private Set<String> bedrockBlockItems;
    private Set<String> bedrockMetaItems;
    private Map<String, String> bedrockItemTags;
    private Map<String, Map<BlockState, JavaItemMapping>> bedrockToJavaBlockItems;
    private Map<String, Map<Integer, JavaItemMapping>> bedrockToJavaMetaItems;
    private Map<ContainerType, Integer> bedrockToJavaContainers;
    private BiMap<String, Integer> bedrockEntities;
    private Map<ActorDataIDs, DataItemType> bedrockEntityDataTypes;
    private Map<ActorFlags, String> bedrockEntityFlagMoLangQueries;
    private Map<String, EntityTypes1_21_9> bedrockToJavaEntities;
    private BiMap<String, Integer> javaBlockEntities;
    private BiMap<String, Integer> javaEntityAttributes;
    private Map<EntityTypes1_21_9, List<String>> javaEntityData;
    private BiMap<String, Integer> javaEffects;
    private BiMap<String, Integer> bedrockEffects;
    private Map<String, String> bedrockToJavaEffects;
    private BiMap<String, Integer> javaSounds;
    private BiMap<String, Integer> javaParticles;
    private Map<String, String> bedrockBlockSounds;
    private Map<SharedTypes_Legacy_LevelSoundEvent, Map<String, SoundDefinitions.ConfiguredSound>> bedrockLevelSoundEvents;
    private Map<NoteBlockInstrument, String> bedrockNoteBlockInstrumentSounds;
    private Map<String, JavaSound> bedrockToJavaSounds;
    private Map<String, JavaParticle> bedrockToJavaParticles;
    private Map<net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.LevelEvent, LevelEventMapping> bedrockToJavaLevelEvents;
    private Map<ParticleType, JavaParticle> bedrockToJavaLevelEventParticles;
    private BiMap<String, String> bedrockToJavaExperimentalFeatures;
    private BiMap<String, String> bedrockToJavaBannerPatterns;
    private BiMap<String, String> bedrockToJavaPaintings;
    private Map<ActorDamageCause, String> bedrockToJavaDamageCauses;

    public BedrockMappingData() {
        super(BedrockProtocolVersion.bedrockLatest.getName(), ProtocolConstants.JAVA_VERSION.getName());
    }

    /*
     * WARNING - void declaration
     */
    public void load() {
        void var13_152;
        void var12_121;
        void var9_57;
        Object entry7;
        Object blockState;
        void var3_7;
        if (Via.getManager().isDebug()) {
            this.getLogger().info("Loading " + this.unmappedVersion + " -> " + this.mappedVersion + " mappings...");
        }
        JsonObject javaViaMappingJson = this.readJson("java/via_mappings.json");
        this.bedrockVanillaResourcePacks = new HashMap<String, ResourcePack>();
        try {
            for (Map.Entry<Path, byte[]> entry2 : FileSystemUtil.getFilesInDirectory("assets/viabedrock/vanilla_packs").entrySet()) {
                String packName = entry2.getKey().getFileName().toString().replace(".mcpack", "");
                ResourcePack resourcePack = new ResourcePack(null, null, new byte[0], packName, "", false, false, false, null, 0L, PackType.Resources);
                resourcePack.setCompressedDataLength(entry2.getValue().length, entry2.getValue().length);
                resourcePack.processDataChunk(0, entry2.getValue());
                this.bedrockVanillaResourcePacks.put(packName, resourcePack);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load vanilla resource packs", e);
        }
        JsonObject bedrockGameRulesJson = this.readJson("bedrock/game_rules.json");
        this.bedrockGameRules = new HashMap<String, Object>(bedrockGameRulesJson.size());
        for (Map.Entry entry3 : bedrockGameRulesJson.entrySet()) {
            this.bedrockGameRules.put(((String)entry3.getKey()).toLowerCase(Locale.ROOT), JsonUtil.getValue((JsonElement)entry3.getValue()));
        }
        this.javaRegistries = this.readNBT("java/registries.nbt");
        this.javaTags = this.readNBT("java/tags.nbt");
        JsonArray javaCommandArgumentTypesJson = javaViaMappingJson.getAsJsonArray("argumenttypes");
        this.javaCommandArgumentTypes = HashBiMap.create((int)javaCommandArgumentTypesJson.size());
        boolean bl = false;
        while (var3_7 < javaCommandArgumentTypesJson.size()) {
            this.javaCommandArgumentTypes.put((Object)Key.namespaced((String)javaCommandArgumentTypesJson.get((int)var3_7).getAsString()), (Object)((int)var3_7));
            ++var3_7;
        }
        ArgumentTypeRegistry.init();
        this.bedrockBlockStateUpgrader = new BlockStateUpgrader();
        JsonArray jsonArray = javaViaMappingJson.getAsJsonArray("blockstates");
        this.javaBlockStates = HashBiMap.create((int)jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            blockState = BlockState.fromString(jsonArray.get(i).getAsString());
            this.javaBlockStates.put(blockState, (Object)i);
        }
        ListTag bedrockBlockStatesTag = this.readNBT("bedrock/block_palette.nbt").getListTag("blocks", CompoundTag.class);
        this.bedrockBlockStates = new LinkedHashSet<BedrockBlockState>(bedrockBlockStatesTag.size());
        HashMultimap bedrockBlockStatesByIdentifier = HashMultimap.create((int)bedrockBlockStatesTag.size(), (int)32);
        blockState = bedrockBlockStatesTag.iterator();
        while (blockState.hasNext()) {
            CompoundTag tag = (CompoundTag)blockState.next();
            BedrockBlockState bedrockBlockState = BedrockBlockState.fromNbt(tag);
            this.bedrockBlockStates.add(bedrockBlockState);
            bedrockBlockStatesByIdentifier.put((Object)bedrockBlockState.namespacedIdentifier(), (Object)bedrockBlockState);
        }
        JsonObject bedrockToJavaBlockStateMappingsJson = this.readJson("custom/blockstate_mappings.json");
        this.bedrockToJavaBlockStates = new HashMap<BlockState, BlockState>(bedrockToJavaBlockStateMappingsJson.size());
        for (Object entry4 : bedrockToJavaBlockStateMappingsJson.entrySet()) {
            BlockState bedrockBlockState = BlockState.fromString((String)entry4.getKey());
            if (!this.bedrockBlockStates.contains(bedrockBlockState)) {
                throw new RuntimeException("Unknown bedrock block state: " + bedrockBlockState.toBlockStateString());
            }
            BlockState blockState2 = BlockState.fromString(((JsonElement)entry4.getValue()).getAsString());
            if (!this.javaBlockStates.containsKey((Object)blockState2)) {
                throw new RuntimeException("Unknown java block state: " + blockState2.toBlockStateString());
            }
            if (this.bedrockToJavaBlockStates.put(bedrockBlockState, blockState2) == null) continue;
            throw new RuntimeException("Duplicate bedrock -> java block state mapping for " + bedrockBlockState.toBlockStateString());
        }
        JsonObject bedrockBlockTagsJson = this.readJson("custom/block_tags.json");
        this.bedrockBlockTags = new HashMap<String, String>();
        for (Object entry5 : bedrockBlockTagsJson.entrySet()) {
            String string = (String)entry5.getKey();
            for (JsonElement tagValueJson : ((JsonElement)entry5.getValue()).getAsJsonArray()) {
                String string2 = tagValueJson.getAsString();
                if (!bedrockBlockStatesByIdentifier.containsKey((Object)string2)) {
                    throw new RuntimeException("Unknown bedrock block: " + string2);
                }
                if (this.bedrockBlockTags.put(string2, string) == null) continue;
                throw new RuntimeException("Duplicate bedrock block tag for " + string2);
            }
        }
        JsonObject bedrockBlockTraitsJson = this.readJson("bedrock/block_traits.json");
        this.bedrockBlockTraits = new HashMap<String, Map<String, Set<String>>>(bedrockBlockTraitsJson.size());
        for (Map.Entry entry3 : bedrockBlockTraitsJson.entrySet()) {
            String traitName = (String)entry3.getKey();
            JsonObject traitStatesJson = ((JsonElement)entry3.getValue()).getAsJsonObject();
            HashMap hashMap = new HashMap(traitStatesJson.size());
            for (Map.Entry traitStatesEntry : traitStatesJson.entrySet()) {
                JsonArray statesJson = ((JsonElement)traitStatesEntry.getValue()).getAsJsonArray();
                LinkedHashSet<String> states = new LinkedHashSet<String>(statesJson.size());
                for (JsonElement stateJson : statesJson) {
                    if (states.add(stateJson.getAsString())) continue;
                    throw new RuntimeException("Duplicate bedrock block trait state for " + traitName + ": " + stateJson.getAsString());
                }
                hashMap.put((String)traitStatesEntry.getKey(), states);
            }
            if (this.bedrockBlockTraits.put(traitName, hashMap) == null) continue;
            throw new RuntimeException("Duplicate bedrock block trait for " + traitName);
        }
        JsonObject bedrockLegacyBlocksJson = this.readJson("bedrock/block_legacy_id_map.json");
        this.bedrockLegacyBlocks = HashBiMap.create((int)bedrockLegacyBlocksJson.size());
        for (Object entry7 : bedrockLegacyBlocksJson.entrySet()) {
            this.bedrockLegacyBlocks.put((Object)((String)entry7.getKey()).toLowerCase(Locale.ROOT), (Object)((JsonElement)entry7.getValue()).getAsInt());
        }
        this.buildLegacyBlockStateMappings();
        JsonArray jsonArray2 = this.readJson("custom/pre_waterlogged_blockstates.json").getAsJsonArray("blockstates");
        this.javaPreWaterloggedBlockStates = new IntOpenHashSet(jsonArray2.size());
        for (Object stateJson : jsonArray2) {
            BlockState blockState3 = BlockState.fromString(stateJson.getAsString());
            if (!this.javaBlockStates.containsKey((Object)blockState3)) {
                throw new RuntimeException("Unknown java block state: " + blockState3.toBlockStateString());
            }
            this.javaPreWaterloggedBlockStates.add(((Integer)this.javaBlockStates.get((Object)blockState3)).intValue());
        }
        JsonObject javaPottedBlockStatesJson = this.readJson("custom/potted_blockstates.json");
        this.javaPottedBlockStates = new Int2IntOpenHashMap(javaPottedBlockStatesJson.size());
        for (Map.Entry entry4 : javaPottedBlockStatesJson.entrySet()) {
            BlockState blockState4 = BlockState.fromString((String)entry4.getKey());
            if (!this.javaBlockStates.containsKey((Object)blockState4)) {
                throw new RuntimeException("Unknown java block state: " + blockState4.toBlockStateString());
            }
            BlockState javaPottedBlockState = BlockState.fromString(((JsonElement)entry4.getValue()).getAsString());
            if (!this.javaBlockStates.containsKey((Object)javaPottedBlockState)) {
                throw new RuntimeException("Unknown java block state: " + javaPottedBlockState.toBlockStateString());
            }
            this.javaPottedBlockStates.put(((Integer)this.javaBlockStates.get((Object)blockState4)).intValue(), ((Integer)this.javaBlockStates.get((Object)javaPottedBlockState)).intValue());
        }
        CompoundTag javaHeightMapBlockStatesTag = this.readNBT("java/heightmap_blockstates.nbt");
        this.javaHeightMapBlockStates = new HashMap<String, IntSet>(javaHeightMapBlockStatesTag.size());
        for (Map.Entry entry5 : javaHeightMapBlockStatesTag.getValue().entrySet()) {
            IntOpenHashSet blockStates = new IntOpenHashSet();
            IntArrayTag blockStatesArrayTag = (IntArrayTag)entry5.getValue();
            for (Object object : (LinkedHashSet<String>)blockStatesArrayTag.getValue()) {
                blockStates.add((int)object);
            }
            this.javaHeightMapBlockStates.put((String)entry5.getKey(), (IntSet)blockStates);
        }
        this.bedrockBiomeDefinitions = this.readNBT("bedrock/biome_definitions.nbt");
        JsonObject jsonObject = this.readJson("bedrock/biomes.json", JsonObject.class);
        this.bedrockBiomes = HashBiMap.create((int)jsonObject.size());
        for (Map.Entry entry10 : jsonObject.entrySet()) {
            String bedrockBiomeName = (String)entry10.getKey();
            if (!this.bedrockBiomeDefinitions.contains(bedrockBiomeName)) {
                throw new RuntimeException("Unknown bedrock biome: " + bedrockBiomeName);
            }
            this.bedrockBiomes.put((Object)bedrockBiomeName, (Object)((JsonElement)entry10.getValue()).getAsInt());
        }
        for (Object bedrockBiomeName : this.bedrockBiomeDefinitions.keySet()) {
            if (this.bedrockBiomes.containsKey(bedrockBiomeName)) continue;
            throw new RuntimeException("Missing bedrock biome id mapping: " + (String)bedrockBiomeName);
        }
        this.javaBiomes = HashBiMap.create((int)this.bedrockBiomes.size());
        this.javaBiomes.put((Object)"the_void", (Object)0);
        for (Object bedrockBiomeName : this.bedrockBiomes.keySet()) {
            this.javaBiomes.put(bedrockBiomeName, (Object)this.javaBiomes.size());
        }
        JsonObject bedrockToJavaBiomeExtraDataJson = this.readJson("custom/biome_extra_data.json");
        this.bedrockToJavaBiomeExtraData = new HashMap<String, Map<String, Object>>(bedrockToJavaBiomeExtraDataJson.size());
        for (Object entry11 : bedrockToJavaBiomeExtraDataJson.entrySet()) {
            String dataName = (String)entry11.getKey();
            JsonObject extraDataJson = ((JsonElement)entry11.getValue()).getAsJsonObject();
            HashMap<String, Object> hashMap = new HashMap<String, Object>(extraDataJson.size());
            for (Map.Entry extraDataEntry : extraDataJson.entrySet()) {
                JsonPrimitive jsonPrimitive = ((JsonElement)extraDataEntry.getValue()).getAsJsonPrimitive();
                if (jsonPrimitive.isString()) {
                    hashMap.put((String)extraDataEntry.getKey(), jsonPrimitive.getAsString());
                    continue;
                }
                if (jsonPrimitive.isNumber()) {
                    hashMap.put((String)extraDataEntry.getKey(), jsonPrimitive.getAsNumber().intValue());
                    continue;
                }
                if (jsonPrimitive.isBoolean()) {
                    hashMap.put((String)extraDataEntry.getKey(), jsonPrimitive.getAsBoolean());
                    continue;
                }
                throw new IllegalArgumentException("Unknown extra data type: " + ((JsonElement)extraDataEntry.getValue()).getClass().getName());
            }
            this.bedrockToJavaBiomeExtraData.put(dataName, hashMap);
        }
        this.bedrockItemUpgrader = new ItemUpgrader();
        JsonArray jsonArray3 = javaViaMappingJson.get("items").getAsJsonArray();
        this.javaItems = HashBiMap.create((int)jsonArray3.size());
        for (int i = 0; i < jsonArray3.size(); ++i) {
            this.javaItems.put((Object)Key.namespaced((String)jsonArray3.get(i).getAsString()), (Object)i);
        }
        JsonArray bedrockItemsJson = this.readJson("bedrock/runtime_item_states.json", JsonArray.class);
        HashSet<String> bedrockItems = new HashSet<String>(bedrockItemsJson.size());
        this.bedrockBlockItems = new HashSet<String>();
        this.bedrockMetaItems = new HashSet<String>();
        for (Object entry6 : bedrockItemsJson) {
            JsonObject itemEntry = entry6.getAsJsonObject();
            String string = itemEntry.get("name").getAsString();
            int id = itemEntry.get("id").getAsInt();
            bedrockItems.add(string);
            if (id <= 255) {
                this.bedrockBlockItems.add(string);
                continue;
            }
            this.bedrockMetaItems.add(string);
        }
        JsonObject bedrockItemTagsJson = this.readJson("custom/item_tags.json");
        this.bedrockItemTags = new HashMap<String, String>();
        for (Object entry7 : bedrockItemTagsJson.entrySet()) {
            String string = (String)entry7.getKey();
            for (JsonElement tagValueJson : ((JsonElement)entry7.getValue()).getAsJsonArray()) {
                String string3 = tagValueJson.getAsString();
                if (!bedrockItems.contains(string3)) {
                    throw new RuntimeException("Unknown bedrock item: " + string3);
                }
                if (this.bedrockItemTags.put(string3, string) == null) continue;
                throw new RuntimeException("Duplicate bedrock item tag for " + string3);
            }
        }
        Object bedrockToJavaItemMappingsJson = this.readJson("custom/item_mappings.json");
        this.bedrockToJavaBlockItems = new HashMap<String, Map<BlockState, JavaItemMapping>>(bedrockToJavaItemMappingsJson.size());
        this.bedrockToJavaMetaItems = new HashMap<String, Map<Integer, JavaItemMapping>>(bedrockToJavaItemMappingsJson.size());
        for (Map.Entry entry8 : bedrockToJavaItemMappingsJson.entrySet()) {
            String bedrockIdentifier2 = (String)entry8.getKey();
            if (!bedrockItems.contains(bedrockIdentifier2)) {
                throw new RuntimeException("Unknown bedrock item: " + bedrockIdentifier2);
            }
            JsonObject definition = ((JsonElement)entry8.getValue()).getAsJsonObject();
            if (definition.has("block")) {
                if (!this.bedrockBlockItems.contains(bedrockIdentifier2)) {
                    throw new RuntimeException("Tried to register meta item as block item: " + bedrockIdentifier2);
                }
                JsonObject jsonObject2 = definition.get("block").getAsJsonObject();
                HashMap<BlockState, JavaItemMapping> hashMap = new HashMap<BlockState, JavaItemMapping>(jsonObject2.size());
                this.bedrockToJavaBlockItems.put(bedrockIdentifier2, hashMap);
                ArrayList allPossibleStates = new ArrayList();
                for (Map.Entry blockMapping : jsonObject2.entrySet()) {
                    BlockState blockState3 = BlockState.fromString((String)blockMapping.getKey());
                    String blockStateIdentifier = blockState3.namespacedIdentifier();
                    ArrayList<BedrockBlockState> arrayList = new ArrayList<BedrockBlockState>();
                    for (BedrockBlockState bedrockBlockState : bedrockBlockStatesByIdentifier.get((Object)blockStateIdentifier)) {
                        if (!bedrockBlockState.properties().keySet().containsAll(blockState3.properties().keySet())) {
                            throw new RuntimeException("Unknown bedrock block state property: " + String.valueOf(blockState3.properties().keySet()) + " for " + blockStateIdentifier);
                        }
                        if (bedrockBlockState.properties().entrySet().containsAll(blockState3.properties().entrySet())) {
                            arrayList.add(bedrockBlockState);
                        }
                        allPossibleStates.add(bedrockBlockState);
                    }
                    if (arrayList.isEmpty()) {
                        throw new RuntimeException("Unknown bedrock block state: " + blockState3.toBlockStateString());
                    }
                    for (BlockState blockState5 : arrayList) {
                        if (hashMap.put(blockState5, this.parseJavaItemData(((JsonElement)blockMapping.getValue()).getAsJsonObject())) == null) continue;
                        throw new RuntimeException("Duplicate bedrock -> java item mapping for " + bedrockIdentifier2);
                    }
                }
                continue;
            }
            if (definition.has("meta")) {
                if (!this.bedrockMetaItems.contains(bedrockIdentifier2)) {
                    throw new RuntimeException("Tried to register block item as meta item: " + bedrockIdentifier2);
                }
                JsonObject jsonObject3 = definition.get("meta").getAsJsonObject();
                HashMap<Integer, JavaItemMapping> hashMap = new HashMap<Integer, JavaItemMapping>(jsonObject3.size());
                this.bedrockToJavaMetaItems.put(bedrockIdentifier2, hashMap);
                for (Map.Entry metaMapping : jsonObject3.entrySet()) {
                    Integer meta;
                    try {
                        meta = Integer.parseInt((String)metaMapping.getKey());
                    }
                    catch (NumberFormatException e) {
                        meta = null;
                    }
                    if (hashMap.put(meta, this.parseJavaItemData(((JsonElement)metaMapping.getValue()).getAsJsonObject())) == null) continue;
                    throw new RuntimeException("Duplicate bedrock -> java item mapping for " + bedrockIdentifier2 + ":" + meta);
                }
                if (hashMap.containsKey(null)) continue;
                throw new RuntimeException("Missing bedrock -> java item mapping for " + bedrockIdentifier2 + ":null");
            }
            throw new RuntimeException("Unknown item mapping definition: " + String.valueOf(definition));
        }
        for (Map.Entry<String, Map<Integer, JavaItemMapping>> entry9 : this.bedrockToJavaMetaItems.entrySet()) {
            String bedrockIdentifier3 = entry9.getKey();
            for (Map.Entry entry10 : entry9.getValue().entrySet()) {
                String newBedrockIdentifier;
                Integer n = (Integer)entry10.getKey();
                if (n == null || (newBedrockIdentifier = this.bedrockItemUpgrader.upgradeMetaItem(bedrockIdentifier3, n)) == null) continue;
                if (newBedrockIdentifier.equals(((JavaItemMapping)entry10.getValue()).identifier())) {
                    throw new RuntimeException("Redundant bedrock -> java item mapping for " + bedrockIdentifier3 + ":" + n);
                }
                throw new RuntimeException("Upgraded " + bedrockIdentifier3 + ":" + n + " to " + newBedrockIdentifier + " but it was mapped to " + ((JavaItemMapping)entry10.getValue()).identifier());
            }
        }
        entry7 = bedrockItems.iterator();
        while (entry7.hasNext()) {
            String string = (String)((Object)entry7.next());
            if (this.bedrockToJavaBlockItems.containsKey(string) || this.bedrockToJavaMetaItems.containsKey(string)) continue;
            throw new RuntimeException("Missing bedrock -> java item mapping for " + string);
        }
        JsonArray javaMenusJson = javaViaMappingJson.get("menus").getAsJsonArray();
        ArrayList<String> arrayList = new ArrayList<String>(javaMenusJson.size());
        for (JsonElement menuJson : javaMenusJson) {
            arrayList.add(Key.namespaced((String)menuJson.getAsString()));
        }
        JsonObject bedrockToJavaContainersJson = this.readJson("custom/container_mappings.json");
        this.bedrockToJavaContainers = new EnumMap<ContainerType, Integer>(ContainerType.class);
        HashSet<ContainerType> unmappedContainerTypes = new HashSet<ContainerType>();
        for (Map.Entry entry11 : bedrockToJavaContainersJson.entrySet()) {
            ContainerType bedrockContainerType = ContainerType.valueOf((String)entry11.getKey());
            if (((JsonElement)entry11.getValue()).isJsonNull()) {
                unmappedContainerTypes.add(bedrockContainerType);
                continue;
            }
            String javaIdentifier2 = ((JsonElement)entry11.getValue()).getAsString();
            int javaId = arrayList.indexOf(javaIdentifier2);
            if (javaId == -1) {
                throw new IllegalStateException("Unknown java menu: " + javaIdentifier2);
            }
            this.bedrockToJavaContainers.put(bedrockContainerType, javaId);
        }
        for (ContainerType containerType : ContainerType.values()) {
            if (this.bedrockToJavaContainers.containsKey((Object)containerType) || unmappedContainerTypes.contains((Object)containerType)) continue;
            throw new RuntimeException("Missing bedrock -> java container mapping for " + containerType.name());
        }
        CompoundTag compoundTag = this.readNBT("bedrock/entity_identifiers.nbt");
        ListTag entityIdentifiersListTag = compoundTag.getListTag("idlist", CompoundTag.class);
        this.bedrockEntities = HashBiMap.create((int)entityIdentifiersListTag.size());
        for (Object entry12 : entityIdentifiersListTag) {
            this.bedrockEntities.put((Object)entry12.getStringTag("id").getValue(), (Object)entry12.getIntTag("rid").asInt());
        }
        JsonObject entityDataTypesJson = this.readJson("bedrock/entity_data_types.json");
        this.bedrockEntityDataTypes = new EnumMap<ActorDataIDs, DataItemType>(ActorDataIDs.class);
        Iterator unmappedEntityDataIds = EnumSet.noneOf(ActorDataIDs.class);
        for (Object entry7 : entityDataTypesJson.entrySet()) {
            ActorDataIDs actorDataIDs = ActorDataIDs.valueOf((String)entry7.getKey());
            if (((JsonElement)entry7.getValue()).isJsonNull()) {
                unmappedEntityDataIds.add((ActorDataIDs)actorDataIDs);
                continue;
            }
            this.bedrockEntityDataTypes.put(actorDataIDs, DataItemType.valueOf(((JsonElement)entry7.getValue()).getAsString()));
        }
        bedrockToJavaItemMappingsJson = ActorDataIDs.values();
        int entry27 = ((Object)bedrockToJavaItemMappingsJson).length;
        boolean bl2 = false;
        while (var9_57 < entry27) {
            Object entityDataId = bedrockToJavaItemMappingsJson[var9_57];
            if (!this.bedrockEntityDataTypes.containsKey(entityDataId) && !unmappedEntityDataIds.contains(entityDataId)) {
                throw new RuntimeException("Missing bedrock entity data type mapping for " + ((Enum)entityDataId).name());
            }
            ++var9_57;
        }
        JsonObject entityFlagMoLangQueryMappingsJson = this.readJson("bedrock/entity_flag_molang_query_mappings.json");
        this.bedrockEntityFlagMoLangQueries = new EnumMap<ActorFlags, String>(ActorFlags.class);
        EnumSet<ActorFlags> unmappedEntityFlags = EnumSet.noneOf(ActorFlags.class);
        for (Map.Entry entry12 : entityFlagMoLangQueryMappingsJson.entrySet()) {
            ActorFlags entityFlag = ActorFlags.valueOf((String)entry12.getKey());
            if (((JsonElement)entry12.getValue()).isJsonNull()) {
                unmappedEntityFlags.add(entityFlag);
                continue;
            }
            this.bedrockEntityFlagMoLangQueries.put(entityFlag, ((JsonElement)entry12.getValue()).getAsString());
        }
        for (ActorFlags actorFlags : ActorFlags.values()) {
            if (this.bedrockEntityFlagMoLangQueries.containsKey((Object)actorFlags) || unmappedEntityFlags.contains((Object)actorFlags)) continue;
            throw new RuntimeException("Missing bedrock MoLang query mapping for " + actorFlags.name());
        }
        JsonObject bedrockToJavaEntityMappingsJson = this.readJson("custom/entity_mappings.json");
        this.bedrockToJavaEntities = new HashMap<String, EntityTypes1_21_9>(bedrockToJavaEntityMappingsJson.size());
        HashSet<String> unmappedEntities = new HashSet<String>();
        for (Map.Entry entry13 : bedrockToJavaEntityMappingsJson.entrySet()) {
            void var13_145;
            String bedrockIdentifier5 = (String)entry13.getKey();
            if (!this.bedrockEntities.containsKey((Object)bedrockIdentifier5)) {
                throw new RuntimeException("Unknown bedrock entity identifier: " + bedrockIdentifier5);
            }
            if (((JsonElement)entry13.getValue()).isJsonNull()) {
                unmappedEntities.add(bedrockIdentifier5);
                continue;
            }
            String string = ((JsonElement)entry13.getValue()).getAsString();
            Object var13_143 = null;
            for (EntityTypes1_21_9 type : EntityTypes1_21_9.values()) {
                if (type.isAbstractType() || !type.identifier().equals(string)) continue;
                EntityTypes1_21_9 entityTypes1_21_9 = type;
                break;
            }
            if (var13_145 == null) {
                throw new RuntimeException("Unknown java entity identifier: " + string);
            }
            this.bedrockToJavaEntities.put(bedrockIdentifier5, (EntityTypes1_21_9)var13_145);
        }
        for (String bedrockIdentifier6 : this.bedrockEntities.keySet()) {
            if (this.bedrockToJavaEntities.containsKey(bedrockIdentifier6) || unmappedEntities.contains(bedrockIdentifier6)) continue;
            throw new RuntimeException("Missing bedrock -> java entity mapping for " + bedrockIdentifier6);
        }
        JsonArray jsonArray4 = javaViaMappingJson.get("blockentities").getAsJsonArray();
        this.javaBlockEntities = HashBiMap.create((int)jsonArray4.size());
        for (int i = 0; i < jsonArray4.size(); ++i) {
            this.javaBlockEntities.put((Object)jsonArray4.get(i).getAsString(), (Object)i);
        }
        Object javaEntityAttributesJson = javaViaMappingJson.get("attributes").getAsJsonArray();
        this.javaEntityAttributes = HashBiMap.create((int)javaEntityAttributesJson.size());
        for (int i = 0; i < javaEntityAttributesJson.size(); ++i) {
            this.javaEntityAttributes.put((Object)Key.namespaced((String)javaEntityAttributesJson.get(i).getAsString()), (Object)i);
        }
        JsonObject javaEntityDataJson = this.readJson("java/entity_data.json");
        this.javaEntityData = new EnumMap<EntityTypes1_21_9, List<String>>(EntityTypes1_21_9.class);
        for (Map.Entry entry13 : javaEntityDataJson.entrySet()) {
            if (EnumUtil.getEnumConstantOrNull(EntityTypes1_21_9.class, (String)entry13.getKey()) != null) continue;
            throw new RuntimeException("Unknown java entity type: " + (String)entry13.getKey());
        }
        for (EntityTypes1_21_9 type : EntityTypes1_21_9.values()) {
            if (type.isAbstractType()) continue;
            EntityTypes1_21_9 realType = type;
            ArrayList entityData = new ArrayList();
            do {
                JsonArray entityDataArray;
                if ((entityDataArray = javaEntityDataJson.getAsJsonArray(type.name())) == null) continue;
                ArrayList<String> arrayList2 = new ArrayList<String>(entityDataArray.size());
                for (JsonElement jsonElement : entityDataArray) {
                    if (entityData.contains(jsonElement.getAsString()) || arrayList2.contains(jsonElement.getAsString())) {
                        throw new IllegalStateException("Duplicate entity data for " + realType.name() + ": " + jsonElement.getAsString());
                    }
                    arrayList2.add(jsonElement.getAsString());
                }
                entityData.addAll(0, arrayList2);
            } while ((type = (EntityTypes1_21_9)type.getParent()) != null);
            this.javaEntityData.put(realType, entityData);
        }
        JsonArray jsonArray5 = this.readJson("java/effects.json", JsonArray.class);
        this.javaEffects = HashBiMap.create((int)jsonArray5.size());
        for (int i = 0; i < jsonArray5.size(); ++i) {
            this.javaEffects.put((Object)jsonArray5.get(i).getAsString(), (Object)i);
        }
        JsonArray bedrockEffectsJson = this.readJson("bedrock/effects.json", JsonArray.class);
        this.bedrockEffects = HashBiMap.create((int)bedrockEffectsJson.size());
        for (int i = 0; i < bedrockEffectsJson.size(); ++i) {
            this.bedrockEffects.put((Object)bedrockEffectsJson.get(i).getAsString(), (Object)(i + 1));
        }
        JsonObject bedrockToJavaEffectMappingsJson = this.readJson("custom/effect_mappings.json");
        this.bedrockToJavaEffects = new HashMap<String, String>(bedrockToJavaEffectMappingsJson.size());
        for (Object entry6 : bedrockToJavaEffectMappingsJson.entrySet()) {
            String bedrockIdentifier7 = (String)entry6.getKey();
            if (!this.bedrockEffects.containsKey((Object)bedrockIdentifier7)) {
                throw new IllegalStateException("Unknown bedrock effect: " + bedrockIdentifier7);
            }
            String string = ((JsonElement)entry6.getValue()).getAsString();
            if (!this.javaEffects.containsKey((Object)string)) {
                throw new IllegalStateException("Unknown java effect: " + string);
            }
            this.bedrockToJavaEffects.put(bedrockIdentifier7, string);
        }
        for (Object bedrockIdentifier8 : this.bedrockEffects.keySet()) {
            if (this.bedrockToJavaEffects.containsKey(bedrockIdentifier8)) continue;
            throw new IllegalStateException("Missing bedrock -> java effect mapping for " + (String)bedrockIdentifier8);
        }
        JsonArray jsonArray6 = javaViaMappingJson.get("sounds").getAsJsonArray();
        this.javaSounds = HashBiMap.create((int)jsonArray6.size());
        for (int i = 0; i < jsonArray6.size(); ++i) {
            this.javaSounds.put((Object)Key.namespaced((String)jsonArray6.get(i).getAsString()), (Object)i);
        }
        JsonArray javaParticlesJson = javaViaMappingJson.get("particles").getAsJsonArray();
        this.javaParticles = HashBiMap.create((int)javaParticlesJson.size());
        for (int i = 0; i < javaParticlesJson.size(); ++i) {
            this.javaParticles.put((Object)Key.namespaced((String)javaParticlesJson.get(i).getAsString()), (Object)i);
        }
        JsonObject bedrockSoundsJson = this.readJson("bedrock/sounds.json");
        HashMap<String, String> bedrockSounds = new HashMap<String, String>(bedrockSoundsJson.size());
        for (Object entry16 : bedrockSoundsJson.entrySet()) {
            bedrockSounds.put((String)entry16.getKey(), ((JsonElement)entry16.getValue()).getAsString());
        }
        JsonObject bedrockBlockSoundsJson = this.readJson("bedrock/block_sounds.json");
        this.bedrockBlockSounds = new HashMap<String, String>(bedrockBlockSoundsJson.size());
        for (Map.Entry entry14 : bedrockBlockSoundsJson.entrySet()) {
            this.bedrockBlockSounds.put((String)entry14.getKey(), ((JsonElement)entry14.getValue()).getAsString());
        }
        JsonObject bedrockLevelSoundEventMappingsJson = this.readJson("bedrock/level_sound_event_mappings.json");
        this.bedrockLevelSoundEvents = new EnumMap<SharedTypes_Legacy_LevelSoundEvent, Map<String, SoundDefinitions.ConfiguredSound>>(SharedTypes_Legacy_LevelSoundEvent.class);
        EnumSet<SharedTypes_Legacy_LevelSoundEvent> enumSet = EnumSet.noneOf(SharedTypes_Legacy_LevelSoundEvent.class);
        for (Map.Entry entry282 : bedrockLevelSoundEventMappingsJson.entrySet()) {
            SharedTypes_Legacy_LevelSoundEvent sharedTypes_Legacy_LevelSoundEvent = SharedTypes_Legacy_LevelSoundEvent.valueOf((String)entry282.getKey());
            if (((JsonElement)entry282.getValue()).isJsonNull()) {
                enumSet.add(sharedTypes_Legacy_LevelSoundEvent);
                continue;
            }
            JsonObject jsonObject4 = ((JsonElement)entry282.getValue()).getAsJsonObject();
            HashMap<String, SoundDefinitions.ConfiguredSound> soundEvents = new HashMap<String, SoundDefinitions.ConfiguredSound>(jsonObject4.size());
            for (Map.Entry soundEventEntry : jsonObject4.entrySet()) {
                SoundDefinitions.ConfiguredSound configuredSound;
                String[] keySplit = ((String)soundEventEntry.getKey()).split(":", 2);
                if (keySplit[0].equals("entity")) {
                    if (!this.bedrockEntities.containsKey((Object)keySplit[1])) {
                        throw new RuntimeException("Unknown bedrock entity: " + keySplit[1]);
                    }
                } else if (keySplit[0].equals("block")) {
                    if (!this.bedrockBlockSounds.containsValue(keySplit[1])) {
                        throw new RuntimeException("Unknown bedrock block sound: " + keySplit[1]);
                    }
                } else if (!keySplit[0].isEmpty()) {
                    throw new RuntimeException("Unknown bedrock level sound event definition: " + (String)soundEventEntry.getKey());
                }
                if (!bedrockSounds.containsKey((configuredSound = SoundDefinitions.ConfiguredSound.fromJson(((JsonElement)soundEventEntry.getValue()).getAsJsonObject())).sound())) {
                    throw new RuntimeException("Unknown bedrock sound: " + configuredSound.sound());
                }
                if (((String)soundEventEntry.getKey()).isEmpty()) {
                    soundEvents.put(null, configuredSound);
                    continue;
                }
                soundEvents.put(keySplit[1], configuredSound);
            }
            this.bedrockLevelSoundEvents.put(sharedTypes_Legacy_LevelSoundEvent, soundEvents);
        }
        javaEntityAttributesJson = SharedTypes_Legacy_LevelSoundEvent.values();
        int entry282 = ((Object)javaEntityAttributesJson).length;
        boolean bl3 = false;
        while (var12_121 < entry282) {
            Object object = javaEntityAttributesJson[var12_121];
            if (!this.bedrockLevelSoundEvents.containsKey(object) && !enumSet.contains(object)) {
                throw new RuntimeException("Missing bedrock -> java level sound event mapping for " + ((Enum)object).name());
            }
            ++var12_121;
        }
        JsonObject bedrockNoteBlockInstrumentMappingsJson = this.readJson("bedrock/note_block_instrument_mappings.json");
        this.bedrockNoteBlockInstrumentSounds = new EnumMap<NoteBlockInstrument, String>(NoteBlockInstrument.class);
        for (Map.Entry entry15 : bedrockNoteBlockInstrumentMappingsJson.entrySet()) {
            NoteBlockInstrument noteBlockInstrument = NoteBlockInstrument.valueOf((String)entry15.getKey());
            String sound = ((JsonElement)entry15.getValue()).getAsString();
            if (!bedrockSounds.containsKey(sound)) {
                throw new RuntimeException("Unknown bedrock sound: " + sound);
            }
            this.bedrockNoteBlockInstrumentSounds.put(noteBlockInstrument, sound);
        }
        NoteBlockInstrument[] entry282 = NoteBlockInstrument.values();
        int n = entry282.length;
        boolean bl4 = false;
        while (var13_152 < n) {
            NoteBlockInstrument noteBlockInstrument = entry282[var13_152];
            if (!this.bedrockNoteBlockInstrumentSounds.containsKey((Object)noteBlockInstrument)) {
                throw new RuntimeException("Missing bedrock -> java note block instrument mapping for " + noteBlockInstrument.name());
            }
            ++var13_152;
        }
        JsonObject bedrockToJavaSoundCategoryMappingsJson = this.readJson("custom/sound_category_mappings.json");
        HashMap<String, SoundSource> hashMap = new HashMap<String, SoundSource>(bedrockToJavaSoundCategoryMappingsJson.size());
        for (Map.Entry entry20 : bedrockToJavaSoundCategoryMappingsJson.entrySet()) {
            String bedrockName = (String)entry20.getKey();
            if (!bedrockSounds.containsValue(bedrockName)) {
                throw new IllegalStateException("Unknown bedrock sound category: " + bedrockName);
            }
            SoundSource javaCategory = SoundSource.valueOf(((JsonElement)entry20.getValue()).getAsString());
            hashMap.put(bedrockName, javaCategory);
        }
        for (String categoryName : bedrockSounds.values()) {
            if (hashMap.containsKey(categoryName)) continue;
            throw new IllegalStateException("Missing bedrock -> java sound category mapping for " + categoryName);
        }
        JsonObject jsonObject5 = this.readJson("custom/sound_mappings.json");
        this.bedrockToJavaSounds = new HashMap<String, JavaSound>(jsonObject5.size());
        HashSet<String> unmappedSounds = new HashSet<String>();
        for (Map.Entry entry21 : jsonObject5.entrySet()) {
            String bedrockIdentifier9 = (String)entry21.getKey();
            if (!bedrockSounds.containsKey(bedrockIdentifier9)) {
                throw new IllegalStateException("Unknown bedrock sound: " + bedrockIdentifier9);
            }
            if (((JsonElement)entry21.getValue()).isJsonNull()) {
                unmappedSounds.add(bedrockIdentifier9);
                continue;
            }
            String javaIdentifier4 = ((JsonElement)entry21.getValue()).getAsString();
            if (!this.javaSounds.containsKey((Object)javaIdentifier4)) {
                throw new IllegalStateException("Unknown java sound: " + javaIdentifier4);
            }
            JavaSound javaSound = new JavaSound((Integer)this.javaSounds.get((Object)javaIdentifier4), javaIdentifier4, (SoundSource)((Object)hashMap.get(bedrockSounds.get(bedrockIdentifier9))));
            this.bedrockToJavaSounds.put(bedrockIdentifier9, javaSound);
        }
        for (String bedrockIdentifier10 : bedrockSounds.keySet()) {
            if (this.bedrockToJavaSounds.containsKey(bedrockIdentifier10) || unmappedSounds.contains(bedrockIdentifier10)) continue;
            throw new IllegalStateException("Missing bedrock -> java sound mapping for " + bedrockIdentifier10);
        }
        JsonArray bedrockParticlesJson = this.readJson("bedrock/particles.json", JsonArray.class);
        ArrayList<String> bedrockParticles = new ArrayList<String>(bedrockParticlesJson.size());
        for (JsonElement particleJson : bedrockParticlesJson) {
            bedrockParticles.add(particleJson.getAsString());
        }
        JsonObject bedrockToJavaParticleMappingsJson = this.readJson("custom/particle_mappings.json");
        this.bedrockToJavaParticles = new HashMap<String, JavaParticle>(bedrockToJavaParticleMappingsJson.size());
        HashSet<String> unmappedParticles = new HashSet<String>();
        for (Map.Entry entry22 : bedrockToJavaParticleMappingsJson.entrySet()) {
            String string = (String)entry22.getKey();
            if (!bedrockParticles.contains(string)) {
                throw new IllegalStateException("Unknown bedrock particle: " + string);
            }
            if (((JsonElement)entry22.getValue()).isJsonNull()) {
                unmappedParticles.add(string);
                continue;
            }
            if (((JsonElement)entry22.getValue()).isJsonObject()) {
                this.bedrockToJavaParticles.put(string, this.parseJavaParticle(((JsonElement)entry22.getValue()).getAsJsonObject()));
                continue;
            }
            String javaIdentifier5 = ((JsonElement)entry22.getValue()).getAsString();
            if (!this.javaParticles.containsKey((Object)javaIdentifier5)) {
                throw new IllegalStateException("Unknown java particle: " + javaIdentifier5);
            }
            JavaParticle javaParticleMapping = new JavaParticle(new Particle(((Integer)this.javaParticles.get((Object)javaIdentifier5)).intValue()), 0.0f, 0.0f, 0.0f, 0.0f, 0);
            this.bedrockToJavaParticles.put(string, javaParticleMapping);
        }
        for (String bedrockIdentifier12 : bedrockParticles) {
            if (this.bedrockToJavaParticles.containsKey(bedrockIdentifier12) || unmappedParticles.contains(bedrockIdentifier12)) continue;
            throw new IllegalStateException("Missing bedrock -> java particle mapping for " + bedrockIdentifier12);
        }
        JsonObject jsonObject6 = this.readJson("custom/level_event_mappings.json");
        this.bedrockToJavaLevelEvents = new EnumMap<net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.LevelEvent, LevelEventMapping>(net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.LevelEvent.class);
        EnumSet<net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.LevelEvent> unmappedLevelEvents = EnumSet.noneOf(net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.LevelEvent.class);
        for (Map.Entry entry23 : jsonObject6.entrySet()) {
            net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.LevelEvent levelEvent = net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.LevelEvent.valueOf((String)entry23.getKey());
            if (((JsonElement)entry23.getValue()).isJsonNull()) {
                unmappedLevelEvents.add(levelEvent);
                continue;
            }
            if (((JsonElement)entry23.getValue()).isJsonObject()) {
                JsonObject mapping = ((JsonElement)entry23.getValue()).getAsJsonObject();
                if (mapping.has("event")) {
                    Integer data = mapping.has("data") ? Integer.valueOf(mapping.get("data").getAsInt()) : null;
                    JavaLevelEvent javaLevelEvent = new JavaLevelEvent(LevelEvent.valueOf(mapping.get("event").getAsString()), data);
                    this.bedrockToJavaLevelEvents.put(levelEvent, javaLevelEvent);
                    continue;
                }
                if (mapping.has("sound")) {
                    String bedrockSound = mapping.get("sound").getAsString();
                    if (!this.bedrockToJavaSounds.containsKey(bedrockSound)) {
                        throw new IllegalStateException("Unknown bedrock sound: " + bedrockSound);
                    }
                    if (mapping.has("event")) {
                        Integer data = mapping.has("data") ? Integer.valueOf(mapping.get("data").getAsInt()) : null;
                        JavaLevelEvent javaLevelEvent = new JavaLevelEvent(LevelEvent.valueOf(mapping.get("event").getAsString()), data);
                        this.bedrockToJavaLevelEvents.put(levelEvent, new JavaSoundLevelEvent(this.bedrockToJavaSounds.get(bedrockSound), javaLevelEvent));
                        continue;
                    }
                    this.bedrockToJavaLevelEvents.put(levelEvent, this.bedrockToJavaSounds.get(bedrockSound));
                    continue;
                }
                if (mapping.has("particle")) {
                    this.bedrockToJavaLevelEvents.put(levelEvent, this.parseJavaParticle(mapping));
                    continue;
                }
                throw new IllegalStateException("Unknown level event mapping: " + String.valueOf(mapping));
            }
            this.bedrockToJavaLevelEvents.put(levelEvent, new JavaLevelEvent(LevelEvent.valueOf(((JsonElement)entry23.getValue()).getAsString()), null));
        }
        for (net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.LevelEvent levelEvent : net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.LevelEvent.values()) {
            if (this.bedrockToJavaLevelEvents.containsKey((Object)levelEvent) || unmappedLevelEvents.contains((Object)levelEvent)) continue;
            throw new RuntimeException("Missing bedrock -> java level event mapping for " + levelEvent.name());
        }
        JsonObject jsonObject7 = this.readJson("custom/level_event_particle_mappings.json");
        this.bedrockToJavaLevelEventParticles = new EnumMap<ParticleType, JavaParticle>(ParticleType.class);
        EnumSet<ParticleType> unmappedParticleTypes = EnumSet.noneOf(ParticleType.class);
        for (Map.Entry entry24 : jsonObject7.entrySet()) {
            ParticleType particleType = ParticleType.valueOf((String)entry24.getKey());
            if (((JsonElement)entry24.getValue()).isJsonNull()) {
                unmappedParticleTypes.add(particleType);
                continue;
            }
            if (((JsonElement)entry24.getValue()).isJsonObject()) {
                this.bedrockToJavaLevelEventParticles.put(particleType, this.parseJavaParticle(((JsonElement)entry24.getValue()).getAsJsonObject()));
                continue;
            }
            String javaIdentifier6 = ((JsonElement)entry24.getValue()).getAsString();
            if (!this.javaParticles.containsKey((Object)javaIdentifier6)) {
                throw new IllegalStateException("Unknown java particle: " + javaIdentifier6);
            }
            JavaParticle javaParticleMapping = new JavaParticle(new Particle(((Integer)this.javaParticles.get((Object)javaIdentifier6)).intValue()), 0.0f, 0.0f, 0.0f, 0.0f, 0);
            this.bedrockToJavaLevelEventParticles.put(particleType, javaParticleMapping);
        }
        for (ParticleType particleType : ParticleType.values()) {
            if (this.bedrockToJavaLevelEventParticles.containsKey((Object)particleType) || unmappedParticleTypes.contains((Object)particleType)) continue;
            throw new RuntimeException("Missing bedrock -> java level event particle mapping for " + particleType.name());
        }
        JsonObject jsonObject8 = this.readJson("custom/experimental_feature_mappings.json");
        this.bedrockToJavaExperimentalFeatures = HashBiMap.create((int)jsonObject8.size());
        for (Object entry25 : jsonObject8.entrySet()) {
            this.bedrockToJavaExperimentalFeatures.put((Object)((String)entry25.getKey()), (Object)((JsonElement)entry25.getValue()).getAsString());
        }
        JsonObject bedrockToJavaBannerPatternMappingsJson = this.readJson("custom/banner_pattern_mappings.json");
        this.bedrockToJavaBannerPatterns = HashBiMap.create((int)bedrockToJavaBannerPatternMappingsJson.size());
        for (Object entry12 : bedrockToJavaBannerPatternMappingsJson.entrySet()) {
            String javaIdentifier7 = ((JsonElement)entry12.getValue()).getAsString();
            if (!this.javaRegistries.getCompoundTag("minecraft:banner_pattern").contains(javaIdentifier7)) {
                throw new RuntimeException("Unknown java banner pattern: " + (String)javaIdentifier7);
            }
            this.bedrockToJavaBannerPatterns.put((Object)((String)entry12.getKey()), (Object)javaIdentifier7);
        }
        CompoundTag javaPaintingVariantRegistry = this.javaRegistries.getCompoundTag("minecraft:painting_variant");
        JsonObject bedrockToJavaPaintingMappingsJson = this.readJson("custom/painting_mappings.json");
        this.bedrockToJavaPaintings = HashBiMap.create((int)bedrockToJavaPaintingMappingsJson.size());
        for (Map.Entry entry16 : bedrockToJavaPaintingMappingsJson.entrySet()) {
            String string = ((JsonElement)entry16.getValue()).getAsString();
            if (!javaPaintingVariantRegistry.contains(string)) {
                throw new RuntimeException("Unknown java painting: " + string);
            }
            this.bedrockToJavaPaintings.put((Object)((String)entry16.getKey()), (Object)string);
        }
        CompoundTag javaDamageTypeRegistry = this.javaRegistries.getCompoundTag("minecraft:damage_type");
        JsonObject bedrockToJavaDamageCauseMappingsJson = this.readJson("custom/damage_cause_mappings.json");
        this.bedrockToJavaDamageCauses = new EnumMap<ActorDamageCause, String>(ActorDamageCause.class);
        for (Map.Entry entry26 : bedrockToJavaDamageCauseMappingsJson.entrySet()) {
            ActorDamageCause damageCause = ActorDamageCause.valueOf((String)entry26.getKey());
            String string = ((JsonElement)entry26.getValue()).getAsString();
            if (!javaDamageTypeRegistry.contains(string)) {
                throw new RuntimeException("Unknown java damage cause: " + string);
            }
            this.bedrockToJavaDamageCauses.put(damageCause, string);
        }
        for (ActorDamageCause actorDamageCause : ActorDamageCause.values()) {
            if (this.bedrockToJavaDamageCauses.containsKey((Object)actorDamageCause)) continue;
            throw new RuntimeException("Missing bedrock -> java damage cause mapping for " + actorDamageCause.name());
        }
    }

    public Map<String, ResourcePack> getBedrockVanillaResourcePacks() {
        return this.bedrockVanillaResourcePacks;
    }

    public Map<String, Object> getBedrockGameRules() {
        return this.bedrockGameRules;
    }

    public CompoundTag getJavaRegistries() {
        return this.javaRegistries;
    }

    public CompoundTag getJavaTags() {
        return this.javaTags;
    }

    public BiMap<String, Integer> getJavaCommandArgumentTypes() {
        return this.javaCommandArgumentTypes;
    }

    public BlockStateUpgrader getBedrockBlockStateUpgrader() {
        return this.bedrockBlockStateUpgrader;
    }

    public BiMap<BlockState, Integer> getJavaBlockStates() {
        return this.javaBlockStates;
    }

    public Set<BedrockBlockState> getBedrockBlockStates() {
        return this.bedrockBlockStates;
    }

    public Map<BlockState, BlockState> getBedrockToJavaBlockStates() {
        return this.bedrockToJavaBlockStates;
    }

    public Map<String, String> getBedrockBlockTags() {
        return this.bedrockBlockTags;
    }

    public Map<String, Map<String, Set<String>>> getBedrockBlockTraits() {
        return this.bedrockBlockTraits;
    }

    public BiMap<String, Integer> getBedrockLegacyBlocks() {
        return this.bedrockLegacyBlocks;
    }

    public Int2ObjectMap<BedrockBlockState> getBedrockLegacyBlockStates() {
        return this.bedrockLegacyBlockStates;
    }

    public IntSet getJavaPreWaterloggedBlockStates() {
        return this.javaPreWaterloggedBlockStates;
    }

    public Int2IntMap getJavaPottedBlockStates() {
        return this.javaPottedBlockStates;
    }

    public Map<String, IntSet> getJavaHeightMapBlockStates() {
        return this.javaHeightMapBlockStates;
    }

    public CompoundTag getBedrockBiomeDefinitions() {
        return this.bedrockBiomeDefinitions;
    }

    public BiMap<String, Integer> getBedrockBiomes() {
        return this.bedrockBiomes;
    }

    public BiMap<String, Integer> getJavaBiomes() {
        return this.javaBiomes;
    }

    public Map<String, Map<String, Object>> getBedrockToJavaBiomeExtraData() {
        return this.bedrockToJavaBiomeExtraData;
    }

    public ItemUpgrader getBedrockItemUpgrader() {
        return this.bedrockItemUpgrader;
    }

    public BiMap<String, Integer> getJavaItems() {
        return this.javaItems;
    }

    public Set<String> getBedrockBlockItems() {
        return this.bedrockBlockItems;
    }

    public Set<String> getBedrockMetaItems() {
        return this.bedrockMetaItems;
    }

    public Map<String, String> getBedrockItemTags() {
        return this.bedrockItemTags;
    }

    public Map<String, Map<BlockState, JavaItemMapping>> getBedrockToJavaBlockItems() {
        return this.bedrockToJavaBlockItems;
    }

    public Map<String, Map<Integer, JavaItemMapping>> getBedrockToJavaMetaItems() {
        return this.bedrockToJavaMetaItems;
    }

    public Map<ContainerType, Integer> getBedrockToJavaContainers() {
        return this.bedrockToJavaContainers;
    }

    public BiMap<String, Integer> getBedrockEntities() {
        return this.bedrockEntities;
    }

    public Map<ActorDataIDs, DataItemType> getBedrockEntityDataTypes() {
        return this.bedrockEntityDataTypes;
    }

    public Map<ActorFlags, String> getBedrockEntityFlagMoLangQueries() {
        return this.bedrockEntityFlagMoLangQueries;
    }

    public Map<String, EntityTypes1_21_9> getBedrockToJavaEntities() {
        return this.bedrockToJavaEntities;
    }

    public BiMap<String, Integer> getJavaBlockEntities() {
        return this.javaBlockEntities;
    }

    public BiMap<String, Integer> getJavaEntityAttributes() {
        return this.javaEntityAttributes;
    }

    public Map<EntityTypes1_21_9, List<String>> getJavaEntityData() {
        return this.javaEntityData;
    }

    public BiMap<String, Integer> getJavaEffects() {
        return this.javaEffects;
    }

    public BiMap<String, Integer> getBedrockEffects() {
        return this.bedrockEffects;
    }

    public Map<String, String> getBedrockToJavaEffects() {
        return this.bedrockToJavaEffects;
    }

    public BiMap<String, Integer> getJavaSounds() {
        return this.javaSounds;
    }

    public BiMap<String, Integer> getJavaParticles() {
        return this.javaParticles;
    }

    public Map<String, String> getBedrockBlockSounds() {
        return this.bedrockBlockSounds;
    }

    public Map<SharedTypes_Legacy_LevelSoundEvent, Map<String, SoundDefinitions.ConfiguredSound>> getBedrockLevelSoundEvents() {
        return this.bedrockLevelSoundEvents;
    }

    public Map<NoteBlockInstrument, String> getBedrockNoteBlockInstrumentSounds() {
        return this.bedrockNoteBlockInstrumentSounds;
    }

    public Map<String, JavaSound> getBedrockToJavaSounds() {
        return this.bedrockToJavaSounds;
    }

    public Map<String, JavaParticle> getBedrockToJavaParticles() {
        return this.bedrockToJavaParticles;
    }

    public Map<net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.LevelEvent, LevelEventMapping> getBedrockToJavaLevelEvents() {
        return this.bedrockToJavaLevelEvents;
    }

    public Map<ParticleType, JavaParticle> getBedrockToJavaLevelEventParticles() {
        return this.bedrockToJavaLevelEventParticles;
    }

    public BiMap<String, String> getBedrockToJavaExperimentalFeatures() {
        return this.bedrockToJavaExperimentalFeatures;
    }

    public BiMap<String, String> getBedrockToJavaBannerPatterns() {
        return this.bedrockToJavaBannerPatterns;
    }

    public BiMap<String, String> getBedrockToJavaPaintings() {
        return this.bedrockToJavaPaintings;
    }

    public Map<ActorDamageCause, String> getBedrockToJavaDamageCauses() {
        return this.bedrockToJavaDamageCauses;
    }

    protected Logger getLogger() {
        return ViaBedrock.getPlatform().getLogger();
    }

    private ResourcePack readResourcePack(String file, UUID uuid, String version) {
        ResourcePack resourcePack;
        block8: {
            file = "assets/viabedrock/data/" + (String)file;
            InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream((String)file);
            try {
                byte[] bytes = inputStream.readAllBytes();
                ResourcePack resourcePack2 = new ResourcePack(uuid, version, new byte[0], "", "", false, false, false, null, 0L, PackType.Resources);
                resourcePack2.setCompressedDataLength(bytes.length, bytes.length);
                resourcePack2.processDataChunk(0, bytes);
                resourcePack = resourcePack2;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Could not read " + (String)file, e);
                    return null;
                }
            }
            inputStream.close();
        }
        return resourcePack;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CompoundTag readNBT(String file) {
        file = "assets/viabedrock/data/" + (String)file;
        try (InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream((String)file);){
            if (inputStream == null) {
                this.getLogger().severe("Could not open " + (String)file);
                CompoundTag compoundTag2 = null;
                return compoundTag2;
            }
            CompoundTag compoundTag = (CompoundTag)NBTIO.readTag((DataInput)new DataInputStream(new GZIPInputStream(inputStream)), (TagLimiter)TagLimiter.noop(), (boolean)true, CompoundTag.class);
            return compoundTag;
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Could not read " + (String)file, e);
            return null;
        }
    }

    private JsonObject readJson(String file) {
        return this.readJson(file, JsonObject.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T readJson(String file, Class<T> classOfT) {
        file = "assets/viabedrock/data/" + (String)file;
        try (InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream((String)file);){
            if (inputStream == null) {
                this.getLogger().severe("Could not open " + (String)file);
                T t = null;
                return t;
            }
            Object object = GsonUtil.getGson().fromJson((Reader)new InputStreamReader(inputStream), classOfT);
            return (T)object;
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Could not read " + (String)file, e);
            return null;
        }
    }

    private JavaParticle parseJavaParticle(JsonObject obj) {
        String javaIdentifier = obj.get("particle").getAsString();
        if (!this.javaParticles.containsKey((Object)javaIdentifier)) {
            throw new IllegalStateException("Unknown java particle: " + javaIdentifier);
        }
        float offsetX = obj.has("offset_x") ? obj.get("offset_x").getAsFloat() : 0.0f;
        float offsetY = obj.has("offset_y") ? obj.get("offset_y").getAsFloat() : 0.0f;
        float offsetZ = obj.has("offset_z") ? obj.get("offset_z").getAsFloat() : 0.0f;
        float speed = obj.has("speed") ? obj.get("speed").getAsFloat() : 0.0f;
        int count = obj.has("count") ? obj.get("count").getAsInt() : 0;
        Particle particle = new Particle(((Integer)this.javaParticles.get((Object)javaIdentifier)).intValue());
        if (obj.has("arguments")) {
            block16: for (JsonElement argument : obj.get("arguments").getAsJsonArray()) {
                String type;
                JsonObject argumentObject = argument.getAsJsonObject();
                switch (type = argumentObject.get("type").getAsString()) {
                    case "var_int": {
                        particle.add((Type)Types.VAR_INT, (Object)argumentObject.get("value").getAsInt());
                        continue block16;
                    }
                    case "float": {
                        particle.add((Type)Types.FLOAT, (Object)Float.valueOf(argumentObject.get("value").getAsFloat()));
                        continue block16;
                    }
                    case "double": {
                        particle.add((Type)Types.DOUBLE, (Object)argumentObject.get("value").getAsDouble());
                        continue block16;
                    }
                    case "int": {
                        particle.add((Type)Types.INT, (Object)argumentObject.get("value").getAsInt());
                        continue block16;
                    }
                    case "block_state": {
                        BlockState javaBlockState = BlockState.fromString(argumentObject.get("value").getAsString());
                        if (!this.javaBlockStates.containsKey((Object)javaBlockState)) {
                            throw new IllegalStateException("Unknown java block state: " + javaBlockState.toBlockStateString());
                        }
                        particle.add((Type)Types.VAR_INT, (Object)((Integer)this.javaBlockStates.get((Object)javaBlockState)));
                        continue block16;
                    }
                    case "item_stack": {
                        String identifier = argumentObject.get("value").getAsString();
                        if (!this.javaItems.containsKey((Object)identifier)) {
                            throw new IllegalStateException("Unknown java item: " + identifier);
                        }
                        particle.add(VersionedTypes.V1_21_9.item, (Object)new StructuredItem(((Integer)this.javaItems.get((Object)identifier)).intValue(), 1, ProtocolConstants.createStructuredDataContainer()));
                        continue block16;
                    }
                }
                throw new IllegalStateException("Unknown particle argument type: " + type);
            }
        }
        return new JavaParticle(particle, offsetX, offsetY, offsetZ, speed, count);
    }

    private void buildLegacyBlockStateMappings() {
        try (InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("assets/viabedrock/data/bedrock/block_id_meta_to_1_12_0_nbt.bin");){
            if (inputStream == null) {
                this.getLogger().severe("Could not open block_id_meta_to_1_12_0_nbt.bin");
                return;
            }
            byte[] bytes = inputStream.readAllBytes();
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])bytes);
            this.bedrockLegacyBlockStates = new Int2ObjectOpenHashMap();
            int blockCount = BedrockTypes.UNSIGNED_VAR_INT.read(buf);
            for (int i = 0; i < blockCount; ++i) {
                String identifier = ((String)BedrockTypes.STRING.read(buf)).toLowerCase(Locale.ROOT);
                if (!this.bedrockLegacyBlocks.containsKey((Object)identifier)) {
                    throw new RuntimeException("Unknown block identifier in block_id_meta_to_1_12_0_nbt.bin: " + identifier);
                }
                int id = (Integer)this.bedrockLegacyBlocks.get((Object)identifier);
                int metaCount = BedrockTypes.UNSIGNED_VAR_INT.read(buf);
                for (int i1 = 0; i1 < metaCount; ++i1) {
                    int metadata = BedrockTypes.UNSIGNED_VAR_INT.read(buf);
                    CompoundTag tag = (CompoundTag)BedrockTypes.TAG_LE.read(buf);
                    this.bedrockBlockStateUpgrader.upgradeToLatest(tag);
                    BedrockBlockState bedrockBlockState = BedrockBlockState.fromNbt(tag);
                    if (!this.bedrockBlockStates.contains(bedrockBlockState)) {
                        throw new RuntimeException("Legacy block state " + bedrockBlockState.toBlockStateString() + " is not mapped to a modern block state");
                    }
                    this.bedrockLegacyBlockStates.put(id << 6 | metadata & 0x3F, (Object)bedrockBlockState);
                }
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Could not read block_id_meta_to_1_12_0_nbt.bin", e);
            this.bedrockLegacyBlockStates = null;
        }
    }

    private JavaItemMapping parseJavaItemData(JsonObject obj) {
        String javaIdentifier = obj.get("java_id").getAsString();
        if (!this.javaItems.containsKey((Object)javaIdentifier)) {
            throw new RuntimeException("Unknown java item: " + javaIdentifier);
        }
        String javaName = obj.has("java_name") ? obj.get("java_name").getAsString() : null;
        CompoundTag javaTag = null;
        try {
            if (obj.has("java_tag")) {
                javaTag = SNBT.deserializeCompoundTag((String)obj.get("java_tag").getAsString());
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to parse java tag for " + javaIdentifier, e);
        }
        return new JavaItemMapping((Integer)this.javaItems.get((Object)javaIdentifier), javaIdentifier, javaName, javaTag);
    }

    public record JavaItemMapping(int id, String identifier, String name, CompoundTag overrideTag) {
    }

    public record JavaSound(int id, String identifier, SoundSource category) implements LevelEventMapping
    {
    }

    public record JavaParticle(Particle particle, float offsetX, float offsetY, float offsetZ, float speed, int count) implements LevelEventMapping
    {
        public JavaParticle withParticle(Particle particle) {
            return new JavaParticle(particle, this.offsetX, this.offsetY, this.offsetZ, this.speed, this.count);
        }

        public JavaParticle withCount(int count) {
            return new JavaParticle(this.particle, this.offsetX, this.offsetY, this.offsetZ, this.speed, count);
        }
    }

    public record JavaLevelEvent(LevelEvent levelEvent, Integer data) implements LevelEventMapping
    {
    }

    public record JavaSoundLevelEvent(JavaSound sound, JavaLevelEvent levelEvent) implements LevelEventMapping
    {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface LevelEventMapping {
    }
}

