/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.data.enums;

public enum DyeColor {
    WHITE(0xFFFFFF),
    ORANGE(16738335),
    MAGENTA(0xFF00FF),
    LIGHT_BLUE(10141901),
    YELLOW(0xFFFF00),
    LIME(0xBFFF00),
    PINK(16738740),
    GRAY(0x808080),
    LIGHT_GRAY(0xD3D3D3),
    CYAN(65535),
    PURPLE(10494192),
    BLUE(255),
    BROWN(9127187),
    GREEN(65280),
    RED(0xFF0000),
    BLACK(0);

    private static final DyeColor[] JAVA_VALUES;
    private static final DyeColor[] BEDROCK_VALUES;
    private final int signColor;

    private DyeColor(int signColor) {
        this.signColor = signColor;
    }

    public static DyeColor getByJavaId(int id, DyeColor fallback) {
        DyeColor color = DyeColor.getByJavaId(id);
        return color == null ? fallback : color;
    }

    public static DyeColor getByJavaId(int id) {
        if (id < 0 || id >= JAVA_VALUES.length) {
            return null;
        }
        return JAVA_VALUES[id];
    }

    public static DyeColor getByBedrockId(int id, DyeColor fallback) {
        DyeColor color = DyeColor.getByBedrockId(id);
        return color == null ? fallback : color;
    }

    public static DyeColor getByBedrockId(int id) {
        if (id < 0 || id >= BEDROCK_VALUES.length) {
            return null;
        }
        return BEDROCK_VALUES[id];
    }

    public static DyeColor getClosestDyeColor(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        DyeColor closest = null;
        int closestDistance = Integer.MAX_VALUE;
        for (DyeColor color : DyeColor.values()) {
            int colorR = color.signColor >> 16 & 0xFF;
            int colorG = color.signColor >> 8 & 0xFF;
            int colorB = color.signColor & 0xFF;
            int distance = (r - colorR) * (r - colorR) + (g - colorG) * (g - colorG) + (b - colorB) * (b - colorB);
            if (distance >= closestDistance) continue;
            closest = color;
            closestDistance = distance;
        }
        return closest;
    }

    public int signColor() {
        return this.signColor | 0xFF000000;
    }

    public byte javaId() {
        return (byte)this.ordinal();
    }

    public byte bedrockId() {
        return (byte)(DyeColor.values().length - 1 - this.ordinal());
    }

    static {
        JAVA_VALUES = new DyeColor[DyeColor.values().length];
        BEDROCK_VALUES = new DyeColor[DyeColor.values().length];
        DyeColor[] dyeColorArray = DyeColor.values();
        int n = dyeColorArray.length;
        for (int i = 0; i < n; ++i) {
            DyeColor color;
            DyeColor.JAVA_VALUES[color.javaId()] = color = dyeColorArray[i];
            DyeColor.BEDROCK_VALUES[color.bedrockId()] = color;
        }
    }
}

