/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.data.enums.bedrock.generated;

import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectOpenHashMap;

public enum InventorySourceType {
    InvalidInventory(Integer.MAX_VALUE),
    ContainerInventory(0),
    GlobalInventory(1),
    WorldInteraction(2),
    CreativeInventory(3),
    NonImplementedFeatureTODO(99999);

    private static final Int2ObjectMap<InventorySourceType> BY_VALUE;
    private final int value;

    public static InventorySourceType getByValue(int value) {
        return (InventorySourceType)((Object)BY_VALUE.get(value));
    }

    public static InventorySourceType getByValue(int value, InventorySourceType fallback) {
        return (InventorySourceType)((Object)BY_VALUE.getOrDefault(value, (Object)fallback));
    }

    private InventorySourceType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    static {
        BY_VALUE = new Int2ObjectOpenHashMap();
        for (InventorySourceType value : InventorySourceType.values()) {
            if (BY_VALUE.containsKey(value.value)) continue;
            BY_VALUE.put(value.value, (Object)value);
        }
    }
}

