/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.packet;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.ProtocolInfo;
import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.protocols.base.ClientboundLoginPackets;
import com.viaversion.viaversion.protocols.base.ServerboundHandshakePackets;
import com.viaversion.viaversion.protocols.base.ServerboundLoginPackets;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.Locator;
import io.jsonwebtoken.LocatorAdapter;
import io.jsonwebtoken.ProtectedHeader;
import io.jsonwebtoken.gson.io.GsonDeserializer;
import io.jsonwebtoken.security.SecureDigestAlgorithm;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.io.compression.ProtocolCompression;
import net.raphimc.viabedrock.api.util.PacketFactory;
import net.raphimc.viabedrock.api.util.ServerBlacklist;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ClientboundBedrockPackets;
import net.raphimc.viabedrock.protocol.ServerboundBedrockPackets;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.AuthenticationType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.PacketCompressionAlgorithm;
import net.raphimc.viabedrock.protocol.provider.NettyPipelineProvider;
import net.raphimc.viabedrock.protocol.provider.SkinProvider;
import net.raphimc.viabedrock.protocol.storage.AuthChainData;
import net.raphimc.viabedrock.protocol.storage.GameSessionStorage;
import net.raphimc.viabedrock.protocol.storage.HandshakeStorage;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class LoginPackets {
    private static final KeyFactory EC_KEYFACTORY;
    private static final String MOJANG_PUBLIC_KEY_BASE64 = "MHYwEAYHKoZIzj0CAQYFK4EEACIDYgAECRXueJeTDqNRRgJi/vlRufByu/2G0i2Ebt6YMar5QX/R0DIIyrJMcUpruK4QveTfJSTp3Shlq4Gk34cD/4GUWwkv0DVuzeuB+tXija7HBxii03NHDbPAD0AKnLr2wdAp";
    private static final ECPublicKey MOJANG_PUBLIC_KEY;
    private static final int CLOCK_SKEW = 60;
    private static final Gson GSON;
    private static final GsonDeserializer<Map<String, ?>> GSON_DESERIALIZER;

    public static void register(BedrockProtocol protocol) {
        protocol.registerClientbound(ClientboundBedrockPackets.NETWORK_SETTINGS, null, wrapper -> {
            wrapper.cancel();
            GameSessionStorage gameSession = (GameSessionStorage)wrapper.user().get(GameSessionStorage.class);
            HandshakeStorage handshakeStorage = (HandshakeStorage)wrapper.user().get(HandshakeStorage.class);
            AuthChainData authChainData = (AuthChainData)wrapper.user().get(AuthChainData.class);
            int threshold = (Integer)wrapper.read((Type)BedrockTypes.UNSIGNED_SHORT_LE);
            PacketCompressionAlgorithm algorithm = PacketCompressionAlgorithm.getByValue((Integer)wrapper.read((Type)BedrockTypes.UNSIGNED_SHORT_LE), PacketCompressionAlgorithm.None);
            ProtocolCompression protocolCompression = new ProtocolCompression(algorithm, threshold);
            if (gameSession.getProtocolCompression() == null) {
                ((NettyPipelineProvider)Via.getManager().getProviders().get(NettyPipelineProvider.class)).enableCompression(wrapper.user(), protocolCompression);
            } else {
                gameSession.getProtocolCompression().end();
            }
            gameSession.setProtocolCompression(protocolCompression);
            JsonObject certificateChainObj = new JsonObject();
            JsonArray chain = new JsonArray();
            if (authChainData.getSelfSignedJwt() != null) {
                chain.add((JsonElement)new JsonPrimitive(authChainData.getSelfSignedJwt()));
            }
            if (authChainData.getMojangJwt() != null) {
                chain.add((JsonElement)new JsonPrimitive(authChainData.getMojangJwt()));
            }
            if (authChainData.getIdentityJwt() != null) {
                chain.add((JsonElement)new JsonPrimitive(authChainData.getIdentityJwt()));
            }
            certificateChainObj.add("chain", (JsonElement)chain);
            JsonObject authInfoObj = new JsonObject();
            authInfoObj.addProperty("AuthenticationType", (Number)(authChainData.getMojangJwt() != null ? AuthenticationType.Full.ordinal() : AuthenticationType.SelfSigned.ordinal()));
            authInfoObj.addProperty("Certificate", certificateChainObj.toString());
            authInfoObj.addProperty("Token", "");
            String authInfo = authInfoObj.toString();
            PacketWrapper login = PacketWrapper.create((PacketType)ServerboundBedrockPackets.LOGIN, (UserConnection)wrapper.user());
            login.write((Type)Types.INT, (Object)handshakeStorage.protocolVersion());
            login.write((Type)BedrockTypes.UNSIGNED_VAR_INT, (Object)(authInfo.length() + authChainData.getSkinJwt().length() + 8));
            login.write(BedrockTypes.ASCII_STRING, (Object)authInfo);
            login.write(BedrockTypes.ASCII_STRING, (Object)authChainData.getSkinJwt());
            login.sendToServer(BedrockProtocol.class);
        });
        protocol.registerClientbound(ClientboundBedrockPackets.SERVER_TO_CLIENT_HANDSHAKE, null, wrapper -> {
            wrapper.cancel();
            AuthChainData authChainData = (AuthChainData)wrapper.user().get(AuthChainData.class);
            Jws jwt = Jwts.parser().clockSkewSeconds(60L).keyLocator((Locator)new LocatorAdapter<Key>(){

                protected Key locate(ProtectedHeader header) {
                    return LoginPackets.publicKeyFromBase64((String)header.get((Object)"x5u"));
                }
            }).build().parseSignedClaims((CharSequence)wrapper.read(BedrockTypes.STRING));
            try {
                byte[] salt = Base64.getDecoder().decode((String)((Claims)jwt.getPayload()).get("salt", String.class));
                SecretKey secretKey = LoginPackets.ecdhKeyExchange(authChainData.getPrivateKey(), LoginPackets.publicKeyFromBase64((String)((JwsHeader)jwt.getHeader()).get((Object)"x5u")), salt);
                ((NettyPipelineProvider)Via.getManager().getProviders().get(NettyPipelineProvider.class)).enableEncryption(wrapper.user(), secretKey);
            }
            catch (Throwable e) {
                throw new RuntimeException("Could not enable encryption", e);
            }
            PacketWrapper clientToServerHandshake = PacketWrapper.create((PacketType)ServerboundBedrockPackets.CLIENT_TO_SERVER_HANDSHAKE, (UserConnection)wrapper.user());
            clientToServerHandshake.sendToServer(BedrockProtocol.class);
        });
        protocol.registerServerboundTransition((ServerboundPacketType)ServerboundHandshakePackets.CLIENT_INTENTION, null, wrapper -> {
            wrapper.cancel();
            int protocolVersion = (Integer)wrapper.read((Type)Types.VAR_INT);
            String hostname = (String)wrapper.read(Types.STRING);
            int port = (Integer)wrapper.read((Type)Types.UNSIGNED_SHORT);
            wrapper.user().put((StorableObject)new HandshakeStorage(protocolVersion, hostname, port));
        });
        protocol.registerServerboundTransition((ServerboundPacketType)ServerboundLoginPackets.HELLO, ServerboundBedrockPackets.REQUEST_NETWORK_SETTINGS, wrapper -> {
            HandshakeStorage handshakeStorage = (HandshakeStorage)wrapper.user().get(HandshakeStorage.class);
            if (!ViaBedrock.getConfig().shouldDisableServerBlacklist() && ServerBlacklist.isBlacklisted(handshakeStorage.hostname())) {
                wrapper.cancel();
                try {
                    PacketWrapper loginDisconnect = PacketWrapper.create((PacketType)ClientboundLoginPackets.LOGIN_DISCONNECT, (UserConnection)wrapper.user());
                    PacketFactory.writeJavaDisconnect(loginDisconnect, "\u00a7cThis server is blacklisted by ViaBedrock because the server is known to ban players joining with ViaBedrock (Due to the server's anti-cheat).\n\n\u00a77If you want to join the server anyway, set disable-server-blacklist to true in the ViaBedrock config file.");
                    loginDisconnect.send(BedrockProtocol.class);
                }
                catch (Throwable loginDisconnect) {
                    // empty catch block
                }
                if (wrapper.user().getChannel() != null) {
                    wrapper.user().getChannel().flush();
                    wrapper.user().getChannel().close();
                }
                return;
            }
            ProtocolInfo protocolInfo = wrapper.user().getProtocolInfo();
            protocolInfo.setUsername((String)wrapper.read(Types.STRING));
            protocolInfo.setUuid((UUID)wrapper.read(Types.UUID));
            wrapper.write((Type)Types.INT, (Object)handshakeStorage.protocolVersion());
            try {
                LoginPackets.validateAndFillAuthChainData(wrapper.user());
            }
            catch (Throwable e) {
                throw new RuntimeException("Could not validate and fill auth chain data", e);
            }
        });
        protocol.registerServerboundTransition((ServerboundPacketType)ServerboundLoginPackets.LOGIN_ACKNOWLEDGED, null, PacketWrapper::cancel);
    }

    private static ECPublicKey publicKeyFromBase64(String base64) {
        try {
            return (ECPublicKey)EC_KEYFACTORY.generatePublic(new X509EncodedKeySpec(Base64.getDecoder().decode(base64)));
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("Could not decode base64 public key", e);
        }
    }

    private static void validateAndFillAuthChainData(UserConnection user) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        if (user.has(AuthChainData.class)) {
            AuthChainData authChainData = (AuthChainData)user.get(AuthChainData.class);
            ECPublicKey publicKey = authChainData.getPublicKey();
            ECPrivateKey privateKey = authChainData.getPrivateKey();
            String encodedPublicKey = Base64.getEncoder().encodeToString(publicKey.getEncoded());
            Jws mojangJwt = Jwts.parser().clockSkewSeconds(60L).verifyWith((PublicKey)MOJANG_PUBLIC_KEY).json(GSON_DESERIALIZER).build().parseSignedClaims((CharSequence)authChainData.getMojangJwt());
            ECPublicKey mojangJwtPublicKey = LoginPackets.publicKeyFromBase64((String)((Claims)mojangJwt.getPayload()).get("identityPublicKey", String.class));
            Jws identityJwt = Jwts.parser().clockSkewSeconds(60L).verifyWith((PublicKey)mojangJwtPublicKey).build().parseSignedClaims((CharSequence)authChainData.getIdentityJwt());
            if (authChainData.getSelfSignedJwt() == null) {
                String selfSignedJwt = ((JwtBuilder)((JwtBuilder.BuilderHeader)Jwts.builder().signWith((Key)privateKey, (SecureDigestAlgorithm)Jwts.SIG.ES384).header().add((Object)"x5u", (Object)encodedPublicKey)).and()).claim("certificateAuthority", (Object)true).claim("identityPublicKey", ((JwsHeader)mojangJwt.getHeader()).get((Object)"x5u")).expiration(Date.from(Instant.now().plus(2L, ChronoUnit.DAYS))).notBefore(Date.from(Instant.now().minus(1L, ChronoUnit.MINUTES))).compact();
                authChainData.setSelfSignedJwt(selfSignedJwt);
            }
            if (authChainData.getSkinJwt() == null) {
                String skinData = ((JwtBuilder)((JwtBuilder.BuilderHeader)Jwts.builder().signWith((Key)privateKey, (SecureDigestAlgorithm)Jwts.SIG.ES384).header().add((Object)"x5u", (Object)encodedPublicKey)).and()).claims(((SkinProvider)Via.getManager().getProviders().get(SkinProvider.class)).getClientPlayerSkin(user)).compact();
                authChainData.setSkinJwt(skinData);
            }
            Map extraData = (Map)((Claims)identityJwt.getPayload()).get("extraData", Map.class);
            authChainData.setXuid((String)extraData.get("XUID"));
            authChainData.setIdentity(UUID.fromString((String)extraData.get("identity")));
            authChainData.setDisplayName((String)extraData.get("displayName"));
        } else {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
            keyPairGenerator.initialize(new ECGenParameterSpec("secp384r1"));
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            ECPublicKey publicKey = (ECPublicKey)keyPair.getPublic();
            ECPrivateKey privateKey = (ECPrivateKey)keyPair.getPrivate();
            String encodedPublicKey = Base64.getEncoder().encodeToString(publicKey.getEncoded());
            String displayName = user.getProtocolInfo().getUsername();
            UUID offlineUUID = UUID.nameUUIDFromBytes(("OfflinePlayer:" + displayName).getBytes(StandardCharsets.UTF_8));
            HashMap<String, String> extraData = new HashMap<String, String>();
            extraData.put("XUID", Long.toString(offlineUUID.getLeastSignificantBits()));
            extraData.put("identity", offlineUUID.toString());
            extraData.put("displayName", displayName);
            extraData.put("titleId", "1739947436");
            extraData.put("sandboxId", "RETAIL");
            String identityJwt = ((JwtBuilder)((JwtBuilder.BuilderHeader)Jwts.builder().signWith((Key)privateKey, (SecureDigestAlgorithm)Jwts.SIG.ES384).header().add((Object)"x5u", (Object)encodedPublicKey)).and()).claim("identityPublicKey", (Object)encodedPublicKey).claim("randomNonce", (Object)ThreadLocalRandom.current().nextLong()).claim("extraData", extraData).issuer("Mojang").issuedAt(Date.from(Instant.now())).expiration(Date.from(Instant.now().plus(1L, ChronoUnit.DAYS))).notBefore(Date.from(Instant.now().minus(1L, ChronoUnit.MINUTES))).compact();
            AuthChainData authChainData = new AuthChainData(null, identityJwt, publicKey, privateKey, UUID.randomUUID());
            authChainData.setXuid((String)extraData.get("XUID"));
            authChainData.setIdentity(UUID.fromString((String)extraData.get("identity")));
            authChainData.setDisplayName((String)extraData.get("displayName"));
            user.put((StorableObject)authChainData);
            String skinData = ((JwtBuilder)((JwtBuilder.BuilderHeader)Jwts.builder().signWith((Key)privateKey, (SecureDigestAlgorithm)Jwts.SIG.ES384).header().add((Object)"x5u", (Object)encodedPublicKey)).and()).claims(((SkinProvider)Via.getManager().getProviders().get(SkinProvider.class)).getClientPlayerSkin(user)).compact();
            authChainData.setSkinJwt(skinData);
        }
    }

    private static SecretKey ecdhKeyExchange(ECPrivateKey localPrivateKey, ECPublicKey remotePublicKey, byte[] salt) throws NoSuchAlgorithmException, InvalidKeyException {
        KeyAgreement ecdh = KeyAgreement.getInstance("ECDH");
        ecdh.init(localPrivateKey);
        ecdh.doPhase(remotePublicKey, true);
        byte[] sharedSecret = ecdh.generateSecret();
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        sha256.update(salt);
        sha256.update(sharedSecret);
        return new SecretKeySpec(sha256.digest(), "AES");
    }

    static {
        GSON = new GsonBuilder().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).disableHtmlEscaping().create();
        GSON_DESERIALIZER = new GsonDeserializer(GSON);
        try {
            EC_KEYFACTORY = KeyFactory.getInstance("EC");
            MOJANG_PUBLIC_KEY = LoginPackets.publicKeyFromBase64(MOJANG_PUBLIC_KEY_BASE64);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not initialize the required cryptography", e);
        }
    }
}

