/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.packet;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.libs.gson.JsonArray;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.protocols.base.ClientboundStatusPackets;
import com.viaversion.viaversion.protocols.base.ServerboundStatusPackets;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.raphimc.viabedrock.protocol.BedrockProtocol;

public class StatusPackets {
    private static final String NULL_UUID = new UUID(0L, 0L).toString();

    public static void register(BedrockProtocol protocol) {
        protocol.registerClientbound(State.STATUS, 28, ClientboundStatusPackets.STATUS_RESPONSE.getId(), wrapper -> {
            long ping = System.nanoTime() / 1000000L - (Long)wrapper.read((Type)Types.LONG);
            String data = new String((byte[])wrapper.read(Types.REMAINING_BYTES), StandardCharsets.UTF_8);
            String[] splitData = data.split(";");
            JsonObject statusResponse = new JsonObject();
            JsonObject version = new JsonObject();
            JsonObject players = new JsonObject();
            JsonArray samples = new JsonArray();
            statusResponse.add("version", (JsonElement)version);
            statusResponse.add("players", (JsonElement)players);
            players.add("sample", (JsonElement)samples);
            JsonObject pingSample = new JsonObject();
            pingSample.addProperty("name", "Ping: " + ping + "ms");
            pingSample.addProperty("id", NULL_UUID);
            samples.add((JsonElement)pingSample);
            statusResponse.addProperty("description", "");
            version.addProperty("name", "");
            version.addProperty("protocol", (Number)wrapper.user().getProtocolInfo().protocolVersion().getVersion());
            players.addProperty("max", (Number)-1);
            players.addProperty("online", (Number)-1);
            switch (splitData.length) {
                default: {
                    JsonObject sample = new JsonObject();
                    sample.addProperty("name", "IPv6 Port: " + splitData[11]);
                    sample.addProperty("id", NULL_UUID);
                    samples.add((JsonElement)sample);
                }
                case 11: {
                    JsonObject sample = new JsonObject();
                    sample.addProperty("name", "IPv4 Port: " + splitData[10]);
                    sample.addProperty("id", NULL_UUID);
                    samples.add((JsonElement)sample);
                }
                case 10: {
                    JsonObject sample = new JsonObject();
                    sample.addProperty("name", "Nintendo limited: " + !"1".equalsIgnoreCase(splitData[9]));
                    sample.addProperty("id", NULL_UUID);
                    samples.add((JsonElement)sample);
                }
                case 9: {
                    JsonObject sample = new JsonObject();
                    sample.addProperty("name", "GameType: " + splitData[8]);
                    sample.addProperty("id", NULL_UUID);
                    samples.add((JsonElement)sample);
                }
                case 6: 
                case 7: 
                case 8: {
                    try {
                        players.addProperty("max", (Number)Integer.parseInt(splitData[5]));
                    }
                    catch (NumberFormatException sample) {
                        // empty catch block
                    }
                }
                case 5: {
                    try {
                        players.addProperty("online", (Number)Integer.parseInt(splitData[4]));
                    }
                    catch (NumberFormatException sample) {
                        // empty catch block
                    }
                }
                case 3: 
                case 4: {
                    JsonObject sample = new JsonObject();
                    sample.addProperty("name", "Protocol: " + splitData[2]);
                    sample.addProperty("id", NULL_UUID);
                    samples.add((JsonElement)sample);
                }
                case 2: {
                    statusResponse.addProperty("description", splitData[1] + (String)(splitData.length >= 8 ? "\n\u00a7r" + splitData[7] : ""));
                }
                case 1: {
                    String versionName = splitData[0] + (String)(splitData.length >= 4 ? " " + splitData[3] : "");
                    version.addProperty("name", versionName);
                    JsonObject sample = new JsonObject();
                    sample.addProperty("name", "Version: " + versionName);
                    sample.addProperty("id", NULL_UUID);
                    samples.add((JsonElement)sample);
                }
                case 0: 
            }
            wrapper.write(Types.STRING, (Object)statusResponse.toString());
        });
        protocol.registerServerbound(State.STATUS, ServerboundStatusPackets.STATUS_REQUEST.getId(), 1, wrapper -> wrapper.write((Type)Types.LONG, (Object)(System.nanoTime() / 1000000L)));
        protocol.registerServerbound(State.STATUS, ServerboundStatusPackets.PING_REQUEST.getId(), -1, wrapper -> {
            wrapper.cancel();
            PacketWrapper pongResponse = PacketWrapper.create((PacketType)ClientboundStatusPackets.PONG_RESPONSE, (UserConnection)wrapper.user());
            pongResponse.write((Type)Types.LONG, (Object)((Long)wrapper.read((Type)Types.LONG)));
            pongResponse.send(BedrockProtocol.class);
        });
    }
}

