/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.rewriter.blockentity;

import com.viaversion.nbt.tag.ByteTag;
import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.IntTag;
import com.viaversion.nbt.tag.ListTag;
import com.viaversion.nbt.tag.StringTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.blockentity.BlockEntity;
import com.viaversion.viaversion.api.minecraft.blockentity.BlockEntityImpl;
import com.viaversion.viaversion.libs.mcstructs.text.TextComponent;
import java.util.ArrayList;
import net.lenni0451.mcstructs_bedrock.text.utils.BedrockTextUtils;
import net.raphimc.viabedrock.api.chunk.BedrockBlockEntity;
import net.raphimc.viabedrock.api.util.TextUtil;
import net.raphimc.viabedrock.protocol.data.enums.DyeColor;
import net.raphimc.viabedrock.protocol.rewriter.BlockEntityRewriter;

public class SignBlockEntityRewriter
implements BlockEntityRewriter.Rewriter {
    @Override
    public BlockEntity toJava(UserConnection user, BedrockBlockEntity bedrockBlockEntity) {
        CompoundTag bedrockTag = bedrockBlockEntity.tag();
        CompoundTag javaTag = new CompoundTag();
        if (bedrockTag.get("Text") instanceof StringTag) {
            ByteTag textIgnoreLegacyBugResolvedTag;
            Tag tag = bedrockTag.get("TextIgnoreLegacyBugResolved");
            boolean textIgnoreLegacyBugResolved = tag instanceof ByteTag && (textIgnoreLegacyBugResolvedTag = (ByteTag)tag).asByte() != 0;
            bedrockTag.putByte("HideGlowOutline", textIgnoreLegacyBugResolved ? (byte)0 : 1);
            javaTag.put("front_text", (Tag)this.translateText(bedrockTag));
        } else {
            Tag tag = bedrockTag.get("FrontText");
            if (tag instanceof CompoundTag) {
                CompoundTag frontText = (CompoundTag)tag;
                javaTag.put("front_text", (Tag)this.translateText(frontText));
            }
            if ((tag = bedrockTag.get("BackText")) instanceof CompoundTag) {
                CompoundTag backText = (CompoundTag)tag;
                javaTag.put("back_text", (Tag)this.translateText(backText));
            }
        }
        this.copy(bedrockTag, javaTag, "IsWaxed", "is_waxed", ByteTag.class);
        return new BlockEntityImpl(bedrockBlockEntity.packedXZ(), bedrockBlockEntity.y(), -1, javaTag);
    }

    private CompoundTag translateText(CompoundTag bedrockText) {
        ByteTag hideGlowOutlineTag;
        boolean hideGlowOutline;
        ByteTag ignoreLightingTag;
        Tag tag;
        ByteTag persistFormatting;
        CompoundTag javaText = new CompoundTag();
        StringBuilder textBuilder = new StringBuilder();
        Tag tag2 = bedrockText.get("Text");
        if (tag2 instanceof StringTag) {
            StringTag textTag = (StringTag)tag2;
            textBuilder = new StringBuilder(textTag.getValue());
        } else {
            for (int i = 1; i <= 4; ++i) {
                String text = bedrockText.getString("Text" + i, "");
                if (text.isEmpty()) continue;
                if (!textBuilder.isEmpty()) {
                    textBuilder.append('\n');
                }
                textBuilder.append(text);
            }
        }
        String text = textBuilder.toString();
        ArrayList<TextComponent> components = new ArrayList<TextComponent>();
        String[] stringArray = bedrockText.get("PersistFormatting");
        if (stringArray instanceof ByteTag && (persistFormatting = (ByteTag)stringArray).asByte() != 0) {
            for (String line : BedrockTextUtils.split((String)text, (String)"\n")) {
                components.add(TextUtil.stringToTextComponent(line));
            }
        } else {
            for (String line : text.split("\n")) {
                components.add(TextUtil.stringToTextComponent(line));
            }
        }
        boolean ignoreLighting = !((tag = bedrockText.get("IgnoreLighting")) instanceof ByteTag) || (ignoreLightingTag = (ByteTag)tag).asByte() != 0;
        Tag tag3 = bedrockText.get("HideGlowOutline");
        boolean bl = hideGlowOutline = tag3 instanceof ByteTag && (hideGlowOutlineTag = (ByteTag)tag3).asByte() != 0;
        if (!hideGlowOutline && ignoreLighting) {
            javaText.putByte("has_glowing_text", (byte)1);
        }
        if ((tag3 = bedrockText.get("SignTextColor")) instanceof IntTag) {
            IntTag signTextColorTag = (IntTag)tag3;
            int signTextColor = signTextColorTag.asInt();
            if ((signTextColor >> 24 & 0xFF) < 100) {
                components.clear();
            }
            DyeColor dyeColor = DyeColor.getClosestDyeColor(signTextColor);
            javaText.putString("color", dyeColor.name().toLowerCase());
            for (TextComponent component : components) {
                component.forEach(c -> c.getStyle().setColor(signTextColor));
            }
        } else {
            javaText.putString("color", DyeColor.LIGHT_GRAY.name().toLowerCase());
        }
        ListTag messages = new ListTag(CompoundTag.class);
        for (int i = 0; i < 4; ++i) {
            messages.add((Tag)TextUtil.ensureCompoundTag(components.size() > i ? TextUtil.textComponentToNbt((TextComponent)components.get(i)) : TextUtil.stringToNbt("")));
        }
        javaText.put("messages", (Tag)messages);
        return javaText;
    }
}

