/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.rewriter.blockentity;

import com.viaversion.nbt.tag.ByteTag;
import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.FloatTag;
import com.viaversion.nbt.tag.IntTag;
import com.viaversion.nbt.tag.LongTag;
import com.viaversion.nbt.tag.StringTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.blockentity.BlockEntity;
import com.viaversion.viaversion.api.minecraft.blockentity.BlockEntityImpl;
import java.util.ArrayList;
import java.util.List;
import net.raphimc.viabedrock.api.chunk.BedrockBlockEntity;
import net.raphimc.viabedrock.protocol.rewriter.BlockEntityRewriter;

public class StructureBlockBlockEntityRewriter
implements BlockEntityRewriter.Rewriter {
    private static final List<String> ROTATION_MODES = new ArrayList<String>();
    private static final List<String> MIRROR_MODES = new ArrayList<String>();
    private static final List<String> DATA_MODES = new ArrayList<String>();

    @Override
    public BlockEntity toJava(UserConnection user, BedrockBlockEntity bedrockBlockEntity) {
        Tag tag;
        IntTag dataTag;
        int data;
        Tag mirror2;
        ByteTag mirrorTag;
        byte mirror2;
        Tag rotation2;
        ByteTag rotationTag;
        byte rotation2;
        CompoundTag bedrockTag = bedrockBlockEntity.tag();
        CompoundTag javaTag = new CompoundTag();
        Tag tag2 = bedrockTag.get("rotation");
        if (tag2 instanceof ByteTag && (rotation2 = (rotationTag = (ByteTag)tag2).asByte()) >= 0 && rotation2 < ROTATION_MODES.size()) {
            javaTag.putString("rotation", ROTATION_MODES.get(rotation2));
        }
        if ((rotation2 = bedrockTag.get("mirror")) instanceof ByteTag && (mirror2 = (mirrorTag = (ByteTag)rotation2).asByte()) >= 0 && mirror2 < MIRROR_MODES.size()) {
            javaTag.putString("mirror", MIRROR_MODES.get(mirror2));
        }
        if ((mirror2 = bedrockTag.get("data")) instanceof IntTag && (data = (dataTag = (IntTag)mirror2).asInt()) >= 0 && data < DATA_MODES.size()) {
            javaTag.putString("mode", DATA_MODES.get(data));
        }
        if ((tag = bedrockTag.get("integrity")) instanceof FloatTag) {
            FloatTag integrityTag = (FloatTag)tag;
            javaTag.putFloat("integrity", integrityTag.asFloat() / 100.0f);
        }
        this.copy(bedrockTag, javaTag, "structureName", "name", StringTag.class);
        this.copy(bedrockTag, javaTag, "xStructureOffset", "posX", IntTag.class);
        this.copy(bedrockTag, javaTag, "yStructureOffset", "posY", IntTag.class);
        this.copy(bedrockTag, javaTag, "zStructureOffset", "posZ", IntTag.class);
        this.copy(bedrockTag, javaTag, "xStructureSize", "sizeX", IntTag.class);
        this.copy(bedrockTag, javaTag, "yStructureSize", "sizeY", IntTag.class);
        this.copy(bedrockTag, javaTag, "zStructureSize", "sizeZ", IntTag.class);
        this.copy(bedrockTag, javaTag, "ignoreEntities", ByteTag.class);
        this.copy(bedrockTag, javaTag, "isPowered", "powered", ByteTag.class);
        this.copy(bedrockTag, javaTag, "removeBlocks", "showair", ByteTag.class);
        this.copy(bedrockTag, javaTag, "showBoundingBox", "showboundingbox", ByteTag.class);
        this.copy(bedrockTag, javaTag, "seed", LongTag.class);
        return new BlockEntityImpl(bedrockBlockEntity.packedXZ(), bedrockBlockEntity.y(), -1, javaTag);
    }

    static {
        ROTATION_MODES.add("NONE");
        ROTATION_MODES.add("CLOCKWISE_90");
        ROTATION_MODES.add("CLOCKWISE_180");
        ROTATION_MODES.add("COUNTERCLOCKWISE_90");
        MIRROR_MODES.add("NONE");
        MIRROR_MODES.add("LEFT_RIGHT");
        MIRROR_MODES.add("FRONT_BACK");
        DATA_MODES.add("INVALID");
        DATA_MODES.add("SAVE");
        DATA_MODES.add("LOAD");
        DATA_MODES.add("CORNER");
        DATA_MODES.add("DATA");
        DATA_MODES.add("EXPORT");
    }
}

