/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.rewriter.resourcepack;

import com.viaversion.viaversion.libs.gson.JsonArray;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import java.util.Locale;
import net.raphimc.viabedrock.api.model.resourcepack.ResourcePack;
import net.raphimc.viabedrock.protocol.rewriter.ResourcePackRewriter;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;

public class GlyphSheetResourceRewriter
implements ResourcePackRewriter.Rewriter {
    private static final int GLYPHS_PER_ROW = 16;
    private static final int GLYPHS_PER_COLUMN = 16;

    @Override
    public void apply(ResourcePacksStorage resourcePacksStorage, ResourcePack.Content javaContent) {
        JsonArray providers = new JsonArray();
        for (int i = 0; i < 255; ++i) {
            String pageName = "glyph_" + String.format("%1$02X", i) + ".png";
            String bedrockPath = "font/" + pageName;
            String javaPath = "font/" + pageName.toLowerCase(Locale.ROOT);
            for (ResourcePack pack : resourcePacksStorage.getPackStackTopToBottom()) {
                ResourcePack.Content bedrockContent = pack.content();
                if (!bedrockContent.contains(bedrockPath)) continue;
                javaContent.copyFrom(bedrockContent, bedrockPath, "assets/viabedrock/textures/" + javaPath);
                ResourcePack.Content.LazyImage image = bedrockContent.getImage(bedrockPath);
                int glyphHeight = image.getImage().getHeight() / 16;
                JsonObject glyphPage = new JsonObject();
                providers.add((JsonElement)glyphPage);
                glyphPage.addProperty("type", "bitmap");
                glyphPage.addProperty("file", "viabedrock:" + javaPath);
                glyphPage.addProperty("ascent", (Number)(glyphHeight / 2 + 5));
                glyphPage.addProperty("height", (Number)glyphHeight);
                JsonArray chars = new JsonArray();
                glyphPage.add("chars", (JsonElement)chars);
                for (int c = 0; c < 16; ++c) {
                    StringBuilder row = new StringBuilder();
                    for (int r = 0; r < 16; ++r) {
                        int idx = c * 16 + r;
                        row.append((char)(i << 8 | idx));
                    }
                    chars.add(row.toString());
                }
            }
        }
        if (!providers.isEmpty()) {
            JsonObject defaultJson = new JsonObject();
            defaultJson.add("providers", (JsonElement)providers);
            javaContent.putJson("assets/minecraft/font/default.json", defaultJson);
        }
    }
}

