/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.brigadier;

import com.google.common.collect.Lists;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.raphimc.viabedrock.api.brigadier.SuggestionsUtil;

public class EquipmentSlotArgumentType
implements ArgumentType<Object> {
    private static final List<String> SLOTS = Lists.newArrayList((Object[])new String[]{"slot.armor", "slot.armor.chest", "slot.armor.feet", "slot.armor.head", "slot.armor.legs", "slot.chest", "slot.enderchest", "slot.equippable", "slot.hotbar", "slot.inventory", "slot.saddle", "slot.weapon.mainhand", "slot.weapon.offhand"});
    private static final SimpleCommandExceptionType INVALID_EQUIPMENT_EXCEPTION = new SimpleCommandExceptionType((Message)new LiteralMessage("Invalid equipment slot"));

    public static EquipmentSlotArgumentType equipmentSlot() {
        return new EquipmentSlotArgumentType();
    }

    public Object parse(StringReader reader) throws CommandSyntaxException {
        String slot = reader.readUnquotedString();
        if (!SLOTS.contains(slot)) {
            throw INVALID_EQUIPMENT_EXCEPTION.create();
        }
        return null;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SuggestionsUtil.suggestMatching(SLOTS, builder);
    }
}

