/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.brigadier;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.viaversion.viaversion.util.Pair;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

public class SuggestionsUtil {
    public static CompletableFuture<Suggestions> suggestMatching(Iterable<String> candidates, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (String candidate : candidates) {
            if (!SuggestionsUtil.shouldSuggest(remaining, candidate.toLowerCase(Locale.ROOT))) continue;
            builder.suggest(candidate);
        }
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> suggestMatching(Stream<Pair<String, String>> candidates, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
        candidates.forEach(candidate -> {
            if (SuggestionsUtil.shouldSuggest(remaining, ((String)candidate.key()).toLowerCase(Locale.ROOT))) {
                builder.suggest((String)candidate.key(), (Message)(candidate.value() != null ? new LiteralMessage((String)candidate.value()) : null));
            }
        });
        return builder.buildFuture();
    }

    private static boolean shouldSuggest(String remaining, String candidate) {
        int i = 0;
        while (!candidate.startsWith(remaining, i)) {
            if ((i = candidate.indexOf(95, i)) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

