/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.io;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.raphimc.viabedrock.api.io.LittleEndianByteBufOutputStream;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class NetworkByteBufOutputStream
extends LittleEndianByteBufOutputStream {
    private final ByteBuf buffer;

    public NetworkByteBufOutputStream(ByteBuf buffer) {
        super(buffer);
        this.buffer = buffer;
    }

    @Override
    public void writeInt(int v) throws IOException {
        try {
            BedrockTypes.VAR_INT.write(this.buffer, v);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeLong(long v) throws IOException {
        try {
            BedrockTypes.VAR_LONG.write(this.buffer, v);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        try {
            BedrockTypes.STRING.write(this.buffer, (Object)s);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

