/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.util;

import com.google.common.primitives.Ints;
import java.util.Arrays;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;

public class LZ4 {
    private static final LZ4Factory LZ4_FACTORY = LZ4Factory.fastestInstance();
    private static final LZ4Compressor LZ4_COMPRESSOR = LZ4_FACTORY.highCompressor();
    private static final LZ4FastDecompressor LZ4_DECOMPRESSOR = LZ4_FACTORY.fastDecompressor();

    public static byte[] compress(byte[] input) {
        if (input == null) {
            return null;
        }
        int maxCompressedLength = LZ4_COMPRESSOR.maxCompressedLength(input.length);
        byte[] compressed = new byte[maxCompressedLength + 4];
        int compressedLength = LZ4_COMPRESSOR.compress(input, 0, input.length, compressed, 4);
        System.arraycopy(Ints.toByteArray((int)input.length), 0, compressed, 0, 4);
        return Arrays.copyOf(compressed, compressedLength + 4);
    }

    public static byte[] decompress(byte[] input) {
        if (input == null) {
            return null;
        }
        return LZ4_DECOMPRESSOR.decompress(input, 4, Ints.fromByteArray((byte[])input));
    }
}

