/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.util;

import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.BlockPosition;
import com.viaversion.viaversion.api.minecraft.blockentity.BlockEntity;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.version.VersionedTypes;
import com.viaversion.viaversion.libs.gson.JsonNull;
import com.viaversion.viaversion.protocols.v1_21_7to1_21_9.packet.ClientboundPackets1_21_9;
import net.raphimc.viabedrock.api.model.container.Container;
import net.raphimc.viabedrock.api.model.entity.Entity;
import net.raphimc.viabedrock.api.util.MathUtil;
import net.raphimc.viabedrock.api.util.TextUtil;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ServerboundBedrockPackets;
import net.raphimc.viabedrock.protocol.data.BedrockMappingData;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ContainerType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ServerboundLoadingScreenPacketType;
import net.raphimc.viabedrock.protocol.data.enums.java.CustomChatCompletionsAction;
import net.raphimc.viabedrock.protocol.data.enums.java.EntityEvent;
import net.raphimc.viabedrock.protocol.data.enums.java.GameEventType;
import net.raphimc.viabedrock.protocol.model.Position3f;
import net.raphimc.viabedrock.protocol.storage.InventoryTracker;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class PacketFactory {
    public static void sendJavaSystemChat(UserConnection user, Tag message) {
        PacketWrapper systemChat = PacketWrapper.create((PacketType)ClientboundPackets1_21_9.SYSTEM_CHAT, (UserConnection)user);
        systemChat.write(Types.TAG, (Object)message);
        systemChat.write((Type)Types.BOOLEAN, (Object)false);
        systemChat.send(BedrockProtocol.class);
    }

    public static void sendJavaBlockEntityData(UserConnection user, BlockPosition position, BlockEntity blockEntity) {
        PacketWrapper blockEntityData = PacketWrapper.create((PacketType)ClientboundPackets1_21_9.BLOCK_ENTITY_DATA, (UserConnection)user);
        blockEntityData.write(Types.BLOCK_POSITION1_14, (Object)position);
        blockEntityData.write((Type)Types.VAR_INT, (Object)blockEntity.typeId());
        blockEntityData.write(Types.COMPOUND_TAG, (Object)blockEntity.tag());
        blockEntityData.send(BedrockProtocol.class);
    }

    public static void sendJavaCustomChatCompletions(UserConnection user, CustomChatCompletionsAction action, String[] entries) {
        PacketWrapper customChatCompletions = PacketWrapper.create((PacketType)ClientboundPackets1_21_9.CUSTOM_CHAT_COMPLETIONS, (UserConnection)user);
        customChatCompletions.write((Type)Types.VAR_INT, (Object)action.ordinal());
        customChatCompletions.write(Types.STRING_ARRAY, (Object)entries);
        customChatCompletions.send(BedrockProtocol.class);
    }

    public static void sendJavaContainerSetContent(UserConnection user, Container container) {
        PacketWrapper containerSetContent = PacketWrapper.create((PacketType)ClientboundPackets1_21_9.CONTAINER_SET_CONTENT, (UserConnection)user);
        PacketFactory.writeJavaContainerSetContent(containerSetContent, container);
        containerSetContent.send(BedrockProtocol.class);
    }

    public static void sendJavaGameEvent(UserConnection user, GameEventType event, float value) {
        PacketWrapper gameEvent = PacketWrapper.create((PacketType)ClientboundPackets1_21_9.GAME_EVENT, (UserConnection)user);
        gameEvent.write((Type)Types.UNSIGNED_BYTE, (Object)((short)event.ordinal()));
        gameEvent.write((Type)Types.FLOAT, (Object)Float.valueOf(value));
        gameEvent.send(BedrockProtocol.class);
    }

    public static void sendJavaEntityEvent(UserConnection user, Entity entity, EntityEvent event) {
        PacketWrapper entityEvent = PacketWrapper.create((PacketType)ClientboundPackets1_21_9.ENTITY_EVENT, (UserConnection)user);
        entityEvent.write((Type)Types.INT, (Object)entity.javaId());
        entityEvent.write((Type)Types.BYTE, (Object)event.getValue());
        entityEvent.send(BedrockProtocol.class);
    }

    public static void sendJavaContainerClose(UserConnection user, int containerId) {
        PacketWrapper containerClose = PacketWrapper.create((PacketType)ClientboundPackets1_21_9.CONTAINER_CLOSE, (UserConnection)user);
        containerClose.write((Type)Types.VAR_INT, (Object)containerId);
        containerClose.send(BedrockProtocol.class);
    }

    public static void sendJavaRotateHead(UserConnection user, Entity entity) {
        PacketWrapper rotateHead = PacketWrapper.create((PacketType)ClientboundPackets1_21_9.ROTATE_HEAD, (UserConnection)user);
        rotateHead.write((Type)Types.VAR_INT, (Object)entity.javaId());
        rotateHead.write((Type)Types.BYTE, (Object)MathUtil.float2Byte(entity.rotation().z()));
        rotateHead.send(BedrockProtocol.class);
    }

    public static void sendJavaBlockChangedAck(UserConnection user, int sequence) {
        PacketWrapper blockChangedAck = PacketWrapper.create((PacketType)ClientboundPackets1_21_9.BLOCK_CHANGED_ACK, (UserConnection)user);
        blockChangedAck.write((Type)Types.VAR_INT, (Object)sequence);
        blockChangedAck.send(BedrockProtocol.class);
    }

    public static void sendJavaBlockUpdate(UserConnection user, BlockPosition position, int blockState) {
        PacketWrapper blockUpdate = PacketWrapper.create((PacketType)ClientboundPackets1_21_9.BLOCK_UPDATE, (UserConnection)user);
        blockUpdate.write(Types.BLOCK_POSITION1_14, (Object)position);
        blockUpdate.write((Type)Types.VAR_INT, (Object)blockState);
        blockUpdate.send(BedrockProtocol.class);
    }

    public static void sendJavaLevelParticles(UserConnection user, Position3f position, BedrockMappingData.JavaParticle particle) {
        PacketWrapper levelParticles = PacketWrapper.create((PacketType)ClientboundPackets1_21_9.LEVEL_PARTICLES, (UserConnection)user);
        PacketFactory.writeJavaLevelParticles(levelParticles, position, particle);
        levelParticles.send(BedrockProtocol.class);
    }

    public static void sendBedrockContainerClose(UserConnection user, byte containerId, ContainerType containerType) {
        PacketWrapper containerClose = PacketWrapper.create((PacketType)ServerboundBedrockPackets.CONTAINER_CLOSE, (UserConnection)user);
        containerClose.write((Type)Types.BYTE, (Object)containerId);
        containerClose.write((Type)Types.BYTE, (Object)((byte)containerType.getValue()));
        containerClose.write((Type)Types.BOOLEAN, (Object)false);
        containerClose.sendToServer(BedrockProtocol.class);
    }

    public static void sendBedrockLoadingScreen(UserConnection user, ServerboundLoadingScreenPacketType type, Long loadingScreenId) {
        PacketWrapper loadingScreen = PacketWrapper.create((PacketType)ServerboundBedrockPackets.LOADING_SCREEN, (UserConnection)user);
        loadingScreen.write((Type)BedrockTypes.VAR_INT, (Object)type.getValue());
        loadingScreen.write((Type)Types.BOOLEAN, (Object)(loadingScreenId != null ? 1 : 0));
        if (loadingScreenId != null) {
            loadingScreen.write((Type)BedrockTypes.UNSIGNED_INT_LE, (Object)loadingScreenId);
        }
        loadingScreen.sendToServer(BedrockProtocol.class);
    }

    public static void writeJavaDisconnect(PacketWrapper wrapper, String reason) {
        switch (wrapper.getPacketType().state()) {
            case LOGIN: {
                wrapper.write(Types.COMPONENT, reason != null ? TextUtil.stringToGson(reason) : JsonNull.INSTANCE);
                break;
            }
            case CONFIGURATION: 
            case PLAY: {
                wrapper.write(Types.TAG, (Object)(reason != null ? TextUtil.stringToNbt(reason) : null));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected state: " + String.valueOf(wrapper.getPacketType().state()));
            }
        }
    }

    public static void writeJavaContainerSetContent(PacketWrapper wrapper, Container container) {
        wrapper.write((Type)Types.VAR_INT, (Object)container.javaContainerId());
        wrapper.write((Type)Types.VAR_INT, (Object)0);
        wrapper.write(VersionedTypes.V1_21_9.itemArray, (Object)container.getJavaItems());
        wrapper.write(VersionedTypes.V1_21_9.item, (Object)((InventoryTracker)wrapper.user().get(InventoryTracker.class)).getHudContainer().getJavaItem(0));
    }

    public static void writeJavaLevelParticles(PacketWrapper wrapper, Position3f position, BedrockMappingData.JavaParticle particle) {
        wrapper.write((Type)Types.BOOLEAN, (Object)false);
        wrapper.write((Type)Types.BOOLEAN, (Object)false);
        wrapper.write((Type)Types.DOUBLE, (Object)position.x());
        wrapper.write((Type)Types.DOUBLE, (Object)position.y());
        wrapper.write((Type)Types.DOUBLE, (Object)position.z());
        wrapper.write((Type)Types.FLOAT, (Object)Float.valueOf(particle.offsetX()));
        wrapper.write((Type)Types.FLOAT, (Object)Float.valueOf(particle.offsetY()));
        wrapper.write((Type)Types.FLOAT, (Object)Float.valueOf(particle.offsetZ()));
        wrapper.write((Type)Types.FLOAT, (Object)Float.valueOf(particle.speed()));
        wrapper.write((Type)Types.INT, (Object)particle.count());
        wrapper.write((Type)VersionedTypes.V1_21_9.particle, (Object)particle.particle().copy());
    }
}

