/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.packet;

import com.google.common.collect.Sets;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.protocols.v1_21_5to1_21_6.packet.ServerboundPackets1_21_6;
import com.viaversion.viaversion.protocols.v1_21_7to1_21_9.packet.ClientboundPackets1_21_9;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Level;
import net.lenni0451.mcstructs_bedrock.text.components.RootBedrockComponent;
import net.lenni0451.mcstructs_bedrock.text.components.TranslationBedrockComponent;
import net.lenni0451.mcstructs_bedrock.text.serializer.BedrockComponentSerializer;
import net.lenni0451.mcstructs_bedrock.text.utils.BedrockTranslator;
import net.lenni0451.mcstructs_bedrock.text.utils.TranslatorOptions;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.entity.ClientPlayerEntity;
import net.raphimc.viabedrock.api.util.PacketFactory;
import net.raphimc.viabedrock.api.util.TextUtil;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ClientboundBedrockPackets;
import net.raphimc.viabedrock.protocol.ServerboundBedrockPackets;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.AbilitiesIndex;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ChatRestrictionLevel;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.CommandOriginType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.CommandOutputType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.PlayerPermissionLevel;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.SoftEnumUpdateType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.TextPacketType;
import net.raphimc.viabedrock.protocol.model.CommandData;
import net.raphimc.viabedrock.protocol.model.CommandOriginData;
import net.raphimc.viabedrock.protocol.storage.AuthChainData;
import net.raphimc.viabedrock.protocol.storage.CommandsStorage;
import net.raphimc.viabedrock.protocol.storage.EntityTracker;
import net.raphimc.viabedrock.protocol.storage.GameSessionStorage;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class ChatPackets {
    private static final PacketHandler CHAT_COMMAND_HANDLER = new PacketHandlers(){

        protected void register() {
            this.map(Types.STRING, BedrockTypes.STRING, c -> "/" + c);
            this.handler(wrapper -> {
                UUID uuid = wrapper.user().getProtocolInfo().getUuid();
                wrapper.write(BedrockTypes.COMMAND_ORIGIN_DATA, (Object)new CommandOriginData(CommandOriginType.Player, uuid, ""));
            });
            this.create((Type)Types.BOOLEAN, false);
            this.create(BedrockTypes.VAR_INT, 44);
            this.handler(PacketWrapper::clearInputBuffer);
            this.handler(wrapper -> {
                CommandsStorage commandsStorage = (CommandsStorage)wrapper.user().get(CommandsStorage.class);
                int execResult = 0;
                if (commandsStorage != null) {
                    execResult = commandsStorage.execute((String)wrapper.get(BedrockTypes.STRING, 0));
                }
                if (execResult == 1) {
                    wrapper.cancel();
                } else if (execResult != -1) {
                    GameSessionStorage gameSession = (GameSessionStorage)wrapper.user().get(GameSessionStorage.class);
                    ClientPlayerEntity clientPlayer = ((EntityTracker)wrapper.user().get(EntityTracker.class)).getClientPlayer();
                    if (!gameSession.areCommandsEnabled() || gameSession.getChatRestrictionLevel() == ChatRestrictionLevel.Disabled && clientPlayer.abilities().playerPermission() <= PlayerPermissionLevel.Member.getValue()) {
                        wrapper.cancel();
                        PacketFactory.sendJavaSystemChat(wrapper.user(), TextUtil.stringToNbt("\u00a7e" + ((ResourcePacksStorage)wrapper.user().get(ResourcePacksStorage.class)).getTexts().get("commands.generic.disabled")));
                    }
                }
            });
        }
    };

    public static void register(BedrockProtocol protocol) {
        protocol.registerClientbound(ClientboundBedrockPackets.TEXT, (ClientboundPacketType)ClientboundPackets1_21_9.SYSTEM_CHAT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.handler(wrapper -> {
                    byte rawType = (Byte)wrapper.read((Type)Types.BYTE);
                    TextPacketType type = TextPacketType.getByValue(rawType);
                    if (type == null) {
                        ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unknown TextPacketType: " + rawType);
                        wrapper.cancel();
                        return;
                    }
                    boolean needsTranslation = (Boolean)wrapper.read((Type)Types.BOOLEAN);
                    Function<String, String> translator = ((ResourcePacksStorage)wrapper.user().get(ResourcePacksStorage.class)).getTexts().lookup();
                    String originalMessage = null;
                    try {
                        switch (type) {
                            case Chat: 
                            case Whisper: 
                            case Announcement: {
                                String sourceName = (String)wrapper.read(BedrockTypes.STRING);
                                String message = originalMessage = (String)wrapper.read(BedrockTypes.STRING);
                                if (needsTranslation) {
                                    message = BedrockTranslator.translate((String)message, translator, (Object[])new Object[0], (TranslatorOptions[])new TranslatorOptions[0]);
                                }
                                if (type == TextPacketType.Chat && !sourceName.isEmpty()) {
                                    message = BedrockTranslator.translate((String)"chat.type.text", translator, (Object[])new String[]{sourceName, message}, (TranslatorOptions[])new TranslatorOptions[]{TranslatorOptions.SKIP_ARGS_TRANSLATION});
                                } else if (type == TextPacketType.Whisper) {
                                    message = BedrockTranslator.translate((String)"chat.type.text", translator, (Object[])new String[]{sourceName, BedrockTranslator.translate((String)"\u00a77\u00a7o%commands.message.display.incoming", translator, (Object[])new String[]{sourceName, message}, (TranslatorOptions[])new TranslatorOptions[0])}, (TranslatorOptions[])new TranslatorOptions[]{TranslatorOptions.SKIP_ARGS_TRANSLATION});
                                }
                                wrapper.write(Types.TAG, (Object)TextUtil.stringToNbt(message));
                                wrapper.write((Type)Types.BOOLEAN, (Object)false);
                                break;
                            }
                            case TextObjectWhisper: 
                            case TextObject: 
                            case TextObjectAnnouncement: {
                                String message = originalMessage = (String)wrapper.read(BedrockTypes.STRING);
                                RootBedrockComponent rootComponent = BedrockComponentSerializer.deserialize((String)message);
                                rootComponent.forEach(c -> {
                                    if (c instanceof TranslationBedrockComponent) {
                                        ((TranslationBedrockComponent)c).setTranslator(translator);
                                    }
                                });
                                message = rootComponent.asString();
                                if (needsTranslation) {
                                    message = BedrockTranslator.translate((String)message, translator, (Object[])new Object[0], (TranslatorOptions[])new TranslatorOptions[0]);
                                }
                                wrapper.write(Types.TAG, (Object)TextUtil.stringToNbt(message));
                                wrapper.write((Type)Types.BOOLEAN, (Object)false);
                                break;
                            }
                            case Raw: 
                            case SystemMessage: 
                            case Tip: {
                                String message = originalMessage = (String)wrapper.read(BedrockTypes.STRING);
                                if (needsTranslation) {
                                    message = BedrockTranslator.translate((String)message, translator, (Object[])new Object[0], (TranslatorOptions[])new TranslatorOptions[0]);
                                }
                                wrapper.write(Types.TAG, (Object)TextUtil.stringToNbt(message));
                                wrapper.write((Type)Types.BOOLEAN, (Object)(type == TextPacketType.Tip ? 1 : 0));
                                break;
                            }
                            case Translate: 
                            case Popup: 
                            case JukeboxPopup: {
                                String message = originalMessage = (String)wrapper.read(BedrockTypes.STRING);
                                Object[] parameters = (String[])wrapper.read(BedrockTypes.STRING_ARRAY);
                                if (needsTranslation) {
                                    message = BedrockTranslator.translate((String)message, translator, (Object[])parameters, (TranslatorOptions[])new TranslatorOptions[0]);
                                }
                                wrapper.write(Types.TAG, (Object)TextUtil.stringToNbt(message));
                                wrapper.write((Type)Types.BOOLEAN, (Object)(type == TextPacketType.Popup || type == TextPacketType.JukeboxPopup ? 1 : 0));
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unhandled TextPacketType: " + String.valueOf((Object)type));
                            }
                        }
                    }
                    catch (Throwable e) {
                        ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Error while translating '" + originalMessage + "'", e);
                        wrapper.cancel();
                    }
                });
                this.read(BedrockTypes.STRING);
                this.read(BedrockTypes.STRING);
                this.read(BedrockTypes.STRING);
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.COMMAND_OUTPUT, (ClientboundPacketType)ClientboundPackets1_21_9.SYSTEM_CHAT, wrapper -> {
            CommandOriginData originData = (CommandOriginData)wrapper.read(BedrockTypes.COMMAND_ORIGIN_DATA);
            CommandOutputType type = CommandOutputType.getByValue(((Byte)wrapper.read((Type)Types.BYTE)).byteValue(), CommandOutputType.None);
            wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_INT);
            if (originData.type() != CommandOriginType.Player) {
                wrapper.cancel();
                return;
            }
            Function<String, String> translator = ((ResourcePacksStorage)wrapper.user().get(ResourcePacksStorage.class)).getTexts().lookup();
            StringBuilder message = new StringBuilder();
            int messageCount = (Integer)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_INT);
            for (int i = 0; i < messageCount; ++i) {
                boolean successful = (Boolean)wrapper.read((Type)Types.BOOLEAN);
                String messageId = (String)wrapper.read(BedrockTypes.STRING);
                Object[] parameters = (String[])wrapper.read(BedrockTypes.STRING_ARRAY);
                message.append(successful ? "\u00a7r" : "\u00a7c");
                message.append(BedrockTranslator.translate((String)messageId, translator, (Object[])parameters, (TranslatorOptions[])new TranslatorOptions[0]));
                if (i == messageCount - 1) continue;
                message.append("\n");
            }
            if (type == CommandOutputType.DataSet) {
                wrapper.read(BedrockTypes.STRING);
            }
            wrapper.write(Types.TAG, (Object)TextUtil.stringToNbt(message.toString()));
            wrapper.write((Type)Types.BOOLEAN, (Object)false);
        });
        protocol.registerClientboundTransition(ClientboundBedrockPackets.AVAILABLE_COMMANDS, State.CONFIGURATION, wrapper -> {
            CommandData[] commands = (CommandData[])wrapper.read(BedrockTypes.COMMAND_DATA_ARRAY);
            wrapper.user().put((StorableObject)new CommandsStorage(wrapper.user(), commands));
            wrapper.cancel();
        }, ClientboundPackets1_21_9.COMMANDS, wrapper -> {
            CommandData[] commands = (CommandData[])wrapper.read(BedrockTypes.COMMAND_DATA_ARRAY);
            CommandsStorage commandsStorage = new CommandsStorage(wrapper.user(), commands);
            wrapper.user().put((StorableObject)commandsStorage);
            commandsStorage.writeCommandTree(wrapper);
        });
        protocol.registerClientbound(ClientboundBedrockPackets.UPDATE_SOFT_ENUM, null, wrapper -> {
            wrapper.cancel();
            CommandsStorage commandsStorage = (CommandsStorage)wrapper.user().get(CommandsStorage.class);
            if (commandsStorage == null) {
                return;
            }
            String name = (String)wrapper.read(BedrockTypes.STRING);
            HashSet values = Sets.newHashSet((Object[])((String[])wrapper.read(BedrockTypes.STRING_ARRAY)));
            CommandData.EnumData softEnum = commandsStorage.getSoftEnum(name);
            if (softEnum == null) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received update for unknown soft enum: " + name);
                return;
            }
            byte rawAction = (Byte)wrapper.read((Type)Types.BYTE);
            SoftEnumUpdateType action = SoftEnumUpdateType.getByValue(rawAction);
            if (action == null) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unknown SoftEnumUpdateType: " + rawAction);
                return;
            }
            switch (action) {
                case Add: {
                    softEnum.addValues(values);
                    break;
                }
                case Remove: {
                    softEnum.removeValues(values);
                    break;
                }
                case Replace: {
                    softEnum.values().clear();
                    softEnum.addValues(values);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled SoftEnumUpdateType: " + String.valueOf((Object)action));
                }
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.SET_COMMANDS_ENABLED, null, wrapper -> {
            wrapper.cancel();
            GameSessionStorage gameSession = (GameSessionStorage)wrapper.user().get(GameSessionStorage.class);
            boolean commandsEnabled = (Boolean)wrapper.read((Type)Types.BOOLEAN);
            if (commandsEnabled != gameSession.areCommandsEnabled()) {
                gameSession.setCommandsEnabled(commandsEnabled);
                CommandsStorage commandsStorage = (CommandsStorage)wrapper.user().get(CommandsStorage.class);
                if (commandsStorage != null) {
                    commandsStorage.updateCommandTree();
                }
            }
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_21_6.CHAT, ServerboundBedrockPackets.TEXT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.create((Type)Types.BYTE, (byte)TextPacketType.Chat.getValue());
                this.create((Type)Types.BOOLEAN, false);
                this.handler(wrapper -> wrapper.write(BedrockTypes.STRING, (Object)((EntityTracker)wrapper.user().get(EntityTracker.class)).getClientPlayer().name()));
                this.map(Types.STRING, BedrockTypes.STRING);
                this.handler(wrapper -> wrapper.write(BedrockTypes.STRING, (Object)((AuthChainData)wrapper.user().get(AuthChainData.class)).getXuid()));
                this.create(BedrockTypes.STRING, "");
                this.create(BedrockTypes.STRING, "");
                this.handler(PacketWrapper::clearInputBuffer);
                this.handler(wrapper -> {
                    GameSessionStorage gameSession = (GameSessionStorage)wrapper.user().get(GameSessionStorage.class);
                    ClientPlayerEntity clientPlayer = ((EntityTracker)wrapper.user().get(EntityTracker.class)).getClientPlayer();
                    if (gameSession.getChatRestrictionLevel() != ChatRestrictionLevel.None || clientPlayer.abilities().getBooleanValue(AbilitiesIndex.Muted)) {
                        wrapper.cancel();
                        PacketFactory.sendJavaSystemChat(wrapper.user(), TextUtil.stringToNbt("\u00a7e" + ((ResourcePacksStorage)wrapper.user().get(ResourcePacksStorage.class)).getTexts().get("permissions.chatmute")));
                    }
                });
            }
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_21_6.CHAT_COMMAND, ServerboundBedrockPackets.COMMAND_REQUEST, CHAT_COMMAND_HANDLER);
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_21_6.CHAT_COMMAND_SIGNED, ServerboundBedrockPackets.COMMAND_REQUEST, CHAT_COMMAND_HANDLER);
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_21_6.COMMAND_SUGGESTION, null, wrapper -> {
            wrapper.cancel();
            CommandsStorage commandsStorage = (CommandsStorage)wrapper.user().get(CommandsStorage.class);
            if (commandsStorage == null) {
                return;
            }
            int id = (Integer)wrapper.read((Type)Types.VAR_INT);
            String command = (String)wrapper.read(Types.STRING);
            if (!command.startsWith("/")) {
                return;
            }
            Suggestions suggestions = commandsStorage.complete(command);
            PacketWrapper tabComplete = PacketWrapper.create((PacketType)ClientboundPackets1_21_9.COMMAND_SUGGESTIONS, (UserConnection)wrapper.user());
            tabComplete.write((Type)Types.VAR_INT, (Object)id);
            tabComplete.write((Type)Types.VAR_INT, (Object)suggestions.getRange().getStart());
            tabComplete.write((Type)Types.VAR_INT, (Object)suggestions.getRange().getLength());
            tabComplete.write((Type)Types.VAR_INT, (Object)suggestions.getList().size());
            for (Suggestion suggestion : suggestions.getList()) {
                tabComplete.write(Types.STRING, (Object)suggestion.getText());
                if (suggestion.getTooltip() != null) {
                    tabComplete.write(Types.OPTIONAL_TAG, (Object)TextUtil.stringToNbt(suggestion.getTooltip().getString()));
                    continue;
                }
                tabComplete.write(Types.OPTIONAL_TAG, null);
            }
            tabComplete.send(BedrockProtocol.class);
        });
    }
}

