/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.rewriter;

import com.viaversion.nbt.tag.ByteTag;
import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.ListTag;
import com.viaversion.nbt.tag.StringTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.blockentity.BlockEntity;
import com.viaversion.viaversion.api.minecraft.blockentity.BlockEntityImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.chunk.BedrockBlockEntity;
import net.raphimc.viabedrock.api.model.BedrockBlockState;
import net.raphimc.viabedrock.api.util.TextUtil;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.rewriter.BlockStateRewriter;
import net.raphimc.viabedrock.protocol.rewriter.ItemRewriter;
import net.raphimc.viabedrock.protocol.rewriter.blockentity.BannerBlockEntityRewriter;
import net.raphimc.viabedrock.protocol.rewriter.blockentity.BeaconBlockEntityRewriter;
import net.raphimc.viabedrock.protocol.rewriter.blockentity.BedBlockEntityRewriter;
import net.raphimc.viabedrock.protocol.rewriter.blockentity.BeehiveBlockEntityRewriter;
import net.raphimc.viabedrock.protocol.rewriter.blockentity.BrushableBlockBlockEntityRewriter;
import net.raphimc.viabedrock.protocol.rewriter.blockentity.ChiseledBookshelfBlockEntityRewriter;
import net.raphimc.viabedrock.protocol.rewriter.blockentity.CommandBlockBlockEntityRewriter;
import net.raphimc.viabedrock.protocol.rewriter.blockentity.ComparatorBlockEntityRewriter;
import net.raphimc.viabedrock.protocol.rewriter.blockentity.ConduitBlockEntityRewriter;
import net.raphimc.viabedrock.protocol.rewriter.blockentity.CrafterBlockEntityRewriter;
import net.raphimc.viabedrock.protocol.rewriter.blockentity.CreakingHeartBlockEntityRewriter;
import net.raphimc.viabedrock.protocol.rewriter.blockentity.DecoratedPotBlockEntityRewriter;
import net.raphimc.viabedrock.protocol.rewriter.blockentity.EndGatewayBlockEntityRewriter;
import net.raphimc.viabedrock.protocol.rewriter.blockentity.FlowerPotBlockEntityRewriter;
import net.raphimc.viabedrock.protocol.rewriter.blockentity.FurnaceBlockEntityRewriter;
import net.raphimc.viabedrock.protocol.rewriter.blockentity.HopperBlockEntityRewriter;
import net.raphimc.viabedrock.protocol.rewriter.blockentity.JigsawBlockEntityRewriter;
import net.raphimc.viabedrock.protocol.rewriter.blockentity.JukeboxBlockEntityRewriter;
import net.raphimc.viabedrock.protocol.rewriter.blockentity.LecternBlockEntityRewriter;
import net.raphimc.viabedrock.protocol.rewriter.blockentity.LootableContainerBlockEntityRewriter;
import net.raphimc.viabedrock.protocol.rewriter.blockentity.MobSpawnerBlockEntityRewriter;
import net.raphimc.viabedrock.protocol.rewriter.blockentity.NamedBlockEntityRewriter;
import net.raphimc.viabedrock.protocol.rewriter.blockentity.SignBlockEntityRewriter;
import net.raphimc.viabedrock.protocol.rewriter.blockentity.SkullBlockEntityRewriter;
import net.raphimc.viabedrock.protocol.rewriter.blockentity.StructureBlockBlockEntityRewriter;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;

public class BlockEntityRewriter {
    private static final Map<String, Rewriter> BLOCK_ENTITY_REWRITERS = new HashMap<String, Rewriter>();
    private static final Rewriter NULL_REWRITER = (user, bedrockBlockEntity) -> null;
    private static final Rewriter NOOP_REWRITER = (user, bedrockBlockEntity) -> new BlockEntityImpl(bedrockBlockEntity.packedXZ(), bedrockBlockEntity.y(), -1, new CompoundTag());

    public static BlockEntity toJava(UserConnection user, int bedrockBlockStateId, BedrockBlockEntity bedrockBlockEntity) {
        BlockStateRewriter blockStateRewriter = (BlockStateRewriter)user.get(BlockStateRewriter.class);
        if (bedrockBlockStateId == blockStateRewriter.bedrockId(BedrockBlockState.AIR)) {
            return null;
        }
        String tag = blockStateRewriter.tag(bedrockBlockStateId);
        if (BLOCK_ENTITY_REWRITERS.containsKey(tag)) {
            BlockEntity javaBlockEntity = BLOCK_ENTITY_REWRITERS.get(tag).toJava(user, bedrockBlockEntity);
            if (javaBlockEntity == null) {
                return null;
            }
            if (javaBlockEntity.tag() != null) {
                int typeId = (Integer)BedrockProtocol.MAPPINGS.getJavaBlockEntities().getOrDefault((Object)tag, (Object)-1);
                if (typeId == -1) {
                    throw new IllegalStateException("Unknown java block entity type: " + tag);
                }
                return javaBlockEntity.withTypeId(typeId);
            }
            return javaBlockEntity;
        }
        ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing block entity translation for " + bedrockBlockStateId + " (" + String.valueOf(bedrockBlockEntity.tag()) + ")");
        return null;
    }

    public static boolean isJavaBlockEntity(String tag) {
        return !NULL_REWRITER.equals(BLOCK_ENTITY_REWRITERS.get(tag));
    }

    static {
        BLOCK_ENTITY_REWRITERS.put("brewing_stand", NOOP_REWRITER);
        BLOCK_ENTITY_REWRITERS.put("calibrated_sculk_sensor", NOOP_REWRITER);
        BLOCK_ENTITY_REWRITERS.put("campfire", NOOP_REWRITER);
        BLOCK_ENTITY_REWRITERS.put("copper_golem_statue", NOOP_REWRITER);
        BLOCK_ENTITY_REWRITERS.put("note_block", NULL_REWRITER);
        BLOCK_ENTITY_REWRITERS.put("piston", NOOP_REWRITER);
        BLOCK_ENTITY_REWRITERS.put("moving_block", NULL_REWRITER);
        BLOCK_ENTITY_REWRITERS.put("sculk_sensor", NOOP_REWRITER);
        BLOCK_ENTITY_REWRITERS.put("sculk_shrieker", NOOP_REWRITER);
        BLOCK_ENTITY_REWRITERS.put("shelf", NOOP_REWRITER);
        BLOCK_ENTITY_REWRITERS.put("trial_spawner", NOOP_REWRITER);
        BLOCK_ENTITY_REWRITERS.put("vault", NOOP_REWRITER);
        BLOCK_ENTITY_REWRITERS.put("banner", new BannerBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("barrel", new LootableContainerBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("beacon", new BeaconBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("bed", new BedBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("beehive", new BeehiveBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("bell", NOOP_REWRITER);
        BLOCK_ENTITY_REWRITERS.put("blast_furnace", new FurnaceBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("brushable_block", new BrushableBlockBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("cauldron", NULL_REWRITER);
        BLOCK_ENTITY_REWRITERS.put("chest", new LootableContainerBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("chiseled_bookshelf", new ChiseledBookshelfBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("command_block", new CommandBlockBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("comparator", new ComparatorBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("conduit", new ConduitBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("crafter", new CrafterBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("creaking_heart", new CreakingHeartBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("daylight_detector", NOOP_REWRITER);
        BLOCK_ENTITY_REWRITERS.put("decorated_pot", new DecoratedPotBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("dispenser", new LootableContainerBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("dropper", new LootableContainerBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("enchanting_table", new NamedBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("end_gateway", new EndGatewayBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("end_portal", NOOP_REWRITER);
        BLOCK_ENTITY_REWRITERS.put("ender_chest", NOOP_REWRITER);
        BLOCK_ENTITY_REWRITERS.put("flower_pot", new FlowerPotBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("furnace", new FurnaceBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("hanging_sign", new SignBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("hopper", new HopperBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("item_frame", NULL_REWRITER);
        BLOCK_ENTITY_REWRITERS.put("jigsaw", new JigsawBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("jukebox", new JukeboxBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("lectern", new LecternBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("lodestone", NULL_REWRITER);
        BLOCK_ENTITY_REWRITERS.put("mob_spawner", new MobSpawnerBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("nether_reactor", NULL_REWRITER);
        BLOCK_ENTITY_REWRITERS.put("sculk_catalyst", NOOP_REWRITER);
        BLOCK_ENTITY_REWRITERS.put("shulker_box", new LootableContainerBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("sign", new SignBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("skull", new SkullBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("smoker", new FurnaceBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("spore_blossom", NULL_REWRITER);
        BLOCK_ENTITY_REWRITERS.put("structure_block", new StructureBlockBlockEntityRewriter());
        BLOCK_ENTITY_REWRITERS.put("trapped_chest", new LootableContainerBlockEntityRewriter());
    }

    public static interface Rewriter {
        public BlockEntity toJava(UserConnection var1, BedrockBlockEntity var2);

        default public void copy(CompoundTag fromTag, CompoundTag toTag, String key, Class<?> expectedType) {
            this.copy(fromTag, toTag, key, key, expectedType);
        }

        default public void copy(CompoundTag fromTag, CompoundTag toTag, String fromKey, String toKey, Class<?> expectedType) {
            if (expectedType.isInstance(fromTag.get(fromKey))) {
                toTag.put(toKey, fromTag.get(fromKey).copy());
            }
        }

        default public void copyCustomName(UserConnection user, CompoundTag fromTag, CompoundTag toTag) {
            Tag tag = fromTag.get("CustomName");
            if (tag instanceof StringTag) {
                StringTag customNameTag = (StringTag)tag;
                toTag.put("CustomName", (Tag)this.rewriteCustomName(user, customNameTag));
            }
        }

        default public void copyItemList(UserConnection user, CompoundTag fromTag, CompoundTag toTag) {
            ListTag itemsTag;
            Tag tag = fromTag.get("Items");
            if (tag instanceof ListTag && CompoundTag.class.equals((Object)(itemsTag = (ListTag)tag).getElementType())) {
                toTag.put("Items", this.rewriteItemList(user, (ListTag<CompoundTag>)itemsTag));
            }
        }

        default public void copyItem(UserConnection user, CompoundTag fromTag, CompoundTag toTag, String key) {
            this.copyItem(user, fromTag, toTag, key, key);
        }

        default public void copyItem(UserConnection user, CompoundTag fromTag, CompoundTag toTag, String fromKey, String toKey) {
            Tag tag = fromTag.get(fromKey);
            if (tag instanceof CompoundTag) {
                CompoundTag itemTag = (CompoundTag)tag;
                toTag.put(toKey, (Tag)this.rewriteItem(user, itemTag));
            }
        }

        default public CompoundTag rewriteItem(UserConnection user, CompoundTag bedrockItemTag) {
            return ((ItemRewriter)user.get(ItemRewriter.class)).javaItem(bedrockItemTag);
        }

        default public ListTag<?> rewriteItemList(UserConnection user, ListTag<CompoundTag> bedrockItemList) {
            ListTag javaItemList = new ListTag(CompoundTag.class);
            ItemRewriter itemRewriter = (ItemRewriter)user.get(ItemRewriter.class);
            for (CompoundTag bedrockItemTag : bedrockItemList) {
                CompoundTag javaItemTag = itemRewriter.javaItem(bedrockItemTag);
                this.copy(bedrockItemTag, javaItemTag, "Slot", ByteTag.class);
                javaItemList.add((Tag)javaItemTag);
            }
            return javaItemList;
        }

        default public StringTag rewriteCustomName(UserConnection user, StringTag textTag) {
            return new StringTag(TextUtil.stringToJson(((ResourcePacksStorage)user.get(ResourcePacksStorage.class)).getTexts().translate(textTag.getValue())));
        }
    }
}

