/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.rewriter;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.StoredObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.data.StructuredDataContainer;
import com.viaversion.viaversion.api.minecraft.data.StructuredDataKey;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.minecraft.item.StructuredItem;
import com.viaversion.viaversion.api.minecraft.item.data.ItemModel;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectOpenHashMap;
import com.viaversion.viaversion.libs.fastutil.ints.IntSortedSet;
import com.viaversion.viaversion.util.Key;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.BlockState;
import net.raphimc.viabedrock.api.model.resourcepack.ItemDefinitions;
import net.raphimc.viabedrock.api.util.TextUtil;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.data.BedrockMappingData;
import net.raphimc.viabedrock.protocol.data.ProtocolConstants;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.ItemDataVersion;
import net.raphimc.viabedrock.protocol.model.BedrockItem;
import net.raphimc.viabedrock.protocol.model.ItemEntry;
import net.raphimc.viabedrock.protocol.rewriter.BlockStateRewriter;
import net.raphimc.viabedrock.protocol.rewriter.item.BundleItemRewriter;
import net.raphimc.viabedrock.protocol.rewriter.resourcepack.CustomAttachableResourceRewriter;
import net.raphimc.viabedrock.protocol.rewriter.resourcepack.CustomItemTextureResourceRewriter;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;
import net.raphimc.viabedrock.protocol.types.array.ArrayType;
import net.raphimc.viabedrock.protocol.types.item.BedrockItemType;

public class ItemRewriter
extends StoredObject {
    private static final Map<String, NbtRewriter> ITEM_NBT_REWRITERS = new HashMap<String, NbtRewriter>();
    private final BiMap<String, Integer> items;
    private final Set<String> componentItems;
    private final Int2ObjectMap<IntSortedSet> blockItemValidBlockStates;
    private final Type<BedrockItem> itemType;
    private final Type<BedrockItem[]> itemArrayType;

    public ItemRewriter(UserConnection user, ItemEntry[] itemEntries) {
        super(user);
        this.items = HashBiMap.create((int)itemEntries.length);
        this.componentItems = new HashSet<String>();
        for (ItemEntry itemEntry : itemEntries) {
            this.items.inverse().remove((Object)itemEntry.id());
            this.items.put((Object)itemEntry.identifier(), (Object)itemEntry.id());
            if (itemEntry.version() != ItemDataVersion.DATA_DRIVEN && (itemEntry.version() != ItemDataVersion.NONE || !itemEntry.componentBased())) continue;
            this.componentItems.add(itemEntry.identifier());
        }
        HashSet<String> blockItems = new HashSet<String>(BedrockProtocol.MAPPINGS.getBedrockBlockItems());
        blockItems.removeIf(identifier -> !this.items.containsKey(identifier));
        this.blockItemValidBlockStates = new Int2ObjectOpenHashMap(blockItems.size());
        BlockStateRewriter blockStateRewriter = (BlockStateRewriter)this.user().get(BlockStateRewriter.class);
        for (String identifier2 : blockItems) {
            String[] components;
            IntSortedSet validBlockStates = blockStateRewriter.validBlockStates(identifier2);
            if (validBlockStates == null && (components = identifier2.split(":", 2))[1].startsWith("item.")) {
                validBlockStates = blockStateRewriter.validBlockStates(components[0] + ":" + components[1].substring(5));
            }
            if (validBlockStates != null) {
                this.blockItemValidBlockStates.put(((Integer)this.items.get((Object)identifier2)).intValue(), (Object)validBlockStates);
                continue;
            }
            Via.getPlatform().getLogger().log(Level.WARNING, "Missing block for block item: " + identifier2);
        }
        this.itemType = new BedrockItemType((Integer)this.items.getOrDefault((Object)"minecraft:shield", (Object)0), this.blockItemValidBlockStates, false);
        this.itemArrayType = new ArrayType<BedrockItem>(this.itemType, BedrockTypes.UNSIGNED_VAR_INT);
    }

    public Item javaItem(BedrockItem bedrockItem) {
        String tag;
        CompoundTag display;
        Tag tag2;
        StructuredItem javaItem;
        BedrockMappingData.JavaItemMapping javaItemMapping;
        if (bedrockItem.isEmpty()) {
            return StructuredItem.empty();
        }
        String identifier = (String)this.items.inverse().get((Object)bedrockItem.identifier());
        if (identifier == null) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing item identifier for id: " + bedrockItem.identifier());
            return StructuredItem.empty();
        }
        Map<BlockState, BedrockMappingData.JavaItemMapping> blockItemMappings = BedrockProtocol.MAPPINGS.getBedrockToJavaBlockItems().get(identifier);
        if (blockItemMappings != null) {
            if (bedrockItem.blockRuntimeId() == 0) {
                IntSortedSet validBlockStates = (IntSortedSet)this.blockItemValidBlockStates.get(bedrockItem.identifier());
                bedrockItem.setBlockRuntimeId(validBlockStates.firstInt());
            }
            javaItemMapping = blockItemMappings.get(((BlockStateRewriter)this.user().get(BlockStateRewriter.class)).blockState(bedrockItem.blockRuntimeId()));
        } else {
            int meta = bedrockItem.data() & 0xFFFF;
            String newIdentifier = BedrockProtocol.MAPPINGS.getBedrockItemUpgrader().upgradeMetaItem(identifier, meta);
            if (newIdentifier != null) {
                Map<BlockState, BedrockMappingData.JavaItemMapping> newBlockItemMappings = BedrockProtocol.MAPPINGS.getBedrockToJavaBlockItems().get(newIdentifier);
                if (newBlockItemMappings != null) {
                    IntSortedSet validBlockStates = (IntSortedSet)this.blockItemValidBlockStates.get(bedrockItem.identifier());
                    javaItemMapping = newBlockItemMappings.get(((BlockStateRewriter)this.user().get(BlockStateRewriter.class)).blockState(validBlockStates.firstInt()));
                } else {
                    javaItemMapping = null;
                }
            } else {
                Map<Integer, BedrockMappingData.JavaItemMapping> metaItemMappings = BedrockProtocol.MAPPINGS.getBedrockToJavaMetaItems().get(identifier);
                if (metaItemMappings != null) {
                    if (!metaItemMappings.containsKey(meta)) {
                        if (metaItemMappings.size() != 1 || meta != 0) {
                            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing meta: " + meta + " for item: " + identifier);
                        }
                        javaItemMapping = metaItemMappings.get(null);
                    } else {
                        javaItemMapping = metaItemMappings.get(meta);
                    }
                } else {
                    javaItemMapping = null;
                }
            }
        }
        if (javaItemMapping != null) {
            StructuredDataContainer data = ProtocolConstants.createStructuredDataContainer();
            if (javaItemMapping.overrideTag() != null) {
                // empty if block
            }
            if (javaItemMapping.name() != null) {
                ResourcePacksStorage resourcePacksStorage = (ResourcePacksStorage)this.user().get(ResourcePacksStorage.class);
                data.set(StructuredDataKey.ITEM_NAME, (Object)TextUtil.stringToNbt(resourcePacksStorage.getTexts().get(javaItemMapping.name())));
                data.set(StructuredDataKey.LORE, (Object)new Tag[]{TextUtil.stringToNbt("\u00a77[ViaBedrock] Mapped item: " + identifier)});
            }
            javaItem = new StructuredItem(javaItemMapping.id(), bedrockItem.amount(), data);
        } else {
            ResourcePacksStorage resourcePacksStorage = (ResourcePacksStorage)this.user().get(ResourcePacksStorage.class);
            ItemDefinitions.ItemDefinition itemDefinition = resourcePacksStorage.getItems().get(identifier);
            StructuredDataContainer data = ProtocolConstants.createStructuredDataContainer();
            if (itemDefinition != null) {
                if (itemDefinition.displayNameComponent() != null) {
                    data.set(StructuredDataKey.ITEM_NAME, (Object)TextUtil.stringToNbt(resourcePacksStorage.getTexts().translate(itemDefinition.displayNameComponent())));
                } else if (this.componentItems.contains(identifier)) {
                    data.set(StructuredDataKey.ITEM_NAME, (Object)TextUtil.stringToNbt(resourcePacksStorage.getTexts().get("item." + Key.stripMinecraftNamespace((String)identifier))));
                } else {
                    data.set(StructuredDataKey.ITEM_NAME, (Object)TextUtil.stringToNbt(resourcePacksStorage.getTexts().get("item." + Key.stripMinecraftNamespace((String)identifier) + ".name")));
                }
                if (resourcePacksStorage.getAttachables().attachables().containsKey(identifier) && resourcePacksStorage.isLoadedOnJavaClient() && resourcePacksStorage.getConverterData().containsKey("ca_" + identifier + "_default")) {
                    data.set(StructuredDataKey.ITEM_MODEL, (Object)new ItemModel(Key.of((String)"viabedrock:attachable")));
                    data.set(StructuredDataKey.CUSTOM_MODEL_DATA1_21_4, (Object)CustomAttachableResourceRewriter.getCustomModelData(identifier + "_default"));
                } else if (itemDefinition.iconComponent() != null && resourcePacksStorage.isLoadedOnJavaClient()) {
                    data.set(StructuredDataKey.ITEM_MODEL, (Object)new ItemModel(Key.of((String)"viabedrock:item_texture")));
                    data.set(StructuredDataKey.CUSTOM_MODEL_DATA1_21_4, (Object)CustomItemTextureResourceRewriter.getCustomModelData(itemDefinition.iconComponent() + "_0"));
                } else {
                    data.set(StructuredDataKey.LORE, (Object)new Tag[]{TextUtil.stringToNbt("\u00a77[ViaBedrock] Custom item: " + identifier)});
                }
            } else {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing bedrock -> java item mapping for " + identifier);
                data.set(StructuredDataKey.ITEM_NAME, (Object)TextUtil.stringToNbt("\u00a7cMissing item: " + identifier));
            }
            javaItem = new StructuredItem(((Integer)BedrockProtocol.MAPPINGS.getJavaItems().get((Object)"minecraft:paper")).intValue(), bedrockItem.amount(), data);
        }
        CompoundTag bedrockTag = bedrockItem.tag();
        if (bedrockTag != null && (tag2 = bedrockTag.get("display")) instanceof CompoundTag && (display = (CompoundTag)tag2).contains("Name")) {
            javaItem.dataContainer().set(StructuredDataKey.CUSTOM_NAME, (Object)TextUtil.stringToNbt(display.getString("Name", "")));
        }
        if (ITEM_NBT_REWRITERS.containsKey(tag = BedrockProtocol.MAPPINGS.getBedrockItemTags().get(identifier))) {
            ITEM_NBT_REWRITERS.get(tag).toJava(this.user(), bedrockItem, (Item)javaItem);
        }
        return javaItem;
    }

    public CompoundTag javaItem(CompoundTag bedrockTag) {
        CompoundTag javaTag = new CompoundTag();
        javaTag.putString("id", "minecraft:stone");
        return javaTag;
    }

    public Item[] javaItems(BedrockItem[] bedrockItems) {
        Item[] javaItems = new Item[bedrockItems.length];
        for (int i = 0; i < bedrockItems.length; ++i) {
            javaItems[i] = this.javaItem(bedrockItems[i]);
        }
        return javaItems;
    }

    public BedrockItem bedrockItem(Item javaItem) {
        throw new UnsupportedOperationException("Translating Java items to Bedrock is not yet supported");
    }

    public BedrockItem[] bedrockItems(Item[] javaItems) {
        BedrockItem[] bedrockItems = new BedrockItem[javaItems.length];
        for (int i = 0; i < javaItems.length; ++i) {
            bedrockItems[i] = this.bedrockItem(javaItems[i]);
        }
        return bedrockItems;
    }

    public BiMap<String, Integer> getItems() {
        return this.items;
    }

    public Set<String> getComponentItems() {
        return this.componentItems;
    }

    public Type<BedrockItem> itemType() {
        return this.itemType;
    }

    public Type<BedrockItem[]> itemArrayType() {
        return this.itemArrayType;
    }

    static {
        ITEM_NBT_REWRITERS.put("bundle", new BundleItemRewriter());
    }

    public static interface NbtRewriter {
        public void toJava(UserConnection var1, BedrockItem var2, Item var3);
    }
}

