/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.rewriter;

import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.resourcepack.ResourcePack;
import net.raphimc.viabedrock.protocol.rewriter.resourcepack.CustomAttachableResourceRewriter;
import net.raphimc.viabedrock.protocol.rewriter.resourcepack.CustomEntityResourceRewriter;
import net.raphimc.viabedrock.protocol.rewriter.resourcepack.CustomItemTextureResourceRewriter;
import net.raphimc.viabedrock.protocol.rewriter.resourcepack.GlyphSheetResourceRewriter;
import net.raphimc.viabedrock.protocol.storage.ChannelStorage;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;

public class ResourcePackRewriter {
    private static final List<Rewriter> REWRITERS = new ArrayList<Rewriter>();

    public static ResourcePack.Content bedrockToJava(ResourcePacksStorage resourcePacksStorage) {
        ResourcePack.Content javaContent = new ResourcePack.Content();
        for (Rewriter rewriter : REWRITERS) {
            rewriter.apply(resourcePacksStorage, javaContent);
        }
        javaContent.putJson("pack.mcmeta", ResourcePackRewriter.createPackManifest());
        ChannelStorage channelStorage = (ChannelStorage)resourcePacksStorage.user().get(ChannelStorage.class);
        if (channelStorage.hasChannel("viabedrockutility:confirm")) {
            for (ResourcePack pack : resourcePacksStorage.getPacks()) {
                try {
                    javaContent.put("bedrock/" + String.valueOf(pack.packId()) + ".mcpack", pack.content().toZip());
                }
                catch (IOException e) {
                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Failed to put bedrock pack " + String.valueOf(pack.packId()) + " into java resource pack", e);
                }
            }
        }
        return javaContent;
    }

    private static JsonObject createPackManifest() {
        JsonObject root = new JsonObject();
        JsonObject pack = new JsonObject();
        root.add("pack", (JsonElement)pack);
        pack.addProperty("pack_format", (Number)69);
        pack.addProperty("description", "ViaBedrock Resource Pack");
        return root;
    }

    static {
        REWRITERS.add(new GlyphSheetResourceRewriter());
        REWRITERS.add(new CustomItemTextureResourceRewriter());
        REWRITERS.add(new CustomAttachableResourceRewriter());
        REWRITERS.add(new CustomEntityResourceRewriter());
    }

    public static interface Rewriter {
        public void apply(ResourcePacksStorage var1, ResourcePack.Content var2);
    }
}

