/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.rewriter.resourcepack;

import com.viaversion.viaversion.libs.gson.JsonArray;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.util.GsonUtil;
import java.util.Map;
import java.util.Set;
import net.raphimc.viabedrock.api.model.resourcepack.AttachableDefinitions;
import net.raphimc.viabedrock.api.model.resourcepack.ResourcePack;
import net.raphimc.viabedrock.protocol.rewriter.resourcepack.ItemModelResourceRewriter;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;
import org.cube.converter.model.impl.bedrock.BedrockGeometryModel;
import org.cube.converter.model.impl.java.JavaItemModel;

public class CustomAttachableResourceRewriter
extends ItemModelResourceRewriter {
    public CustomAttachableResourceRewriter() {
        super("attachable", "attachable");
    }

    @Override
    protected void apply(ResourcePacksStorage resourcePacksStorage, ResourcePack.Content javaContent, Set<String> modelsList) {
        for (Map.Entry<String, AttachableDefinitions.AttachableDefinition> attachableEntry : resourcePacksStorage.getAttachables().attachables().entrySet()) {
            block1: for (String bedrockPath : attachableEntry.getValue().attachableData().getTextures().values()) {
                for (ResourcePack pack : resourcePacksStorage.getPackStackTopToBottom()) {
                    ResourcePack.Content bedrockContent = pack.content();
                    ResourcePack.Content.LazyImage texture = bedrockContent.getShortnameImage(bedrockPath);
                    if (texture == null) continue;
                    javaContent.putPngImage("assets/viabedrock/textures/" + this.getJavaTexturePath(bedrockPath) + ".png", texture);
                    continue block1;
                }
            }
            AttachableDefinitions.AttachableDefinition attachableDefinition = attachableEntry.getValue();
            for (Map.Entry modelEntry : attachableDefinition.attachableData().getGeometries().entrySet()) {
                BedrockGeometryModel bedrockGeometry = resourcePacksStorage.getModels().entityModels().get(modelEntry.getValue());
                if (bedrockGeometry == null || !attachableDefinition.attachableData().getTextures().containsKey(modelEntry.getKey())) continue;
                String javaTexturePath = this.getJavaTexturePath((String)attachableDefinition.attachableData().getTextures().get(modelEntry.getKey()));
                JavaItemModel itemModelData = bedrockGeometry.toJavaItemModel("viabedrock:" + javaTexturePath, false);
                JsonObject itemModel = (JsonObject)GsonUtil.getGson().fromJson(itemModelData.compile().toString(), JsonObject.class);
                JsonObject display = new JsonObject();
                JsonArray scaling = new JsonArray();
                scaling.add((Number)Float.valueOf(itemModelData.getScale()));
                scaling.add((Number)Float.valueOf(itemModelData.getScale()));
                scaling.add((Number)Float.valueOf(itemModelData.getScale()));
                JsonObject value = new JsonObject();
                value.add("scale", (JsonElement)scaling);
                display.add("firstperson_righthand", (JsonElement)value);
                display.add("firstperson_lefthand", (JsonElement)value);
                display.add("thirdperson_righthand", (JsonElement)value);
                display.add("thirdperson_lefthand", (JsonElement)value);
                display.add("head", (JsonElement)value);
                display.add("gui", (JsonElement)value);
                display.add("ground", (JsonElement)value);
                display.add("fixed", (JsonElement)value);
                itemModel.add("display", (JsonElement)display);
                String key = attachableEntry.getKey() + "_" + (String)modelEntry.getKey();
                resourcePacksStorage.getConverterData().put("ca_" + key, true);
                javaContent.putJson("assets/viabedrock/models/" + this.getJavaModelName(key) + ".json", itemModel);
                modelsList.add(key);
            }
        }
    }
}

