/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.rewriter.resourcepack;

import com.viaversion.viaversion.api.minecraft.item.data.CustomModelData1_21_4;
import com.viaversion.viaversion.libs.gson.JsonArray;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import java.util.HashSet;
import java.util.Set;
import net.raphimc.viabedrock.api.model.resourcepack.ResourcePack;
import net.raphimc.viabedrock.api.util.StringUtil;
import net.raphimc.viabedrock.protocol.rewriter.ResourcePackRewriter;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;

public abstract class ItemModelResourceRewriter
implements ResourcePackRewriter.Rewriter {
    private final String name;
    private final String subFolder;

    public static CustomModelData1_21_4 getCustomModelData(String key) {
        return new CustomModelData1_21_4(new float[0], new boolean[0], new String[]{key}, new int[0]);
    }

    public ItemModelResourceRewriter(String name, String subFolder) {
        this.name = name;
        this.subFolder = subFolder;
    }

    @Override
    public final void apply(ResourcePacksStorage resourcePacksStorage, ResourcePack.Content javaContent) {
        HashSet<String> modelsList = new HashSet<String>();
        this.apply(resourcePacksStorage, javaContent, modelsList);
        if (!modelsList.isEmpty()) {
            JsonArray cases = new JsonArray();
            for (String modelKey : modelsList) {
                JsonObject caseObj = new JsonObject();
                caseObj.addProperty("when", modelKey);
                JsonObject model = new JsonObject();
                model.addProperty("type", "minecraft:model");
                model.addProperty("model", "viabedrock:" + this.getJavaModelName(modelKey));
                caseObj.add("model", (JsonElement)model);
                cases.add((JsonElement)caseObj);
            }
            JsonObject itemDefinition = new JsonObject();
            JsonObject model = new JsonObject();
            model.addProperty("type", "minecraft:select");
            model.addProperty("property", "minecraft:custom_model_data");
            model.add("cases", (JsonElement)cases);
            itemDefinition.add("model", (JsonElement)model);
            javaContent.putJson("assets/viabedrock/items/" + this.name + ".json", itemDefinition);
        }
    }

    protected abstract void apply(ResourcePacksStorage var1, ResourcePack.Content var2, Set<String> var3);

    protected String getJavaModelName(String bedrockName) {
        return this.subFolder + "/" + StringUtil.makeIdentifierValueSafe(bedrockName);
    }

    protected String getJavaTexturePath(String bedrockPath) {
        return "item/" + this.subFolder + "/" + StringUtil.makeIdentifierValueSafe(bedrockPath.replace("textures/", ""));
    }
}

