/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.types.chunk;

import com.viaversion.viaversion.api.minecraft.chunks.DataPalette;
import com.viaversion.viaversion.api.minecraft.chunks.PaletteType;
import com.viaversion.viaversion.api.type.Type;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.raphimc.viabedrock.api.chunk.datapalette.BedrockDataPalette;
import net.raphimc.viabedrock.api.chunk.section.BedrockChunkSection;
import net.raphimc.viabedrock.api.chunk.section.BedrockChunkSectionImpl;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class ChunkSectionV8Type
extends Type<BedrockChunkSection> {
    public ChunkSectionV8Type() {
        super(BedrockChunkSection.class);
    }

    public BedrockChunkSection read(ByteBuf buffer) {
        BedrockChunkSectionImpl chunkSection = new BedrockChunkSectionImpl();
        int layers = buffer.readUnsignedByte();
        for (int i = 0; i < layers; ++i) {
            chunkSection.addPalette(PaletteType.BLOCKS, (DataPalette)BedrockTypes.DATA_PALETTE.read(buffer));
        }
        return chunkSection;
    }

    public void write(ByteBuf buffer, BedrockChunkSection value) {
        List<DataPalette> palettes = value.palettes(PaletteType.BLOCKS);
        buffer.writeByte(palettes.size());
        for (DataPalette palette : palettes) {
            BedrockTypes.DATA_PALETTE.write(buffer, (Object)((BedrockDataPalette)palette));
        }
    }
}

