/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.types.model;

import com.viaversion.viaversion.api.type.Type;
import io.netty.buffer.ByteBuf;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import net.raphimc.viabedrock.api.model.resourcepack.ResourcePack;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.PackType;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class ResourcePackType
extends Type<ResourcePack> {
    public ResourcePackType() {
        super(ResourcePack.class);
    }

    public ResourcePack read(ByteBuf buffer) {
        UUID uuid = (UUID)BedrockTypes.UUID.read(buffer);
        String version = (String)BedrockTypes.STRING.read(buffer);
        long size = buffer.readLongLE();
        byte[] contentKey = (byte[])BedrockTypes.BYTE_ARRAY.read(buffer);
        String subPackName = (String)BedrockTypes.STRING.read(buffer);
        String contentId = (String)BedrockTypes.STRING.read(buffer);
        boolean hasScripts = buffer.readBoolean();
        boolean isAddonPack = buffer.readBoolean();
        boolean raytracingCapable = buffer.readBoolean();
        URL cdnUrl = null;
        try {
            String cdnUrlString = (String)BedrockTypes.STRING.read(buffer);
            if (!cdnUrlString.isEmpty()) {
                cdnUrl = new URL(cdnUrlString);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return new ResourcePack(uuid, version, contentKey, subPackName, contentId, hasScripts, isAddonPack, raytracingCapable, cdnUrl, size, PackType.Resources);
    }

    public void write(ByteBuf buffer, ResourcePack value) {
        BedrockTypes.UUID.write(buffer, (Object)value.packId());
        BedrockTypes.STRING.write(buffer, (Object)value.version());
        buffer.writeLongLE((long)value.compressedDataLength());
        BedrockTypes.BYTE_ARRAY.write(buffer, (Object)value.contentKey());
        BedrockTypes.STRING.write(buffer, (Object)value.subPackName());
        BedrockTypes.STRING.write(buffer, (Object)value.contentId());
        buffer.writeBoolean(value.hasScripts());
        buffer.writeBoolean(value.isAddonPack());
        buffer.writeBoolean(value.raytracingCapable());
        if (value.cdnUrl() != null) {
            BedrockTypes.STRING.write(buffer, (Object)value.cdnUrl().toString());
        } else {
            BedrockTypes.STRING.write(buffer, (Object)"");
        }
    }
}

