/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.chunk.bitarray;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import net.raphimc.viabedrock.api.chunk.bitarray.BitArray;
import net.raphimc.viabedrock.api.chunk.bitarray.BitArrayVersion;
import net.raphimc.viabedrock.api.util.MathUtil;

public class PaddedBitArray
implements BitArray {
    private final int[] words;
    private final BitArrayVersion version;
    private final int size;

    PaddedBitArray(BitArrayVersion version, int size, int[] words) {
        this.size = size;
        this.version = version;
        this.words = words;
        int expectedWordsLength = MathUtil.ceil((float)size / (float)version.getEntriesPerWord());
        if (words.length != expectedWordsLength) {
            throw new IllegalArgumentException("Invalid length given for storage, got: " + words.length + " but expected: " + expectedWordsLength);
        }
    }

    @Override
    public void set(int index, int value) {
        Preconditions.checkElementIndex((int)index, (int)this.size);
        Preconditions.checkArgument((value >= 0 && value <= this.version.getMaxEntryValue() ? 1 : 0) != 0, (Object)"Invalid value");
        int arrayIndex = index / this.version.getEntriesPerWord();
        int offset = index % this.version.getEntriesPerWord() * this.version.getBits();
        this.words[arrayIndex] = this.words[arrayIndex] & ~(this.version.getMaxEntryValue() << offset) | (value & this.version.getMaxEntryValue()) << offset;
    }

    @Override
    public int get(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.size);
        int arrayIndex = index / this.version.getEntriesPerWord();
        int offset = index % this.version.getEntriesPerWord() * this.version.getBits();
        return this.words[arrayIndex] >>> offset & this.version.getMaxEntryValue();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int[] getWords() {
        return this.words;
    }

    @Override
    public BitArrayVersion getVersion() {
        return this.version;
    }

    @Override
    public PaddedBitArray clone() {
        return new PaddedBitArray(this.version, this.size, Arrays.copyOf(this.words, this.words.length));
    }
}

