/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.http;

import com.viaversion.viaversion.api.connection.UserConnection;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedStream;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.resourcepack.ResourcePack;
import net.raphimc.viabedrock.protocol.rewriter.ResourcePackRewriter;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;

public class ResourcePackHttpServer {
    private final InetSocketAddress bindAddress;
    private final ChannelFuture channelFuture;
    private final Map<UUID, UserConnection> connections = new HashMap<UUID, UserConnection>();

    public ResourcePackHttpServer(InetSocketAddress bindAddress) {
        this.bindAddress = bindAddress;
        this.channelFuture = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)new NioEventLoopGroup(0)).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                channel.pipeline().addLast("http_codec", (ChannelHandler)new HttpServerCodec());
                channel.pipeline().addLast("chunked_writer", (ChannelHandler)new ChunkedWriteHandler());
                channel.pipeline().addLast("http_handler", (ChannelHandler)new SimpleChannelInboundHandler<Object>(){

                    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws InterruptedException {
                        if (msg instanceof HttpRequest) {
                            HttpRequest request = (HttpRequest)msg;
                            if (!request.method().equals((Object)HttpMethod.GET)) {
                                ctx.close();
                                return;
                            }
                            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(request.uri());
                            if (!queryStringDecoder.parameters().containsKey("token")) {
                                ctx.close();
                                return;
                            }
                            UUID uuid = UUID.fromString((String)((List)queryStringDecoder.parameters().get("token")).get(0));
                            UserConnection user = ResourcePackHttpServer.this.connections.get(uuid);
                            if (user == null) {
                                ctx.close();
                                return;
                            }
                            ResourcePacksStorage resourcePacksStorage = (ResourcePacksStorage)user.get(ResourcePacksStorage.class);
                            while (!resourcePacksStorage.hasFinishedLoading()) {
                                Thread.sleep(100L);
                            }
                            try {
                                long start = System.nanoTime();
                                ResourcePack.Content javaContent = ResourcePackRewriter.bedrockToJava(resourcePacksStorage);
                                byte[] data = javaContent.toZip();
                                long end = System.nanoTime();
                                ViaBedrock.getPlatform().getLogger().log(Level.INFO, "Converted packs in " + (end - start) / 1000000L + "ms");
                                DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
                                response.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/octet-stream");
                                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)data.length);
                                response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
                                ctx.write((Object)response);
                                ctx.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedStream((InputStream)new ByteArrayInputStream(data), 65535))).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            }
                            catch (Throwable e) {
                                ViaBedrock.getPlatform().getLogger().log(Level.SEVERE, "Failed to convert resource packs", e);
                                ctx.close();
                            }
                        }
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                        ctx.close();
                    }
                });
            }
        }).bind((SocketAddress)bindAddress).syncUninterruptibly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(UUID uuid, UserConnection connection) {
        Map<UUID, UserConnection> map = this.connections;
        synchronized (map) {
            this.connections.put(uuid, connection);
        }
        connection.getChannel().closeFuture().addListener(future -> {
            Map<UUID, UserConnection> map = this.connections;
            synchronized (map) {
                this.connections.remove(uuid);
            }
        });
    }

    public void stop() {
        if (this.channelFuture != null) {
            this.channelFuture.channel().close();
        }
    }

    public String getUrl() {
        String overrideUrl = ViaBedrock.getConfig().getResourcePackUrl();
        if (!overrideUrl.isEmpty()) {
            return overrideUrl;
        }
        InetSocketAddress bindAddress = (InetSocketAddress)this.channelFuture.channel().localAddress();
        return "http://" + this.bindAddress.getHostString() + ":" + bindAddress.getPort() + "/";
    }

    public Channel getChannel() {
        return this.channelFuture.channel();
    }
}

