/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.io;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.raphimc.viabedrock.api.io.LittleEndianByteBufInputStream;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class NetworkByteBufInputStream
extends LittleEndianByteBufInputStream {
    private final ByteBuf buffer;

    public NetworkByteBufInputStream(ByteBuf buffer) {
        super(buffer);
        this.buffer = buffer;
    }

    @Override
    public int readInt() throws IOException {
        try {
            return BedrockTypes.VAR_INT.read(this.buffer);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public long readLong() throws IOException {
        try {
            return BedrockTypes.VAR_LONG.read(this.buffer);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public String readUTF() throws IOException {
        try {
            return (String)BedrockTypes.STRING.read(this.buffer);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

