/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.model.entity;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.entities.EntityTypes1_21_9;
import com.viaversion.viaversion.api.minecraft.entitydata.EntityData;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.version.VersionedTypes;
import com.viaversion.viaversion.protocols.v1_21_7to1_21_9.packet.ClientboundPackets1_21_9;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.util.EnumUtil;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ClientboundBedrockPackets;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ActorDataIDs;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ActorFlags;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.DataItemType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.SharedTypes_Legacy_LevelSoundEvent;
import net.raphimc.viabedrock.protocol.data.enums.java.BossEventOperationType;
import net.raphimc.viabedrock.protocol.model.Position3f;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;
import net.raphimc.viabedrock.protocol.types.entitydata.EntityDataTypesBedrock;

public class Entity {
    protected final UserConnection user;
    protected final long uniqueId;
    protected final long runtimeId;
    protected final String type;
    protected final int javaId;
    protected final UUID javaUuid;
    protected final EntityTypes1_21_9 javaType;
    protected Position3f position;
    protected Position3f rotation = Position3f.ZERO;
    protected boolean onGround;
    protected final Map<ActorDataIDs, EntityData> entityData = new EnumMap<ActorDataIDs, EntityData>(ActorDataIDs.class);
    protected String name;
    protected int age;
    protected boolean hasBossBar;

    public Entity(UserConnection user, long uniqueId, long runtimeId, String type, int javaId, UUID javaUuid, EntityTypes1_21_9 javaType) {
        this.user = user;
        this.uniqueId = uniqueId;
        this.runtimeId = runtimeId;
        this.type = type;
        this.javaId = javaId;
        this.javaUuid = javaUuid;
        this.javaType = javaType;
    }

    public void tick() {
        ++this.age;
    }

    public void remove() {
        if (this.hasBossBar) {
            this.hasBossBar = false;
            PacketWrapper bossEvent = PacketWrapper.create((PacketType)ClientboundPackets1_21_9.BOSS_EVENT, (UserConnection)this.user);
            bossEvent.write(Types.UUID, (Object)this.javaUuid());
            bossEvent.write((Type)Types.VAR_INT, (Object)BossEventOperationType.REMOVE.ordinal());
            bossEvent.send(BedrockProtocol.class);
        }
    }

    public final void updateEntityData(EntityData[] entityData) {
        ArrayList<EntityData> javaEntityData = new ArrayList<EntityData>();
        this.updateEntityData(entityData, javaEntityData);
        PacketWrapper setEntityData = PacketWrapper.create((PacketType)ClientboundPackets1_21_9.SET_ENTITY_DATA, (UserConnection)this.user);
        setEntityData.write((Type)Types.VAR_INT, (Object)this.javaId);
        setEntityData.write(VersionedTypes.V1_21_9.entityDataList, javaEntityData);
        setEntityData.send(BedrockProtocol.class);
    }

    public final void updateEntityData(EntityData[] entityData, List<EntityData> javaEntityData) {
        for (EntityData data : entityData) {
            ActorDataIDs dataId = ActorDataIDs.getByValue(data.id());
            if (dataId == null) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unknown ActorDataIDs: " + data.id());
                continue;
            }
            DataItemType expectedType = BedrockProtocol.MAPPINGS.getBedrockEntityDataTypes().get((Object)dataId);
            if (expectedType != null && expectedType != ((EntityDataTypesBedrock)data.dataType()).dataItemType()) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Discarding entity data " + String.valueOf((Object)dataId) + " for entity type " + this.type + " due to unexpected data type: " + String.valueOf(data.dataType()));
                continue;
            }
            this.entityData.put(dataId, data);
            if (this.translateEntityData(dataId, data, javaEntityData)) continue;
        }
        this.onEntityDataChanged();
    }

    public void playSound(SharedTypes_Legacy_LevelSoundEvent soundEvent) {
        PacketWrapper levelSoundEvent = PacketWrapper.create((PacketType)ClientboundBedrockPackets.LEVEL_SOUND_EVENT, (UserConnection)this.user);
        levelSoundEvent.write((Type)BedrockTypes.UNSIGNED_VAR_INT, (Object)soundEvent.getValue());
        levelSoundEvent.write(BedrockTypes.POSITION_3F, (Object)this.position);
        levelSoundEvent.write((Type)BedrockTypes.VAR_INT, (Object)0);
        levelSoundEvent.write(BedrockTypes.STRING, (Object)this.type);
        levelSoundEvent.write((Type)Types.BOOLEAN, (Object)false);
        levelSoundEvent.write((Type)Types.BOOLEAN, (Object)false);
        levelSoundEvent.write((Type)BedrockTypes.LONG_LE, (Object)-1L);
        levelSoundEvent.send(BedrockProtocol.class, false);
    }

    public float eyeOffset() {
        return 0.0f;
    }

    public long uniqueId() {
        return this.uniqueId;
    }

    public long runtimeId() {
        return this.runtimeId;
    }

    public String type() {
        return this.type;
    }

    public int javaId() {
        return this.javaId;
    }

    public UUID javaUuid() {
        return this.javaUuid;
    }

    public EntityTypes1_21_9 javaType() {
        return this.javaType;
    }

    public Position3f position() {
        return this.position;
    }

    public void setPosition(Position3f position) {
        this.position = position;
    }

    public Position3f rotation() {
        return this.rotation;
    }

    public void setRotation(Position3f rotation) {
        this.rotation = rotation;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public void setOnGround(boolean onGround) {
        this.onGround = onGround;
    }

    public Map<ActorDataIDs, EntityData> entityData() {
        return this.entityData;
    }

    public Set<ActorFlags> entityFlags() {
        BigInteger combinedFlags = BigInteger.ZERO;
        if (this.entityData.containsKey((Object)ActorDataIDs.RESERVED_0)) {
            combinedFlags = combinedFlags.add(BigInteger.valueOf((Long)this.entityData.get((Object)ActorDataIDs.RESERVED_0).value()));
        }
        if (this.entityData.containsKey((Object)ActorDataIDs.RESERVED_092)) {
            combinedFlags = combinedFlags.add(BigInteger.valueOf((Long)this.entityData.get((Object)ActorDataIDs.RESERVED_092).value()).shiftLeft(64));
        }
        return EnumUtil.getEnumSetFromBitmask(ActorFlags.class, combinedFlags, ActorFlags::getValue);
    }

    public String name() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int age() {
        return this.age;
    }

    public boolean hasBossBar() {
        return this.hasBossBar;
    }

    public void setHasBossBar(boolean hasBossBar) {
        this.hasBossBar = hasBossBar;
    }

    public final int getJavaEntityDataIndex(String fieldName) {
        int index = BedrockProtocol.MAPPINGS.getJavaEntityData().get(this.javaType).indexOf(fieldName);
        if (index == -1) {
            throw new IllegalStateException("Unknown java entity data field: " + fieldName + " for entity type: " + String.valueOf(this.javaType));
        }
        return index;
    }

    protected boolean translateEntityData(ActorDataIDs id, EntityData entityData, List<EntityData> javaEntityData) {
        return false;
    }

    protected void onEntityDataChanged() {
    }
}

