/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.modinterface;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.entitydata.EntityData;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.protocols.v1_21_7to1_21_9.packet.ClientboundConfigurationPackets1_21_9;
import com.viaversion.viaversion.protocols.v1_21_7to1_21_9.packet.ClientboundPackets1_21_9;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ActorDataIDs;
import net.raphimc.viabedrock.protocol.model.SkinData;
import net.raphimc.viabedrock.protocol.types.primitive.ImageType;

public class ViaBedrockUtilityInterface {
    public static final String CONFIRM_CHANNEL = "viabedrockutility:confirm";
    public static final String CHANNEL = "viabedrockutility:data";
    private static final int MAX_PAYLOAD_SIZE = 0x100000;

    public static void confirmPresence(UserConnection user) {
        PacketWrapper pluginMessage = PacketWrapper.create((PacketType)ClientboundConfigurationPackets1_21_9.CUSTOM_PAYLOAD, (UserConnection)user);
        pluginMessage.write(Types.STRING, (Object)CHANNEL);
        pluginMessage.write((Type)Types.INT, (Object)PayloadType.CONFIRM.ordinal());
        pluginMessage.send(BedrockProtocol.class);
    }

    public static void spawnCustomEntity(UserConnection user, UUID uuid, String identifier, Map<ActorDataIDs, EntityData> entityData) {
        PacketWrapper pluginMessage = PacketWrapper.create((PacketType)ClientboundPackets1_21_9.CUSTOM_PAYLOAD, (UserConnection)user);
        pluginMessage.write(Types.STRING, (Object)CHANNEL);
        pluginMessage.write((Type)Types.INT, (Object)PayloadType.MODEL_REQUEST.ordinal());
        ViaBedrockUtilityInterface.writeString(pluginMessage, identifier);
        boolean writeBitmask1 = entityData.containsKey((Object)ActorDataIDs.RESERVED_0);
        pluginMessage.write((Type)Types.BOOLEAN, (Object)writeBitmask1);
        if (writeBitmask1) {
            pluginMessage.write((Type)Types.LONG, (Object)((Long)entityData.get((Object)ActorDataIDs.RESERVED_0).value()));
        }
        boolean writeBitmask2 = entityData.containsKey((Object)ActorDataIDs.RESERVED_092);
        pluginMessage.write((Type)Types.BOOLEAN, (Object)writeBitmask2);
        if (writeBitmask2) {
            pluginMessage.write((Type)Types.LONG, (Object)((Long)entityData.get((Object)ActorDataIDs.RESERVED_092).value()));
        }
        boolean writeVariant = entityData.containsKey((Object)ActorDataIDs.VARIANT);
        pluginMessage.write((Type)Types.BOOLEAN, (Object)writeVariant);
        if (writeVariant) {
            pluginMessage.write((Type)Types.INT, (Object)((Integer)entityData.get((Object)ActorDataIDs.VARIANT).value()));
        }
        boolean writeMarkVariant = entityData.containsKey((Object)ActorDataIDs.MARK_VARIANT);
        pluginMessage.write((Type)Types.BOOLEAN, (Object)writeMarkVariant);
        if (writeMarkVariant) {
            pluginMessage.write((Type)Types.INT, (Object)((Integer)entityData.get((Object)ActorDataIDs.MARK_VARIANT).value()));
        }
        pluginMessage.write(Types.UUID, (Object)uuid);
        pluginMessage.send(BedrockProtocol.class);
    }

    public static void sendSkin(UserConnection user, UUID uuid, SkinData skin) {
        PacketWrapper pluginMessage;
        if (skin.skinData() == null || skin.persona()) {
            return;
        }
        boolean hasGeometry = !skin.geometryData().isEmpty() && !skin.geometryData().toLowerCase(Locale.ROOT).equals("null");
        byte[] skinData = ImageType.getImageData(skin.skinData());
        int maxPayloadSize = 1048552;
        int chunkCount = (int)Math.ceil((double)skinData.length / 1048552.0);
        PacketWrapper pluginMessage2 = PacketWrapper.create((PacketType)ClientboundPackets1_21_9.CUSTOM_PAYLOAD, (UserConnection)user);
        pluginMessage2.write(Types.STRING, (Object)CHANNEL);
        pluginMessage2.write((Type)Types.INT, (Object)PayloadType.SKIN_INFORMATION.ordinal());
        pluginMessage2.write(Types.UUID, (Object)uuid);
        pluginMessage2.write((Type)Types.INT, (Object)skin.skinData().getWidth());
        pluginMessage2.write((Type)Types.INT, (Object)skin.skinData().getHeight());
        ViaBedrockUtilityInterface.writeString(pluginMessage2, skin.skinResourcePatch());
        pluginMessage2.write((Type)Types.BOOLEAN, (Object)hasGeometry);
        if (hasGeometry) {
            ViaBedrockUtilityInterface.writeString(pluginMessage2, skin.geometryData());
        }
        pluginMessage2.write((Type)Types.INT, (Object)chunkCount);
        pluginMessage2.send(BedrockProtocol.class);
        for (int i = 0; i < chunkCount; ++i) {
            pluginMessage = PacketWrapper.create((PacketType)ClientboundPackets1_21_9.CUSTOM_PAYLOAD, (UserConnection)user);
            pluginMessage.write(Types.STRING, (Object)CHANNEL);
            pluginMessage.write((Type)Types.INT, (Object)PayloadType.SKIN_DATA.ordinal());
            pluginMessage.write(Types.UUID, (Object)uuid);
            pluginMessage.write((Type)Types.INT, (Object)i);
            if (chunkCount == 1) {
                pluginMessage.write(Types.REMAINING_BYTES, (Object)skinData);
            } else {
                pluginMessage.write(Types.REMAINING_BYTES, (Object)Arrays.copyOfRange(skinData, i * 1048552, Math.min((i + 1) * 1048552, skinData.length)));
            }
            pluginMessage.send(BedrockProtocol.class);
        }
        if (skin.capeData() != null) {
            byte[] capeData = ImageType.getImageData(skin.capeData());
            pluginMessage = PacketWrapper.create((PacketType)ClientboundPackets1_21_9.CUSTOM_PAYLOAD, (UserConnection)user);
            pluginMessage.write(Types.STRING, (Object)CHANNEL);
            pluginMessage.write((Type)Types.INT, (Object)PayloadType.CAPE.ordinal());
            pluginMessage.write(Types.UUID, (Object)uuid);
            pluginMessage.write((Type)Types.INT, (Object)skin.capeData().getWidth());
            pluginMessage.write((Type)Types.INT, (Object)skin.capeData().getHeight());
            ViaBedrockUtilityInterface.writeString(pluginMessage, skin.capeId());
            pluginMessage.write((Type)Types.INT, (Object)capeData.length);
            pluginMessage.write(Types.REMAINING_BYTES, (Object)capeData);
            pluginMessage.send(BedrockProtocol.class);
        }
    }

    private static void writeString(PacketWrapper wrapper, String s) {
        wrapper.write((Type)Types.INT, (Object)s.length());
        wrapper.write(Types.REMAINING_BYTES, (Object)s.getBytes(StandardCharsets.UTF_8));
    }

    private static enum PayloadType {
        CONFIRM,
        MODEL_REQUEST,
        ANIMATE,
        CAPE,
        SKIN_INFORMATION,
        SKIN_DATA;

    }
}

