/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.util;

import io.jsonwebtoken.Locator;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

public class CryptUtil {
    public static final KeyFactory EC_KEYFACTORY;
    public static final Locator<Key> X5U_KEY_LOCATOR;

    public static ECPublicKey ecPublicKeyFromBase64(String base64) {
        return CryptUtil.ecPublicKeyFromBytes(Base64.getDecoder().decode(base64));
    }

    public static ECPublicKey ecPublicKeyFromBytes(byte[] bytes) {
        try {
            return (ECPublicKey)EC_KEYFACTORY.generatePublic(new X509EncodedKeySpec(bytes));
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("Could not decode public key", e);
        }
    }

    public static KeyPair generateEcdsa384KeyPair() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyPairGenerator secp384r1 = KeyPairGenerator.getInstance("EC");
        secp384r1.initialize(new ECGenParameterSpec("secp384r1"));
        return secp384r1.generateKeyPair();
    }

    static {
        X5U_KEY_LOCATOR = header -> CryptUtil.ecPublicKeyFromBase64((String)header.get((Object)"x5u"));
        try {
            EC_KEYFACTORY = KeyFactory.getInstance("EC");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not create EllipticCurve KeyFactory", e);
        }
    }
}

