/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.util;

import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.libs.gson.JsonParser;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public record Jwt(JsonObject header, JsonObject payload, byte[] signature) {
    public static Jwt parse(String compactJwt) {
        if (compactJwt == null) {
            throw new IllegalArgumentException("JWT string is null");
        }
        String[] parts = compactJwt.split("\\.");
        if (parts.length < 2) {
            throw new IllegalArgumentException("JWT must have at least header and payload");
        }
        JsonObject header = JsonParser.parseString((String)new String(Base64.getUrlDecoder().decode(parts[0]), StandardCharsets.UTF_8)).getAsJsonObject();
        JsonObject payload = JsonParser.parseString((String)new String(Base64.getUrlDecoder().decode(parts[1]), StandardCharsets.UTF_8)).getAsJsonObject();
        byte[] signature = parts.length > 2 ? Base64.getUrlDecoder().decode(parts[2]) : null;
        return new Jwt(header, payload, signature);
    }
}

