/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import team.unnamed.mocha.parser.MolangParser;
import team.unnamed.mocha.parser.ast.Expression;
import team.unnamed.mocha.parser.ast.ExpressionVisitor;
import team.unnamed.mocha.runtime.ExpressionInterpreter;
import team.unnamed.mocha.runtime.Scope;
import team.unnamed.mocha.runtime.value.MutableObjectBinding;
import team.unnamed.mocha.runtime.value.NumberValue;
import team.unnamed.mocha.runtime.value.Value;

public class MoLangEngine {
    public static Value eval(Scope scope, String expression) throws IOException {
        return MoLangEngine.eval(scope, MoLangEngine.parse(expression));
    }

    public static Value eval(Scope scope, List<Expression> expressions) {
        Scope localScope = scope.copy();
        MutableObjectBinding tempBinding = new MutableObjectBinding();
        localScope.set("temp", (Value)tempBinding);
        localScope.set("t", (Value)tempBinding);
        localScope.readOnly(true);
        ExpressionInterpreter evaluator = new ExpressionInterpreter(null, localScope);
        evaluator.warnOnReflectiveFunctionUsage(false);
        NumberValue lastResult = NumberValue.zero();
        for (Expression expression : expressions) {
            lastResult = (Value)expression.visit((ExpressionVisitor)evaluator);
            Value returnValue = evaluator.popReturnValue();
            if (returnValue == null) continue;
            lastResult = returnValue;
            break;
        }
        return lastResult;
    }

    public static List<Expression> parse(String expression) throws IOException {
        try (StringReader reader = new StringReader(expression);){
            List<Expression> list = MoLangEngine.parse(reader);
            return list;
        }
    }

    public static List<Expression> parse(Reader reader) throws IOException {
        return MolangParser.parser((Reader)reader).parseAll();
    }
}

