/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.experimental;

import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.BlockFace;
import com.viaversion.viaversion.api.minecraft.BlockPosition;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.protocols.v1_21_5to1_21_6.packet.ServerboundPackets1_21_6;
import java.util.List;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.container.player.InventoryContainer;
import net.raphimc.viabedrock.api.model.entity.ClientPlayerEntity;
import net.raphimc.viabedrock.api.util.PacketFactory;
import net.raphimc.viabedrock.experimental.ExperimentalPacketFactory;
import net.raphimc.viabedrock.experimental.model.inventory.BedrockInventoryTransaction;
import net.raphimc.viabedrock.experimental.model.inventory.InventoryActionData;
import net.raphimc.viabedrock.experimental.model.inventory.InventorySource;
import net.raphimc.viabedrock.experimental.model.inventory.InventoryTransactionData;
import net.raphimc.viabedrock.experimental.rewriter.InventoryTransactionRewriter;
import net.raphimc.viabedrock.experimental.util.ProtocolUtil;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ServerboundBedrockPackets;
import net.raphimc.viabedrock.protocol.data.enums.Direction;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.ItemUseInventoryTransaction_TriggerType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ComplexInventoryTransaction_Type;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ContainerID;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.InventorySourceType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.InventorySource_InventorySourceFlags;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ItemReleaseInventoryTransaction_ActionType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ItemUseInventoryTransaction_ActionType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ItemUseInventoryTransaction_PredictedResult;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.PlayerActionType;
import net.raphimc.viabedrock.protocol.data.enums.java.GameMode;
import net.raphimc.viabedrock.protocol.data.enums.java.InteractionHand;
import net.raphimc.viabedrock.protocol.data.enums.java.PlayerActionAction;
import net.raphimc.viabedrock.protocol.model.BedrockItem;
import net.raphimc.viabedrock.protocol.model.Position3f;
import net.raphimc.viabedrock.protocol.storage.ChunkTracker;
import net.raphimc.viabedrock.protocol.storage.EntityTracker;
import net.raphimc.viabedrock.protocol.storage.InventoryTracker;

public class ExperimentalFeatures {
    public static void registerPacketTranslators(BedrockProtocol protocol) {
        ProtocolUtil.prependServerbound(protocol, ServerboundPackets1_21_6.PLAYER_ACTION, wrapper -> {
            InventoryTransactionRewriter inventoryTransactionRewriter = (InventoryTransactionRewriter)wrapper.user().get(InventoryTransactionRewriter.class);
            InventoryTracker inventoryTracker = (InventoryTracker)wrapper.user().get(InventoryTracker.class);
            PlayerActionAction action = PlayerActionAction.values()[(Integer)wrapper.passthrough((Type)Types.VAR_INT)];
            wrapper.passthrough(Types.BLOCK_POSITION1_14);
            wrapper.passthrough((Type)Types.UNSIGNED_BYTE);
            wrapper.passthrough((Type)Types.VAR_INT);
            if (action == PlayerActionAction.RELEASE_USE_ITEM) {
                InventoryContainer inventoryContainer = inventoryTracker.getInventoryContainer();
                wrapper.clearPacket();
                wrapper.setPacketType((PacketType)ServerboundBedrockPackets.INVENTORY_TRANSACTION);
                BedrockInventoryTransaction inventoryTransaction = new BedrockInventoryTransaction(0, null, null, ComplexInventoryTransaction_Type.ItemReleaseTransaction, new InventoryTransactionData.ReleaseItemTransactionData(ItemReleaseInventoryTransaction_ActionType.Release, inventoryContainer.getSelectedHotbarSlot(), inventoryContainer.getSelectedHotbarItem(), ((EntityTracker)wrapper.user().get(EntityTracker.class)).getClientPlayer().position()));
                wrapper.write(inventoryTransactionRewriter.getInventoryTransactionType(), (Object)inventoryTransaction);
                wrapper.sendToServer(BedrockProtocol.class);
                wrapper.cancel();
            } else if (action == PlayerActionAction.DROP_ITEM || action == PlayerActionAction.DROP_ALL_ITEMS) {
                BedrockItem currentItem = inventoryTracker.getInventoryContainer().getSelectedHotbarItem();
                wrapper.cancel();
                if (currentItem.isEmpty()) {
                    return;
                }
                BedrockItem predictedAmount = currentItem.copy();
                if (action == PlayerActionAction.DROP_ITEM) {
                    predictedAmount.setAmount(1);
                }
                BedrockItem predictedToItem = currentItem.copy();
                if (action == PlayerActionAction.DROP_ITEM) {
                    if (predictedToItem.amount() > 1) {
                        predictedToItem.setAmount(currentItem.amount() - 1);
                    } else {
                        predictedToItem = BedrockItem.empty();
                    }
                } else {
                    predictedToItem = BedrockItem.empty();
                }
                PacketWrapper transactionPacket = PacketWrapper.create((PacketType)ServerboundBedrockPackets.INVENTORY_TRANSACTION, (UserConnection)wrapper.user());
                BedrockInventoryTransaction inventoryTransaction = new BedrockInventoryTransaction(0, null, List.of(new InventoryActionData(new InventorySource(InventorySourceType.WorldInteraction, ContainerID.CONTAINER_ID_NONE.getValue(), InventorySource_InventorySourceFlags.NoFlag), 0, BedrockItem.empty(), predictedAmount), new InventoryActionData(new InventorySource(InventorySourceType.ContainerInventory, ContainerID.CONTAINER_ID_INVENTORY.getValue(), InventorySource_InventorySourceFlags.NoFlag), inventoryTracker.getInventoryContainer().getSelectedHotbarSlot(), currentItem, predictedToItem)), ComplexInventoryTransaction_Type.NormalTransaction, new InventoryTransactionData.NormalTransactionData());
                transactionPacket.write(inventoryTransactionRewriter.getInventoryTransactionType(), (Object)inventoryTransaction);
                transactionPacket.sendToServer(BedrockProtocol.class);
            }
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_21_6.USE_ITEM, ServerboundBedrockPackets.INVENTORY_TRANSACTION, wrapper -> {
            EntityTracker entityTracker = (EntityTracker)wrapper.user().get(EntityTracker.class);
            InventoryContainer inventoryContainer = ((InventoryTracker)wrapper.user().get(InventoryTracker.class)).getInventoryContainer();
            InventoryTransactionRewriter inventoryTransactionRewriter = (InventoryTransactionRewriter)wrapper.user().get(InventoryTransactionRewriter.class);
            int hand = (Integer)wrapper.read((Type)Types.VAR_INT);
            wrapper.read((Type)Types.VAR_INT);
            wrapper.read((Type)Types.FLOAT);
            wrapper.read((Type)Types.FLOAT);
            if (hand != InteractionHand.MAIN_HAND.ordinal()) {
                wrapper.cancel();
                return;
            }
            BedrockInventoryTransaction inventoryTransaction = new BedrockInventoryTransaction(0, null, null, ComplexInventoryTransaction_Type.ItemUseTransaction, new InventoryTransactionData.UseItemTransactionData(ItemUseInventoryTransaction_ActionType.Use, ItemUseInventoryTransaction_TriggerType.Unknown, new BlockPosition(0, 0, 0), 255, inventoryContainer.getSelectedHotbarSlot(), inventoryContainer.getSelectedHotbarItem(), entityTracker.getClientPlayer().position(), Position3f.ZERO, 0, ItemUseInventoryTransaction_PredictedResult.Failure));
            wrapper.write(inventoryTransactionRewriter.getInventoryTransactionType(), (Object)inventoryTransaction);
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_21_6.USE_ITEM_ON, null, wrapper -> {
            wrapper.cancel();
            ClientPlayerEntity clientPlayer = ((EntityTracker)wrapper.user().get(EntityTracker.class)).getClientPlayer();
            InventoryTracker inventoryTracker = (InventoryTracker)wrapper.user().get(InventoryTracker.class);
            ChunkTracker chunkTracker = (ChunkTracker)wrapper.user().get(ChunkTracker.class);
            InventoryTransactionRewriter inventoryTransactionRewriter = (InventoryTransactionRewriter)wrapper.user().get(InventoryTransactionRewriter.class);
            InteractionHand hand = InteractionHand.values()[(Integer)wrapper.read((Type)Types.VAR_INT)];
            BlockPosition position = (BlockPosition)wrapper.read(Types.BLOCK_POSITION1_14);
            short faceInt = (Short)wrapper.read((Type)Types.UNSIGNED_BYTE);
            Direction direction = Direction.getFromVerticalId(faceInt);
            if (direction == null) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unknown block face id: " + faceInt);
                return;
            }
            BlockFace face = direction.blockFace();
            Position3f clickPosition = new Position3f(((Float)wrapper.read((Type)Types.FLOAT)).floatValue(), ((Float)wrapper.read((Type)Types.FLOAT)).floatValue(), ((Float)wrapper.read((Type)Types.FLOAT)).floatValue());
            boolean insideBlock = (Boolean)wrapper.read((Type)Types.BOOLEAN);
            wrapper.read((Type)Types.BOOLEAN);
            PacketFactory.sendJavaBlockChangedAck(wrapper.user(), (Integer)wrapper.read((Type)Types.VAR_INT));
            if (hand != InteractionHand.MAIN_HAND) {
                return;
            }
            ExperimentalPacketFactory.sendBedrockPlayerAction(wrapper.user(), clientPlayer.runtimeId(), PlayerActionType.StartItemUseOn, position, insideBlock ? position : position.getRelative(face), faceInt);
            PacketWrapper transactionPacket = PacketWrapper.create((PacketType)ServerboundBedrockPackets.INVENTORY_TRANSACTION, (UserConnection)wrapper.user());
            BedrockItem predictedToItem = inventoryTracker.getInventoryContainer().getSelectedHotbarItem().copy();
            if (predictedToItem.blockRuntimeId() != 0 && clientPlayer.javaGameMode() != GameMode.CREATIVE) {
                predictedToItem.setAmount(predictedToItem.amount() - 1);
            }
            if (predictedToItem.amount() <= 0) {
                predictedToItem = BedrockItem.empty();
            }
            BedrockInventoryTransaction inventoryTransaction = new BedrockInventoryTransaction(0, null, List.of(new InventoryActionData(new InventorySource(InventorySourceType.ContainerInventory, ContainerID.CONTAINER_ID_INVENTORY.getValue(), InventorySource_InventorySourceFlags.NoFlag), inventoryTracker.getInventoryContainer().getSelectedHotbarSlot(), inventoryTracker.getInventoryContainer().getSelectedHotbarItem(), predictedToItem)), ComplexInventoryTransaction_Type.ItemUseTransaction, new InventoryTransactionData.UseItemTransactionData(ItemUseInventoryTransaction_ActionType.Place, ItemUseInventoryTransaction_TriggerType.PlayerInput, position, faceInt, inventoryTracker.getInventoryContainer().getSelectedHotbarSlot(), inventoryTracker.getInventoryContainer().getSelectedHotbarItem(), clientPlayer.position(), clickPosition, chunkTracker.getBlockState(position), ItemUseInventoryTransaction_PredictedResult.Success));
            transactionPacket.write(inventoryTransactionRewriter.getInventoryTransactionType(), (Object)inventoryTransaction);
            transactionPacket.sendToServer(BedrockProtocol.class);
            ExperimentalPacketFactory.sendBedrockPlayerAction(wrapper.user(), clientPlayer.runtimeId(), PlayerActionType.StopItemUseOn, position, new BlockPosition(0, 0, 0), 0);
        });
    }

    public static void registerTasks() {
    }

    public static void registerStorages(UserConnection user) {
        user.put((StorableObject)new InventoryTransactionRewriter(user));
    }
}

