/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.experimental.types.inventory;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.type.Type;
import io.netty.buffer.ByteBuf;
import net.raphimc.viabedrock.experimental.model.inventory.InventoryActionData;
import net.raphimc.viabedrock.experimental.model.inventory.InventorySource;
import net.raphimc.viabedrock.experimental.types.ExperimentalBedrockTypes;
import net.raphimc.viabedrock.protocol.model.BedrockItem;
import net.raphimc.viabedrock.protocol.rewriter.ItemRewriter;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class InventoryActionDataType
extends Type<InventoryActionData> {
    private final UserConnection user;

    public InventoryActionDataType(UserConnection user) {
        super(InventoryActionData.class);
        this.user = user;
    }

    public InventoryActionData read(ByteBuf buffer) {
        ItemRewriter itemRewriter = (ItemRewriter)this.user.get(ItemRewriter.class);
        if (itemRewriter == null) {
            throw new IllegalStateException("ItemRewriter not found for user " + String.valueOf(this.user));
        }
        InventorySource source = (InventorySource)ExperimentalBedrockTypes.INVENTORY_SOURCE.read(buffer);
        int slot = BedrockTypes.UNSIGNED_VAR_INT.read(buffer);
        BedrockItem fromItem = (BedrockItem)itemRewriter.itemType().read(buffer);
        BedrockItem toItem = (BedrockItem)itemRewriter.itemType().read(buffer);
        return new InventoryActionData(source, slot, fromItem, toItem);
    }

    public void write(ByteBuf buffer, InventoryActionData value) {
        ItemRewriter itemRewriter = (ItemRewriter)this.user.get(ItemRewriter.class);
        if (itemRewriter == null) {
            throw new IllegalStateException("ItemRewriter not found for user " + String.valueOf(this.user));
        }
        ExperimentalBedrockTypes.INVENTORY_SOURCE.write(buffer, (Object)value.source());
        BedrockTypes.UNSIGNED_VAR_INT.write(buffer, value.slot());
        itemRewriter.itemType().write(buffer, (Object)value.fromItem());
        itemRewriter.itemType().write(buffer, (Object)value.toItem());
    }
}

