/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.util.List;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.io.compression.CompressionAlgorithm;
import net.raphimc.viabedrock.api.io.compression.NoopCompression;
import net.raphimc.viabedrock.api.io.compression.ProtocolCompression;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.PacketCompressionAlgorithm;

public class CompressionCodec
extends ByteToMessageCodec<ByteBuf> {
    private final ProtocolCompression protocolCompression;

    public CompressionCodec(ProtocolCompression protocolCompression) {
        this.protocolCompression = protocolCompression;
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        this.protocolCompression.end();
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
        if (!in.isReadable()) {
            return;
        }
        int inputSize = in.readableBytes();
        CompressionAlgorithm compressionAlgorithm = this.protocolCompression.getCompressionAlgorithmForSize(inputSize);
        if (compressionAlgorithm instanceof NoopCompression) {
            out.writeByte(PacketCompressionAlgorithm.None.getValue());
            out.writeBytes(in);
        } else {
            in.markReaderIndex();
            ByteBuf compressedData = ctx.alloc().buffer();
            compressionAlgorithm.compress(in, compressedData);
            if (compressedData.readableBytes() < inputSize) {
                out.writeByte(compressionAlgorithm.getAlgorithm().getValue());
                out.writeBytes(compressedData);
            } else {
                in.resetReaderIndex();
                out.writeByte(PacketCompressionAlgorithm.None.getValue());
                out.writeBytes(in);
            }
            compressedData.release();
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (!in.isReadable()) {
            return;
        }
        PacketCompressionAlgorithm algorithm = PacketCompressionAlgorithm.getByValue(in.readUnsignedByte());
        if (algorithm == null) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received unknown compression algorithm. Dropping packet.");
            return;
        }
        CompressionAlgorithm compressionAlgorithm = this.protocolCompression.getCompressionAlgorithm(algorithm);
        if (compressionAlgorithm instanceof NoopCompression) {
            out.add(in.retain());
        } else {
            ByteBuf uncompressedData = ctx.alloc().buffer();
            compressionAlgorithm.decompress(in, uncompressedData);
            out.add(uncompressedData);
        }
    }
}

