/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.netty.nethernet;

import com.google.common.primitives.Longs;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.handler.codec.CorruptedFrameException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class DiscoveryEncryptionCodec
extends ByteToMessageCodec<ByteBuf> {
    private final SecretKey cryptoKey;
    private final SecretKey signingKey;

    public DiscoveryEncryptionCodec(long applicationId) throws NoSuchAlgorithmException {
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        byte[] key = sha256.digest(Longs.toByteArray((long)Long.reverseBytes(applicationId)));
        this.cryptoKey = new SecretKeySpec(key, "AES");
        this.signingKey = new SecretKeySpec(key, "HmacSHA256");
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
        ByteBuf payloadBuffer = Unpooled.buffer((int)(2 + in.readableBytes()));
        payloadBuffer.writeShortLE(2 + in.readableBytes());
        payloadBuffer.writeBytes(in);
        byte[] payloadBytes = new byte[payloadBuffer.readableBytes()];
        payloadBuffer.readBytes(payloadBytes);
        payloadBuffer.release();
        Mac hmac = Mac.getInstance("HmacSHA256");
        hmac.init(this.signingKey);
        byte[] signature = hmac.doFinal(payloadBytes);
        out.writeBytes(signature);
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(1, this.cryptoKey);
        byte[] encryptedPayload = cipher.doFinal(payloadBytes);
        out.writeBytes(encryptedPayload);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        byte[] receivedSignature = new byte[32];
        in.readBytes(receivedSignature);
        byte[] encryptedPayload = new byte[in.readableBytes()];
        in.readBytes(encryptedPayload);
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(2, this.cryptoKey);
        byte[] payloadBytes = cipher.doFinal(encryptedPayload);
        Mac hmac = Mac.getInstance("HmacSHA256");
        hmac.init(this.signingKey);
        byte[] expectedSignature = hmac.doFinal(payloadBytes);
        if (!MessageDigest.isEqual(receivedSignature, expectedSignature)) {
            throw new CorruptedFrameException("Invalid packet signature");
        }
        ByteBuf payloadBuffer = Unpooled.wrappedBuffer((byte[])payloadBytes);
        int length = payloadBuffer.readUnsignedShortLE() - 2;
        if (payloadBuffer.readableBytes() < length) {
            throw new CorruptedFrameException("Invalid payload length");
        }
        out.add(payloadBuffer);
    }
}

