/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.netty.raknet;

import com.google.common.primitives.Longs;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.handler.codec.CorruptedFrameException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class AesEncryptionCodec
extends ByteToMessageCodec<ByteBuf> {
    private final SecretKey secretKey;
    private final Cipher inCipher;
    private final Cipher outCipher;
    private final MessageDigest sha256;
    private long sentPacketCounter;
    private long receivedPacketCounter;

    public AesEncryptionCodec(SecretKey secretKey) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException {
        byte[] iv = new byte[16];
        System.arraycopy(secretKey.getEncoded(), 0, iv, 0, 12);
        iv[15] = 2;
        this.secretKey = secretKey;
        this.inCipher = Cipher.getInstance("AES/CTR/NoPadding");
        this.inCipher.init(2, (Key)secretKey, new IvParameterSpec(iv));
        this.outCipher = Cipher.getInstance("AES/CTR/NoPadding");
        this.outCipher.init(1, (Key)secretKey, new IvParameterSpec(iv));
        this.sha256 = MessageDigest.getInstance("SHA-256");
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
        byte[] hash = this.generateHash(in, this.sentPacketCounter++);
        ByteBuffer inBuffer = in.nioBuffer();
        out.ensureWritable(in.readableBytes() + 8);
        this.outCipher.update(inBuffer, out.nioBuffer(0, in.readableBytes()));
        this.outCipher.update(ByteBuffer.wrap(hash), out.nioBuffer(in.readableBytes(), 8));
        out.writerIndex(in.readableBytes() + 8);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        ByteBuffer inBuffer = in.nioBuffer();
        ByteBuffer outBuffer = inBuffer.duplicate();
        this.inCipher.update(inBuffer, outBuffer);
        ByteBuf output = in.readRetainedSlice(in.readableBytes() - 8);
        byte[] receivedHash = new byte[8];
        in.readBytes(receivedHash);
        byte[] expectedHash = this.generateHash(output, this.receivedPacketCounter++);
        if (!MessageDigest.isEqual(receivedHash, expectedHash)) {
            throw new CorruptedFrameException("Invalid encrypted packet");
        }
        out.add(output);
    }

    private byte[] generateHash(ByteBuf buf, long packetCounter) {
        this.sha256.update(Longs.toByteArray((long)Long.reverseBytes(packetCounter)));
        this.sha256.update(ByteBufUtil.getBytes((ByteBuf)buf));
        this.sha256.update(this.secretKey.getEncoded());
        byte[] hash = this.sha256.digest();
        this.sha256.reset();
        return Arrays.copyOf(hash, 8);
    }
}

