/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.data.enums;

import com.viaversion.viaversion.api.minecraft.BlockFace;

public enum Direction {
    DOWN(0, -1, BlockFace.BOTTOM),
    UP(1, -1, BlockFace.TOP),
    NORTH(2, 2, BlockFace.NORTH),
    SOUTH(3, 0, BlockFace.SOUTH),
    WEST(4, 1, BlockFace.WEST),
    EAST(5, 3, BlockFace.EAST);

    private final int verticalId;
    private final int horizontalId;
    private final BlockFace blockFace;

    private Direction(int verticalId, int horizontalId, BlockFace blockFace) {
        this.verticalId = verticalId;
        this.horizontalId = horizontalId;
        this.blockFace = blockFace;
    }

    public static Direction getFromVerticalId(int verticalId, Direction fallback) {
        Direction direction = Direction.getFromVerticalId(verticalId);
        return direction == null ? fallback : direction;
    }

    public static Direction getFromVerticalId(int verticalId) {
        for (Direction direction : Direction.values()) {
            if (direction.verticalId != verticalId) continue;
            return direction;
        }
        return null;
    }

    public static Direction getFromHorizontalId(int horizontalId, Direction fallback) {
        Direction direction = Direction.getFromHorizontalId(horizontalId);
        return direction == null ? fallback : direction;
    }

    public static Direction getFromHorizontalId(int horizontalId) {
        if (horizontalId == -1) {
            return null;
        }
        for (Direction direction : Direction.values()) {
            if (direction.horizontalId != horizontalId) continue;
            return direction;
        }
        return null;
    }

    public boolean isHorizontal() {
        return this.horizontalId != -1;
    }

    public int verticalId() {
        return this.verticalId;
    }

    public int horizontalId() {
        return this.horizontalId;
    }

    public BlockFace blockFace() {
        return this.blockFace;
    }
}

