/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.data.enums.bedrock.generated;

import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectOpenHashMap;

public enum TextPacketType {
    Raw(0),
    Chat(1),
    Translate(2),
    Popup(3),
    JukeboxPopup(4),
    Tip(5),
    SystemMessage(6),
    Whisper(7),
    Announcement(8),
    TextObjectWhisper(9),
    TextObject(10),
    TextObjectAnnouncement(11);

    private static final Int2ObjectMap<TextPacketType> BY_VALUE;
    private final int value;

    public static TextPacketType getByValue(int value) {
        return (TextPacketType)((Object)BY_VALUE.get(value));
    }

    public static TextPacketType getByValue(int value, TextPacketType fallback) {
        return (TextPacketType)((Object)BY_VALUE.getOrDefault(value, (Object)fallback));
    }

    private TextPacketType(TextPacketType value) {
        this(value.value);
    }

    private TextPacketType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    static {
        BY_VALUE = new Int2ObjectOpenHashMap();
        for (TextPacketType value : TextPacketType.values()) {
            if (BY_VALUE.containsKey(value.value)) continue;
            BY_VALUE.put(value.value, (Object)value);
        }
    }
}

