/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.packet;

import com.google.common.collect.Lists;
import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.Holder;
import com.viaversion.viaversion.api.minecraft.Vector3d;
import com.viaversion.viaversion.api.minecraft.entities.EntityTypes1_21_9;
import com.viaversion.viaversion.api.minecraft.entitydata.EntityData;
import com.viaversion.viaversion.api.minecraft.entitydata.types.EntityDataTypes1_21_9;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.version.VersionedTypes;
import com.viaversion.viaversion.protocols.v1_21_7to1_21_9.packet.ClientboundPackets1_21_9;
import com.viaversion.viaversion.util.Key;
import java.util.ArrayList;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.entity.ClientPlayerEntity;
import net.raphimc.viabedrock.api.model.entity.CustomEntity;
import net.raphimc.viabedrock.api.model.entity.Entity;
import net.raphimc.viabedrock.api.model.entity.LivingEntity;
import net.raphimc.viabedrock.api.model.resourcepack.EntityDefinitions;
import net.raphimc.viabedrock.api.util.MathUtil;
import net.raphimc.viabedrock.api.util.PacketFactory;
import net.raphimc.viabedrock.api.util.RegistryUtil;
import net.raphimc.viabedrock.api.util.TextUtil;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ClientboundBedrockPackets;
import net.raphimc.viabedrock.protocol.data.enums.Direction;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ActorEvent;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.AnimatePacket_Action;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.AttributeModifierOperation;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.AttributeOperands;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ContainerID;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.MobEffectPacketPayload_Event;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.PlayerActionType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.SharedTypes_Legacy_ActorDamageCause;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.SharedTypes_Legacy_LevelSoundEvent;
import net.raphimc.viabedrock.protocol.data.enums.java.AnimateAction;
import net.raphimc.viabedrock.protocol.data.enums.java.EquipmentSlot;
import net.raphimc.viabedrock.protocol.data.enums.java.Relative;
import net.raphimc.viabedrock.protocol.model.BedrockItem;
import net.raphimc.viabedrock.protocol.model.EntityAttribute;
import net.raphimc.viabedrock.protocol.model.EntityEffect;
import net.raphimc.viabedrock.protocol.model.EntityLink;
import net.raphimc.viabedrock.protocol.model.EntityProperties;
import net.raphimc.viabedrock.protocol.model.Position3f;
import net.raphimc.viabedrock.protocol.rewriter.ItemRewriter;
import net.raphimc.viabedrock.protocol.storage.EntityTracker;
import net.raphimc.viabedrock.protocol.storage.GameSessionStorage;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class EntityPackets {
    private static final float PAINTING_POS_OFFSET = -0.46875f;

    public static void register(BedrockProtocol protocol) {
        protocol.registerClientbound(ClientboundBedrockPackets.ADD_ENTITY, (ClientboundPacketType)ClientboundPackets1_21_9.ADD_ENTITY, wrapper -> {
            Entity entity;
            EntityTracker entityTracker = (EntityTracker)wrapper.user().get(EntityTracker.class);
            GameSessionStorage gameSession = (GameSessionStorage)wrapper.user().get(GameSessionStorage.class);
            long uniqueEntityId = (Long)wrapper.read((Type)BedrockTypes.VAR_LONG);
            long runtimeEntityId = (Long)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_LONG);
            String type = Key.namespaced((String)((String)wrapper.read(BedrockTypes.STRING)));
            Position3f position = (Position3f)wrapper.read(BedrockTypes.POSITION_3F);
            Position3f motion = (Position3f)wrapper.read(BedrockTypes.POSITION_3F);
            Position3f rotation = (Position3f)wrapper.read(BedrockTypes.POSITION_3F);
            wrapper.read((Type)BedrockTypes.FLOAT_LE);
            EntityAttribute[] attributes = new EntityAttribute[((Integer)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_INT)).intValue()];
            for (int i = 0; i < attributes.length; ++i) {
                String name = (String)wrapper.read(BedrockTypes.STRING);
                float minValue = ((Float)wrapper.read((Type)BedrockTypes.FLOAT_LE)).floatValue();
                float currentValue = ((Float)wrapper.read((Type)BedrockTypes.FLOAT_LE)).floatValue();
                float maxValue = ((Float)wrapper.read((Type)BedrockTypes.FLOAT_LE)).floatValue();
                attributes[i] = new EntityAttribute(name, currentValue, minValue, maxValue);
            }
            EntityData[] entityData = (EntityData[])wrapper.read(BedrockTypes.ENTITY_DATA_ARRAY);
            EntityProperties entityProperties = (EntityProperties)wrapper.read(BedrockTypes.ENTITY_PROPERTIES);
            EntityLink[] entityLinks = (EntityLink[])wrapper.read(BedrockTypes.ENTITY_LINK_ARRAY);
            EntityTypes1_21_9 javaEntityType = BedrockProtocol.MAPPINGS.getBedrockToJavaEntities().get(type);
            if (javaEntityType != null) {
                entity = entityTracker.addEntity(uniqueEntityId, runtimeEntityId, type, javaEntityType);
            } else {
                if (!gameSession.getAvailableEntityIdentifiers().contains(type)) {
                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unknown bedrock entity type: " + type);
                    wrapper.cancel();
                    return;
                }
                ResourcePacksStorage resourcePacksStorage = (ResourcePacksStorage)wrapper.user().get(ResourcePacksStorage.class);
                EntityDefinitions.EntityDefinition entityDefinition = resourcePacksStorage.getEntities().get(type);
                if (entityDefinition == null) {
                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing bedrock entity type: " + type);
                    wrapper.cancel();
                    return;
                }
                if (resourcePacksStorage.isLoadedOnJavaClient()) {
                    entity = new CustomEntity(wrapper.user(), uniqueEntityId, runtimeEntityId, type, entityTracker.getNextJavaEntityId(), entityDefinition);
                    entityTracker.addEntity(entity);
                } else {
                    entity = entityTracker.addEntity(uniqueEntityId, runtimeEntityId, type, EntityTypes1_21_9.PIG);
                }
            }
            entity.setPosition(position);
            entity.setRotation(rotation);
            wrapper.write((Type)Types.VAR_INT, (Object)entity.javaId());
            wrapper.write(Types.UUID, (Object)entity.javaUuid());
            wrapper.write((Type)Types.VAR_INT, (Object)entity.javaType().getId());
            wrapper.write((Type)Types.DOUBLE, (Object)position.x());
            wrapper.write((Type)Types.DOUBLE, (Object)position.y());
            wrapper.write((Type)Types.DOUBLE, (Object)position.z());
            wrapper.write(Types.MOVEMENT_VECTOR, (Object)new Vector3d((double)motion.x(), (double)motion.y(), (double)motion.z()));
            wrapper.write((Type)Types.BYTE, (Object)MathUtil.float2Byte(rotation.x()));
            wrapper.write((Type)Types.BYTE, (Object)MathUtil.float2Byte(rotation.y()));
            wrapper.write((Type)Types.BYTE, (Object)MathUtil.float2Byte(rotation.z()));
            wrapper.write((Type)Types.VAR_INT, (Object)0);
            wrapper.send(BedrockProtocol.class);
            wrapper.cancel();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.updateAttributes(attributes);
            }
            entity.updateEntityData(entityData);
        });
        protocol.registerClientbound(ClientboundBedrockPackets.ADD_ITEM_ENTITY, (ClientboundPacketType)ClientboundPackets1_21_9.ADD_ENTITY, wrapper -> {
            EntityTracker entityTracker = (EntityTracker)wrapper.user().get(EntityTracker.class);
            ItemRewriter itemRewriter = (ItemRewriter)wrapper.user().get(ItemRewriter.class);
            long uniqueEntityId = (Long)wrapper.read((Type)BedrockTypes.VAR_LONG);
            long runtimeEntityId = (Long)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_LONG);
            BedrockItem item = (BedrockItem)wrapper.read(itemRewriter.itemType());
            Position3f position = (Position3f)wrapper.read(BedrockTypes.POSITION_3F);
            Position3f motion = (Position3f)wrapper.read(BedrockTypes.POSITION_3F);
            EntityData[] entityData = (EntityData[])wrapper.read(BedrockTypes.ENTITY_DATA_ARRAY);
            wrapper.read((Type)Types.BOOLEAN);
            Entity entity = entityTracker.addEntity(uniqueEntityId, runtimeEntityId, "minecraft:item", EntityTypes1_21_9.ITEM);
            entity.setPosition(position);
            wrapper.write((Type)Types.VAR_INT, (Object)entity.javaId());
            wrapper.write(Types.UUID, (Object)entity.javaUuid());
            wrapper.write((Type)Types.VAR_INT, (Object)entity.javaType().getId());
            wrapper.write((Type)Types.DOUBLE, (Object)position.x());
            wrapper.write((Type)Types.DOUBLE, (Object)position.y());
            wrapper.write((Type)Types.DOUBLE, (Object)position.z());
            wrapper.write(Types.MOVEMENT_VECTOR, (Object)new Vector3d((double)motion.x(), (double)motion.y(), (double)motion.z()));
            wrapper.write((Type)Types.BYTE, (Object)0);
            wrapper.write((Type)Types.BYTE, (Object)0);
            wrapper.write((Type)Types.BYTE, (Object)0);
            wrapper.write((Type)Types.VAR_INT, (Object)0);
            wrapper.send(BedrockProtocol.class);
            wrapper.cancel();
            ArrayList<EntityData> javaEntityData = new ArrayList<EntityData>();
            entity.updateEntityData(entityData, javaEntityData);
            javaEntityData.add(new EntityData(entity.getJavaEntityDataIndex("ITEM"), ((EntityDataTypes1_21_9)VersionedTypes.V1_21_9.entityDataTypes).itemType, (Object)itemRewriter.javaItem(item)));
            PacketWrapper setEntityData = PacketWrapper.create((PacketType)ClientboundPackets1_21_9.SET_ENTITY_DATA, (UserConnection)wrapper.user());
            setEntityData.write((Type)Types.VAR_INT, (Object)entity.javaId());
            setEntityData.write(VersionedTypes.V1_21_9.entityDataList, javaEntityData);
            setEntityData.send(BedrockProtocol.class);
        });
        protocol.registerClientbound(ClientboundBedrockPackets.MOVE_ENTITY_ABSOLUTE, (ClientboundPacketType)ClientboundPackets1_21_9.ENTITY_POSITION_SYNC, wrapper -> {
            EntityTracker entityTracker = (EntityTracker)wrapper.user().get(EntityTracker.class);
            long runtimeEntityId = (Long)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_LONG);
            short flags = (Short)wrapper.read((Type)Types.UNSIGNED_BYTE);
            Position3f position = (Position3f)wrapper.read(BedrockTypes.POSITION_3F);
            float pitch = MathUtil.byte2Float((Byte)wrapper.read((Type)Types.BYTE));
            float yaw = MathUtil.byte2Float((Byte)wrapper.read((Type)Types.BYTE));
            float headYaw = MathUtil.byte2Float((Byte)wrapper.read((Type)Types.BYTE));
            boolean onGround = (flags & 1) != 0;
            boolean teleported = (flags & 2) != 0;
            boolean forceMoveLocalEntity = (flags & 4) != 0;
            Entity entity = entityTracker.getEntityByRid(runtimeEntityId);
            if (entity == null) {
                wrapper.cancel();
                return;
            }
            if (entity == entityTracker.getClientPlayer()) {
                if (!teleported && !forceMoveLocalEntity) {
                    wrapper.cancel();
                    return;
                }
                entity.setPosition(position);
                if (teleported) {
                    wrapper.setPacketType((PacketType)ClientboundPackets1_21_9.PLAYER_POSITION);
                    entityTracker.getClientPlayer().writePlayerPositionPacketToClient(wrapper, Relative.union(Relative.ROTATION, Relative.VELOCITY), true);
                } else {
                    wrapper.write((Type)Types.VAR_INT, (Object)entity.javaId());
                    wrapper.write((Type)Types.DOUBLE, (Object)entity.position().x());
                    wrapper.write((Type)Types.DOUBLE, (Object)((double)entity.position().y() - (double)entity.eyeOffset()));
                    wrapper.write((Type)Types.DOUBLE, (Object)entity.position().z());
                    wrapper.write((Type)Types.DOUBLE, (Object)0.0);
                    wrapper.write((Type)Types.DOUBLE, (Object)0.0);
                    wrapper.write((Type)Types.DOUBLE, (Object)0.0);
                    wrapper.write((Type)Types.FLOAT, (Object)Float.valueOf(entity.rotation().y()));
                    wrapper.write((Type)Types.FLOAT, (Object)Float.valueOf(entity.rotation().x()));
                    wrapper.write((Type)Types.BOOLEAN, (Object)entity.isOnGround());
                }
                return;
            }
            entity.setPosition(position);
            entity.setRotation(new Position3f(pitch, yaw, headYaw));
            entity.setOnGround(onGround);
            wrapper.write((Type)Types.VAR_INT, (Object)entity.javaId());
            wrapper.write((Type)Types.DOUBLE, (Object)position.x());
            wrapper.write((Type)Types.DOUBLE, (Object)((double)position.y() - (double)entity.eyeOffset()));
            wrapper.write((Type)Types.DOUBLE, (Object)position.z());
            wrapper.write((Type)Types.DOUBLE, (Object)0.0);
            wrapper.write((Type)Types.DOUBLE, (Object)0.0);
            wrapper.write((Type)Types.DOUBLE, (Object)0.0);
            wrapper.write((Type)Types.FLOAT, (Object)Float.valueOf(yaw));
            wrapper.write((Type)Types.FLOAT, (Object)Float.valueOf(pitch));
            wrapper.write((Type)Types.BOOLEAN, (Object)onGround);
            PacketFactory.sendJavaRotateHead(wrapper.user(), entity);
        });
        protocol.registerClientbound(ClientboundBedrockPackets.MOVE_ENTITY_DELTA, (ClientboundPacketType)ClientboundPackets1_21_9.ENTITY_POSITION_SYNC, wrapper -> {
            EntityTracker entityTracker = (EntityTracker)wrapper.user().get(EntityTracker.class);
            long runtimeEntityId = (Long)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_LONG);
            int flags = (Integer)wrapper.read((Type)BedrockTypes.UNSIGNED_SHORT_LE);
            boolean hasX = (flags & 1) != 0;
            boolean hasY = (flags & 2) != 0;
            boolean hasZ = (flags & 4) != 0;
            boolean hasPitch = (flags & 8) != 0;
            boolean hasYaw = (flags & 0x10) != 0;
            boolean hasHeadYaw = (flags & 0x20) != 0;
            boolean onGround = (flags & 0x40) != 0;
            boolean teleported = (flags & 0x80) != 0;
            boolean forceMoveLocalEntity = (flags & 0x100) != 0;
            Entity entity = entityTracker.getEntityByRid(runtimeEntityId);
            if (entity == null) {
                wrapper.cancel();
                return;
            }
            if (entity == entityTracker.getClientPlayer()) {
                if (!teleported && !forceMoveLocalEntity) {
                    wrapper.cancel();
                    return;
                }
                float x = 0.0f;
                float y = 0.0f;
                float z = 0.0f;
                if (hasX) {
                    x = ((Float)wrapper.read((Type)BedrockTypes.FLOAT_LE)).floatValue();
                }
                if (hasY) {
                    y = ((Float)wrapper.read((Type)BedrockTypes.FLOAT_LE)).floatValue();
                }
                if (hasZ) {
                    z = ((Float)wrapper.read((Type)BedrockTypes.FLOAT_LE)).floatValue();
                }
                entity.setPosition(new Position3f(x, y, z));
                wrapper.clearPacket();
                if (teleported) {
                    wrapper.setPacketType((PacketType)ClientboundPackets1_21_9.PLAYER_POSITION);
                    entityTracker.getClientPlayer().writePlayerPositionPacketToClient(wrapper, Relative.union(Relative.ROTATION, Relative.VELOCITY), true);
                } else {
                    wrapper.write((Type)Types.VAR_INT, (Object)entity.javaId());
                    wrapper.write((Type)Types.DOUBLE, (Object)entity.position().x());
                    wrapper.write((Type)Types.DOUBLE, (Object)((double)entity.position().y() - (double)entity.eyeOffset()));
                    wrapper.write((Type)Types.DOUBLE, (Object)entity.position().z());
                    wrapper.write((Type)Types.DOUBLE, (Object)0.0);
                    wrapper.write((Type)Types.DOUBLE, (Object)0.0);
                    wrapper.write((Type)Types.DOUBLE, (Object)0.0);
                    wrapper.write((Type)Types.FLOAT, (Object)Float.valueOf(entity.rotation().y()));
                    wrapper.write((Type)Types.FLOAT, (Object)Float.valueOf(entity.rotation().x()));
                    wrapper.write((Type)Types.BOOLEAN, (Object)entity.isOnGround());
                }
                return;
            }
            if (hasX) {
                entity.setPosition(new Position3f(((Float)wrapper.read((Type)BedrockTypes.FLOAT_LE)).floatValue(), entity.position().y(), entity.position().z()));
            }
            if (hasY) {
                entity.setPosition(new Position3f(entity.position().x(), ((Float)wrapper.read((Type)BedrockTypes.FLOAT_LE)).floatValue(), entity.position().z()));
            }
            if (hasZ) {
                entity.setPosition(new Position3f(entity.position().x(), entity.position().y(), ((Float)wrapper.read((Type)BedrockTypes.FLOAT_LE)).floatValue()));
            }
            if (hasPitch) {
                entity.setRotation(new Position3f(MathUtil.byte2Float((Byte)wrapper.read((Type)Types.BYTE)), entity.rotation().y(), entity.rotation().z()));
            }
            if (hasYaw) {
                entity.setRotation(new Position3f(entity.rotation().x(), MathUtil.byte2Float((Byte)wrapper.read((Type)Types.BYTE)), entity.rotation().z()));
            }
            if (hasHeadYaw) {
                entity.setRotation(new Position3f(entity.rotation().x(), entity.rotation().y(), MathUtil.byte2Float((Byte)wrapper.read((Type)Types.BYTE))));
                PacketFactory.sendJavaRotateHead(wrapper.user(), entity);
            }
            entity.setOnGround(onGround);
            wrapper.write((Type)Types.VAR_INT, (Object)entity.javaId());
            wrapper.write((Type)Types.DOUBLE, (Object)entity.position().x());
            wrapper.write((Type)Types.DOUBLE, (Object)((double)entity.position().y() - (double)entity.eyeOffset()));
            wrapper.write((Type)Types.DOUBLE, (Object)entity.position().z());
            wrapper.write((Type)Types.DOUBLE, (Object)0.0);
            wrapper.write((Type)Types.DOUBLE, (Object)0.0);
            wrapper.write((Type)Types.DOUBLE, (Object)0.0);
            wrapper.write((Type)Types.FLOAT, (Object)Float.valueOf(entity.rotation().y()));
            wrapper.write((Type)Types.FLOAT, (Object)Float.valueOf(entity.rotation().x()));
            wrapper.write((Type)Types.BOOLEAN, (Object)entity.isOnGround());
        });
        protocol.registerClientbound(ClientboundBedrockPackets.SET_ENTITY_MOTION, (ClientboundPacketType)ClientboundPackets1_21_9.SET_ENTITY_MOTION, wrapper -> {
            EntityTracker entityTracker = (EntityTracker)wrapper.user().get(EntityTracker.class);
            long runtimeEntityId = (Long)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_LONG);
            Position3f motion = (Position3f)wrapper.read(BedrockTypes.POSITION_3F);
            wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_LONG);
            Entity entity = entityTracker.getEntityByRid(runtimeEntityId);
            if (entity == null) {
                wrapper.cancel();
                return;
            }
            wrapper.write((Type)Types.VAR_INT, (Object)entity.javaId());
            wrapper.write(Types.MOVEMENT_VECTOR, (Object)new Vector3d((double)motion.x(), (double)motion.y(), (double)motion.z()));
        });
        protocol.registerClientbound(ClientboundBedrockPackets.REMOVE_ENTITY, (ClientboundPacketType)ClientboundPackets1_21_9.REMOVE_ENTITIES, wrapper -> {
            long uniqueEntityId;
            EntityTracker entityTracker = (EntityTracker)wrapper.user().get(EntityTracker.class);
            Entity entity = entityTracker.getEntityByUid(uniqueEntityId = ((Long)wrapper.read((Type)BedrockTypes.VAR_LONG)).longValue());
            if (entity == null) {
                wrapper.cancel();
                return;
            }
            entityTracker.removeEntity(entity);
            wrapper.write(Types.VAR_INT_ARRAY_PRIMITIVE, (Object)new int[]{entity.javaId()});
        });
        protocol.registerClientbound(ClientboundBedrockPackets.ADD_PAINTING, (ClientboundPacketType)ClientboundPackets1_21_9.ADD_ENTITY, wrapper -> {
            EntityTracker entityTracker = (EntityTracker)wrapper.user().get(EntityTracker.class);
            GameSessionStorage gameSession = (GameSessionStorage)wrapper.user().get(GameSessionStorage.class);
            CompoundTag paintingRegistry = gameSession.getJavaRegistries().getCompoundTag("minecraft:painting_variant");
            long uniqueEntityId = (Long)wrapper.read((Type)BedrockTypes.VAR_LONG);
            long runtimeEntityId = (Long)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_LONG);
            Position3f position = (Position3f)wrapper.read(BedrockTypes.POSITION_3F);
            Direction direction = Direction.getFromHorizontalId((Integer)wrapper.read((Type)BedrockTypes.VAR_INT), Direction.NORTH);
            String motive = (String)wrapper.read(BedrockTypes.STRING);
            String javaIdentifier = (String)BedrockProtocol.MAPPINGS.getBedrockToJavaPaintings().get((Object)motive);
            if (javaIdentifier == null) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unknown bedrock painting motive: " + motive);
                javaIdentifier = "minecraft:kebab";
            }
            CompoundTag paintingEntry = paintingRegistry.getCompoundTag(javaIdentifier);
            Holder paintingHolder = Holder.of((int)RegistryUtil.getRegistryIndex(paintingRegistry, paintingEntry));
            int width = paintingEntry.getInt("width");
            int height = paintingEntry.getInt("height");
            float widthOffset = width % 2 == 0 ? 0.5f : 0.0f;
            float heightOffset = height % 2 == 0 ? 0.5f : 0.0f;
            Position3f positionOffset = new Position3f(-0.5f, -0.5f, -0.5f);
            positionOffset = switch (direction) {
                case Direction.NORTH -> positionOffset.subtract(-widthOffset, heightOffset, 0.46875f);
                case Direction.EAST -> positionOffset.subtract(-0.46875f, heightOffset, -widthOffset);
                case Direction.SOUTH -> positionOffset.subtract(widthOffset, heightOffset, -0.46875f);
                case Direction.WEST -> positionOffset.subtract(0.46875f, heightOffset, widthOffset);
                default -> positionOffset;
            };
            Entity entity = entityTracker.addEntity(uniqueEntityId, runtimeEntityId, "minecraft:painting", EntityTypes1_21_9.PAINTING);
            entity.setPosition(position);
            wrapper.write((Type)Types.VAR_INT, (Object)entity.javaId());
            wrapper.write(Types.UUID, (Object)entity.javaUuid());
            wrapper.write((Type)Types.VAR_INT, (Object)entity.javaType().getId());
            wrapper.write((Type)Types.DOUBLE, (Object)((double)position.x() + (double)positionOffset.x()));
            wrapper.write((Type)Types.DOUBLE, (Object)((double)position.y() + (double)positionOffset.y()));
            wrapper.write((Type)Types.DOUBLE, (Object)((double)position.z() + (double)positionOffset.z()));
            wrapper.write(Types.MOVEMENT_VECTOR, (Object)Vector3d.ZERO);
            wrapper.write((Type)Types.BYTE, (Object)0);
            wrapper.write((Type)Types.BYTE, (Object)0);
            wrapper.write((Type)Types.BYTE, (Object)0);
            wrapper.write((Type)Types.VAR_INT, (Object)direction.verticalId());
            wrapper.send(BedrockProtocol.class);
            wrapper.cancel();
            PacketWrapper setEntityData = PacketWrapper.create((PacketType)ClientboundPackets1_21_9.SET_ENTITY_DATA, (UserConnection)wrapper.user());
            setEntityData.write((Type)Types.VAR_INT, (Object)entity.javaId());
            setEntityData.write(VersionedTypes.V1_21_9.entityDataList, (Object)Lists.newArrayList((Object[])new EntityData[]{new EntityData(entity.getJavaEntityDataIndex("PAINTING_VARIANT"), ((EntityDataTypes1_21_9)VersionedTypes.V1_21_9.entityDataTypes).paintingVariantType, (Object)paintingHolder)}));
            setEntityData.send(BedrockProtocol.class);
        });
        protocol.registerClientbound(ClientboundBedrockPackets.ENTITY_EVENT, (ClientboundPacketType)ClientboundPackets1_21_9.ENTITY_EVENT, wrapper -> {
            EntityTracker entityTracker = (EntityTracker)wrapper.user().get(EntityTracker.class);
            GameSessionStorage gameSession = (GameSessionStorage)wrapper.user().get(GameSessionStorage.class);
            long runtimeEntityId = (Long)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_LONG);
            byte rawEvent = (Byte)wrapper.read((Type)Types.BYTE);
            ActorEvent event = ActorEvent.getByValue(rawEvent);
            if (event == null) {
                wrapper.cancel();
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unknown ActorEvent: " + rawEvent);
                return;
            }
            int data = (Integer)wrapper.read((Type)BedrockTypes.VAR_INT);
            Entity entity = entityTracker.getEntityByRid(runtimeEntityId);
            if (entity == null) {
                wrapper.cancel();
                return;
            }
            switch (event) {
                case HURT: {
                    CompoundTag damageTypeRegistry = gameSession.getJavaRegistries().getCompoundTag("minecraft:damage_type");
                    SharedTypes_Legacy_ActorDamageCause damageCause = SharedTypes_Legacy_ActorDamageCause.getByValue(data, SharedTypes_Legacy_ActorDamageCause.Override);
                    CompoundTag damageTypeEntry = damageTypeRegistry.getCompoundTag(BedrockProtocol.MAPPINGS.getBedrockToJavaDamageCauses().get((Object)damageCause));
                    wrapper.setPacketType((PacketType)ClientboundPackets1_21_9.DAMAGE_EVENT);
                    wrapper.write((Type)Types.VAR_INT, (Object)entity.javaId());
                    wrapper.write((Type)Types.VAR_INT, (Object)RegistryUtil.getRegistryIndex(damageTypeRegistry, damageTypeEntry));
                    wrapper.write((Type)Types.VAR_INT, (Object)0);
                    wrapper.write((Type)Types.VAR_INT, (Object)0);
                    wrapper.write((Type)Types.BOOLEAN, (Object)false);
                    if (entity == entityTracker.getClientPlayer()) break;
                    entity.playSound(SharedTypes_Legacy_LevelSoundEvent.Hurt);
                    break;
                }
                case DEATH: {
                    wrapper.cancel();
                    if (entity instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity;
                        livingEntity.setHealth(0.0f);
                        livingEntity.sendAttribute("minecraft:health");
                    }
                    if (entity == entityTracker.getClientPlayer() && entityTracker.getClientPlayer().isDead() && gameSession.getDeathMessage() != null) {
                        PacketWrapper playerCombatKill = PacketWrapper.create((PacketType)ClientboundPackets1_21_9.PLAYER_COMBAT_KILL, (UserConnection)wrapper.user());
                        playerCombatKill.write((Type)Types.VAR_INT, (Object)entityTracker.getClientPlayer().javaId());
                        playerCombatKill.write(Types.TAG, (Object)TextUtil.textComponentToNbt(gameSession.getDeathMessage()));
                        playerCombatKill.send(BedrockProtocol.class);
                    }
                    if (entity == entityTracker.getClientPlayer()) break;
                    entity.playSound(SharedTypes_Legacy_LevelSoundEvent.Death);
                    break;
                }
                default: {
                    wrapper.cancel();
                }
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.UPDATE_ATTRIBUTES, (ClientboundPacketType)ClientboundPackets1_21_9.UPDATE_ATTRIBUTES, wrapper -> {
            EntityTracker entityTracker = (EntityTracker)wrapper.user().get(EntityTracker.class);
            long runtimeEntityId = (Long)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_LONG);
            EntityAttribute[] attributes = new EntityAttribute[((Integer)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_INT)).intValue()];
            for (int i = 0; i < attributes.length; ++i) {
                float minValue = ((Float)wrapper.read((Type)BedrockTypes.FLOAT_LE)).floatValue();
                float maxValue = ((Float)wrapper.read((Type)BedrockTypes.FLOAT_LE)).floatValue();
                float currentValue = ((Float)wrapper.read((Type)BedrockTypes.FLOAT_LE)).floatValue();
                float defaultMinValue = ((Float)wrapper.read((Type)BedrockTypes.FLOAT_LE)).floatValue();
                float defaultMaxValue = ((Float)wrapper.read((Type)BedrockTypes.FLOAT_LE)).floatValue();
                float defaultValue = ((Float)wrapper.read((Type)BedrockTypes.FLOAT_LE)).floatValue();
                String name = (String)wrapper.read(BedrockTypes.STRING);
                EntityAttribute.Modifier[] modifiers = new EntityAttribute.Modifier[((Integer)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_INT)).intValue()];
                for (int j = 0; j < modifiers.length; ++j) {
                    String id = (String)wrapper.read(BedrockTypes.STRING);
                    String modifierName = (String)wrapper.read(BedrockTypes.STRING);
                    float amount = ((Float)wrapper.read((Type)BedrockTypes.FLOAT_LE)).floatValue();
                    AttributeModifierOperation operation = AttributeModifierOperation.getByValue((Integer)wrapper.read((Type)BedrockTypes.INT_LE), AttributeModifierOperation.OPERATION_INVALID);
                    AttributeOperands operand = AttributeOperands.getByValue((Integer)wrapper.read((Type)BedrockTypes.INT_LE), AttributeOperands.OPERAND_INVALID);
                    boolean isSerializable = (Boolean)wrapper.read((Type)Types.BOOLEAN);
                    modifiers[j] = new EntityAttribute.Modifier(id, modifierName, amount, operation, operand, isSerializable);
                }
                attributes[i] = new EntityAttribute(name, currentValue, minValue, maxValue, defaultValue, defaultMinValue, defaultMaxValue, modifiers);
            }
            wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_LONG);
            Entity entity = entityTracker.getEntityByRid(runtimeEntityId);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.updateAttributes(attributes, wrapper);
            } else {
                wrapper.cancel();
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.SET_ENTITY_DATA, (ClientboundPacketType)ClientboundPackets1_21_9.SET_ENTITY_DATA, wrapper -> {
            EntityTracker entityTracker = (EntityTracker)wrapper.user().get(EntityTracker.class);
            long runtimeEntityId = (Long)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_LONG);
            EntityData[] entityData = (EntityData[])wrapper.read(BedrockTypes.ENTITY_DATA_ARRAY);
            EntityProperties entityProperties = (EntityProperties)wrapper.read(BedrockTypes.ENTITY_PROPERTIES);
            wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_LONG);
            Entity entity = entityTracker.getEntityByRid(runtimeEntityId);
            if (entity == null) {
                wrapper.cancel();
                return;
            }
            ArrayList<EntityData> javaEntityData = new ArrayList<EntityData>();
            entity.updateEntityData(entityData, javaEntityData);
            wrapper.write((Type)Types.VAR_INT, (Object)entity.javaId());
            wrapper.write(VersionedTypes.V1_21_9.entityDataList, javaEntityData);
        });
        protocol.registerClientbound(ClientboundBedrockPackets.MOB_EFFECT, (ClientboundPacketType)ClientboundPackets1_21_9.UPDATE_MOB_EFFECT, wrapper -> {
            LivingEntity livingEntity;
            int duration;
            boolean showParticles;
            int amplifier;
            int effectId;
            MobEffectPacketPayload_Event event;
            block10: {
                block9: {
                    long runtimeEntityId = (Long)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_LONG);
                    event = MobEffectPacketPayload_Event.getByValue(((Byte)wrapper.read((Type)Types.BYTE)).byteValue(), MobEffectPacketPayload_Event.Invalid);
                    effectId = (Integer)wrapper.read((Type)BedrockTypes.VAR_INT);
                    amplifier = (Integer)wrapper.read((Type)BedrockTypes.VAR_INT);
                    showParticles = (Boolean)wrapper.read((Type)Types.BOOLEAN);
                    duration = (Integer)wrapper.read((Type)BedrockTypes.VAR_INT);
                    wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_LONG);
                    Entity entity = ((EntityTracker)wrapper.user().get(EntityTracker.class)).getEntityByRid(runtimeEntityId);
                    if (!(entity instanceof LivingEntity)) break block9;
                    livingEntity = (LivingEntity)entity;
                    if (effectId != 0) break block10;
                }
                wrapper.cancel();
                return;
            }
            String bedrockIdentifier = (String)BedrockProtocol.MAPPINGS.getBedrockEffects().inverse().get((Object)effectId);
            if (bedrockIdentifier == null) {
                throw new IllegalStateException("Unknown bedrock effect: " + effectId);
            }
            EntityEffect effect = new EntityEffect(bedrockIdentifier, amplifier, duration, showParticles);
            switch (event) {
                case Invalid: {
                    wrapper.cancel();
                    break;
                }
                case Add: 
                case Update: {
                    livingEntity.updateEffect(effect, wrapper);
                    break;
                }
                case Remove: {
                    wrapper.setPacketType((PacketType)ClientboundPackets1_21_9.REMOVE_MOB_EFFECT);
                    livingEntity.removeEffect(bedrockIdentifier, wrapper);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled MobEffectPacketPayload_Event: " + String.valueOf((Object)event));
                }
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.ANIMATE, (ClientboundPacketType)ClientboundPackets1_21_9.ANIMATE, wrapper -> {
            AnimatePacket_Action action = AnimatePacket_Action.getByValue((Integer)wrapper.read((Type)BedrockTypes.VAR_INT), AnimatePacket_Action.NoAction);
            long runtimeEntityId = (Long)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_LONG);
            wrapper.read((Type)BedrockTypes.FLOAT_LE);
            Entity entity = ((EntityTracker)wrapper.user().get(EntityTracker.class)).getEntityByRid(runtimeEntityId);
            if (entity == null) {
                wrapper.cancel();
                return;
            }
            wrapper.write((Type)Types.VAR_INT, (Object)entity.javaId());
            wrapper.write((Type)Types.UNSIGNED_BYTE, (Object)((short)(switch (action) {
                case AnimatePacket_Action.NoAction, AnimatePacket_Action.RowLeft, AnimatePacket_Action.RowRight -> {
                    wrapper.cancel();
                    yield AnimateAction.SWING_MAIN_HAND;
                }
                case AnimatePacket_Action.Swing -> AnimateAction.SWING_MAIN_HAND;
                case AnimatePacket_Action.WakeUp -> {
                    if (entity instanceof ClientPlayerEntity) {
                        ClientPlayerEntity clientPlayer = (ClientPlayerEntity)entity;
                        clientPlayer.sendPlayerActionPacketToServer(PlayerActionType.StopSleeping);
                    }
                    yield AnimateAction.WAKE_UP;
                }
                case AnimatePacket_Action.CriticalHit -> AnimateAction.CRITICAL_HIT;
                case AnimatePacket_Action.MagicCriticalHit -> AnimateAction.MAGIC_CRITICAL_HIT;
                default -> throw new IllegalStateException("Unhandled AnimatePacket_Action: " + String.valueOf((Object)action));
            }).ordinal()));
        });
        protocol.registerClientbound(ClientboundBedrockPackets.MOB_ARMOR_EQUIPMENT, (ClientboundPacketType)ClientboundPackets1_21_9.SET_EQUIPMENT, wrapper -> {
            ItemRewriter itemRewriter = (ItemRewriter)wrapper.user().get(ItemRewriter.class);
            long runtimeEntityId = (Long)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_LONG);
            BedrockItem head = (BedrockItem)wrapper.read(itemRewriter.itemType());
            BedrockItem chest = (BedrockItem)wrapper.read(itemRewriter.itemType());
            BedrockItem legs = (BedrockItem)wrapper.read(itemRewriter.itemType());
            BedrockItem feet = (BedrockItem)wrapper.read(itemRewriter.itemType());
            BedrockItem body = (BedrockItem)wrapper.read(itemRewriter.itemType());
            Entity entity = ((EntityTracker)wrapper.user().get(EntityTracker.class)).getEntityByRid(runtimeEntityId);
            if (entity == null || entity instanceof ClientPlayerEntity) {
                wrapper.cancel();
                return;
            }
            wrapper.write((Type)Types.VAR_INT, (Object)entity.javaId());
            wrapper.write((Type)Types.BYTE, (Object)((byte)(EquipmentSlot.FEET.ordinal() | 0xFFFFFF80)));
            wrapper.write(VersionedTypes.V1_21_9.item, (Object)itemRewriter.javaItem(feet));
            wrapper.write((Type)Types.BYTE, (Object)((byte)(EquipmentSlot.LEGS.ordinal() | 0xFFFFFF80)));
            wrapper.write(VersionedTypes.V1_21_9.item, (Object)itemRewriter.javaItem(legs));
            wrapper.write((Type)Types.BYTE, (Object)((byte)(EquipmentSlot.CHEST.ordinal() | 0xFFFFFF80)));
            wrapper.write(VersionedTypes.V1_21_9.item, (Object)itemRewriter.javaItem(chest));
            wrapper.write((Type)Types.BYTE, (Object)((byte)(EquipmentSlot.HEAD.ordinal() | 0xFFFFFF80)));
            wrapper.write(VersionedTypes.V1_21_9.item, (Object)itemRewriter.javaItem(head));
            wrapper.write((Type)Types.BYTE, (Object)((byte)EquipmentSlot.BODY.ordinal()));
            wrapper.write(VersionedTypes.V1_21_9.item, (Object)itemRewriter.javaItem(body));
        });
        protocol.registerClientbound(ClientboundBedrockPackets.MOB_EQUIPMENT, (ClientboundPacketType)ClientboundPackets1_21_9.SET_EQUIPMENT, wrapper -> {
            ItemRewriter itemRewriter = (ItemRewriter)wrapper.user().get(ItemRewriter.class);
            long runtimeEntityId = (Long)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_LONG);
            BedrockItem item = (BedrockItem)wrapper.read(itemRewriter.itemType());
            byte slot = (Byte)wrapper.read((Type)Types.BYTE);
            byte selectedSlot = (Byte)wrapper.read((Type)Types.BYTE);
            byte containerId = (Byte)wrapper.read((Type)Types.BYTE);
            Entity entity = ((EntityTracker)wrapper.user().get(EntityTracker.class)).getEntityByRid(runtimeEntityId);
            if (entity == null || entity instanceof ClientPlayerEntity) {
                wrapper.cancel();
                return;
            }
            wrapper.write((Type)Types.VAR_INT, (Object)entity.javaId());
            if (containerId == ContainerID.CONTAINER_ID_INVENTORY.getValue() && slot >= 0 && slot < 9 && (slot == selectedSlot || selectedSlot < 0)) {
                wrapper.write((Type)Types.BYTE, (Object)((byte)EquipmentSlot.MAINHAND.ordinal()));
                wrapper.write(VersionedTypes.V1_21_9.item, (Object)itemRewriter.javaItem(item));
            } else if (containerId == ContainerID.CONTAINER_ID_OFFHAND.getValue()) {
                wrapper.write((Type)Types.BYTE, (Object)((byte)EquipmentSlot.OFFHAND.ordinal()));
                wrapper.write(VersionedTypes.V1_21_9.item, (Object)itemRewriter.javaItem(item));
            } else {
                wrapper.cancel();
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.TAKE_ITEM_ENTITY, (ClientboundPacketType)ClientboundPackets1_21_9.TAKE_ITEM_ENTITY, wrapper -> {
            EntityTracker entityTracker = (EntityTracker)wrapper.user().get(EntityTracker.class);
            long itemRuntimeEntityId = (Long)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_LONG);
            long collectorRuntimeEntityId = (Long)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_LONG);
            Entity itemEntity = entityTracker.getEntityByRid(itemRuntimeEntityId);
            Entity collectorEntity = entityTracker.getEntityByRid(collectorRuntimeEntityId);
            if (itemEntity == null || collectorEntity == null || itemEntity.javaType() != EntityTypes1_21_9.ITEM) {
                wrapper.cancel();
                return;
            }
            wrapper.write((Type)Types.VAR_INT, (Object)itemEntity.javaId());
            wrapper.write((Type)Types.VAR_INT, (Object)collectorEntity.javaId());
            wrapper.write((Type)Types.VAR_INT, (Object)0);
        });
    }
}

